/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.transformation.moser.GenerateJoinGraph;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.UndirectedGraph;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class TabStreamExternalAggrUtil {
    public static final String EXT_AGGR_ENABLE = "enableExtAggrAvoidSummaryDoubleCounting";
    protected static final String LEFT_ID = "leftId";
    protected static final String RIGHT_ID = "rightId";
    protected static final String CARDINALITY = "cardinality";
    protected static final String ONE = "1";
    protected static final String MANY = "N";

    public static boolean supportExternalAggrAvoidDoubleCounting(MetadataConnection metadataConnection) {
        if (!(metadataConnection instanceof MoserMetadataConnection)) {
            return false;
        }
        MoserMetadataConnection moserMC = (MoserMetadataConnection)metadataConnection;
        return moserMC.getPackages().isEmpty();
    }

    public static boolean measureNeedExtAggr(TabStreamUtil.WrapCommonObjects env, V5DataItem measureItem, boolean[] bForce) {
        IXQEQueryNode[] tabDIs;
        bForce[0] = false;
        String rollUpType = measureItem.getRollupAggregateProperty();
        if ("calculated".equals(rollUpType)) {
            return true;
        }
        Boolean b = (Boolean)env.mV5Query.getPropertyValue(EXT_AGGR_ENABLE);
        if (!Boolean.TRUE.equals(b)) {
            return false;
        }
        String orgRollUpType = (String)measureItem.getPropertyValue("orgRollupAggregate");
        if (!"calculated".equals(orgRollUpType) && !"automatic".equals(orgRollUpType)) {
            return false;
        }
        if (!("total".equals(rollUpType) || "count".equals(rollUpType) || "average".equals(rollUpType))) {
            return false;
        }
        JSONObject joinGraph = TabStreamExternalAggrUtil.getJoinGraphMetadataConnection(env);
        if (joinGraph == null || joinGraph.isEmpty()) {
            return false;
        }
        HashMap<String, Set<String>> queryItemToGroup = new HashMap<String, Set<String>>();
        Object oQI = joinGraph.get((Object)"queryitem");
        if (oQI == null) {
            return false;
        }
        JSONArray jQI = (JSONArray)oQI;
        for (Object o : jQI) {
            JSONObject qi = (JSONObject)o;
            for (Object k : qi.keySet()) {
                String kName = (String)k;
                JSONArray v = (JSONArray)qi.get(k);
                HashSet<String> s = (HashSet<String>)queryItemToGroup.get(kName);
                if (s == null) {
                    s = new HashSet<String>();
                    queryItemToGroup.put(kName, s);
                }
                for (Object g : v) {
                    s.add((String)g);
                }
            }
        }
        HashSet<String> thisGrp = new HashSet<String>();
        HashSet<IMetadata> measureObjs = new HashSet<IMetadata>();
        TabStreamUtil.getWrapperObject(measureItem, measureObjs);
        for (IMetadata meta : measureObjs) {
            IXQEQueryNode[] measureObj = (IXQEQueryNode[])meta;
            V5DataItem orgItem = TabStreamUtil.getOriginalMeasureV5DataItem(env, (V5DataItemToMeasureWrapper)measureObj, measureItem);
            Set<String> grps = TabStreamExternalAggrUtil.getGroupsFromExpression(orgItem, queryItemToGroup);
            thisGrp.addAll(grps);
        }
        if (thisGrp.isEmpty()) {
            return false;
        }
        HashSet<String> dimGrps = new HashSet<String>();
        for (IXQEQueryNode a : tabDIs = env.mTabQuery.getV5Selection().getChildrenOfType(101003)) {
            Set<String> aGrps = TabStreamExternalAggrUtil.getGroupsFromExpression(a, queryItemToGroup);
            V5DataItem aDI = (V5DataItem)a;
            if (TabStreamUtil.isFactItem(aDI)) continue;
            dimGrps.addAll(aGrps);
        }
        Object oConn = joinGraph.get((Object)"connector");
        if (oConn == null) {
            return false;
        }
        JSONArray jConn = (JSONArray)oConn;
        UndirectedGraph newGraph = new UndirectedGraph(env.mEnvironment.getMetadataConnection().getModelPath());
        for (int i = 0; i < jConn.size(); ++i) {
            JSONObject c = (JSONObject)jConn.get(i);
            String leftID = (String)c.get((Object)LEFT_ID);
            String rightID = (String)c.get((Object)RIGHT_ID);
            newGraph.addNode(leftID);
            newGraph.addNode(rightID);
            RQPJoinPathFinder.Weight w = RQPJoinPathFinder.Weight.Default;
            String card = (String)c.get((Object)CARDINALITY);
            if ("1:1".equals(card)) {
                w = RQPJoinPathFinder.Weight.Shortcut;
            }
            newGraph.addEdge(String.valueOf(i), leftID, rightID, w.getWeight(), false);
        }
        int[] totalWeight = new int[1];
        boolean bRT = false;
        for (String thisG : thisGrp) {
            for (String dimG : dimGrps) {
                if (thisG.equals(dimG)) continue;
                ArrayList<String> path = new ArrayList<String>();
                try {
                    newGraph.getShortestPath(thisG, dimG, path, totalWeight);
                }
                catch (Exception e) {
                    return false;
                }
                if (path.isEmpty()) {
                    return false;
                }
                if (!TabStreamExternalAggrUtil.hasOneToMany(thisG, new HashSet<String>(path), jConn)) continue;
                bForce[0] = true;
                bRT = true;
            }
        }
        return bRT;
    }

    public static void markExternalAggregate(V5DataItem measureItem) {
        IXQEQueryNode[] boundIds;
        measureItem.setRollupAggregateProperty("calculated");
        HashSet<IMetadata> measureObjs = new HashSet<IMetadata>();
        TabStreamUtil.getWrapperObject(measureItem, measureObjs);
        for (IMetadata aMeta : measureObjs) {
            V5DataItemToMeasureWrapper aMeasureObj = (V5DataItemToMeasureWrapper)aMeta;
            aMeasureObj.setRegularAggregate(AggregateTypeEnum.CALCULATED);
        }
        for (IXQEQueryNode aBound : boundIds = measureItem.getDescendantsOfType(201116, false)) {
            V5BoundModelIdentifier boundModelId = (V5BoundModelIdentifier)aBound;
            boundModelId.setRollupAggregate(V5RollupAggregateEnum.CALCULATED);
        }
    }

    protected static boolean hasOneToMany(String st, Set<String> path, JSONArray jConn) {
        if (path.isEmpty() || st == null) {
            return false;
        }
        String[] other = new String[]{null};
        if (TabStreamExternalAggrUtil.otherIsMany(st, path, jConn, other)) {
            return true;
        }
        return TabStreamExternalAggrUtil.hasOneToMany(other[0], path, jConn);
    }

    protected static boolean otherIsMany(String st, Set<String> path, JSONArray jConn, String[] other) {
        for (String p : path) {
            int pos = Integer.parseInt(p);
            JSONObject c = (JSONObject)jConn.get(pos);
            String leftID = (String)c.get((Object)LEFT_ID);
            String rightID = (String)c.get((Object)RIGHT_ID);
            String card = (String)c.get((Object)CARDINALITY);
            if (!st.equals(leftID) && !st.equals(rightID)) continue;
            path.remove(p);
            String[] parts = card.split(":");
            if (st.equals(leftID)) {
                other[0] = rightID;
                if (MANY.equals(parts[1])) {
                    return true;
                }
            } else {
                other[0] = leftID;
                if (MANY.equals(parts[0])) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected static Set<String> getGroupsFromExpression(IXQEQueryNode node, HashMap<String, Set<String>> queryItemToGroup) {
        IXQEQueryNode[] mdObjs;
        HashSet<String> rt = new HashSet<String>();
        for (IXQEQueryNode mdO : mdObjs = node.getDescendantsOfType(201116, false)) {
            Set<String> gps;
            V5BoundModelIdentifier boundO = (V5BoundModelIdentifier)mdO;
            IMetadata md = boundO.getMetadata();
            if (md == null) continue;
            String id = md.getID();
            if (md instanceof MoserBaseMetadata) {
                id = MoserUtil.getIdForExpression((MoserBaseMetadata)((Object)md));
            }
            if ((gps = queryItemToGroup.get(id)) == null) continue;
            rt.addAll(gps);
        }
        return rt;
    }

    protected static JSONObject getJoinGraphMetadataConnection(TabStreamUtil.WrapCommonObjects env) {
        MetadataConnection mc = env.mEnvironment.getMetadataConnection();
        if (mc == null) {
            return null;
        }
        String sJoinGraph = mc.getJoinGraph();
        if (sJoinGraph != null) {
            return TabStreamExternalAggrUtil.getJoinGraphJSON(sJoinGraph);
        }
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(env.mEnvironment.getRequestEnvironment());
        PlanningEnvironment subPlanEnv = V5SubQueryBuilder.createPlanningEnvironment((ExecutionEnvironment)env.mEnvironment.getExecutionEnvironment(), planEnv);
        sJoinGraph = GenerateJoinGraph.getJoinGraphMetdataConnection(subPlanEnv, mc, env.mQuerySet.getModelPath(), new ArrayList<String>(), false, false);
        if (sJoinGraph == null) {
            return null;
        }
        return TabStreamExternalAggrUtil.getJoinGraphJSON(sJoinGraph);
    }

    protected static JSONObject getJoinGraphJSON(String sJoinGraph) {
        try {
            return OrderedJSONObject.parse((String)sJoinGraph);
        }
        catch (Exception e) {
            return null;
        }
    }
}

