/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.DummyRelationalDataSource;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public final class TabStreamUtil {
    public static final String DUMMY_MEASURE_NAME = "TBDummyMeasureName";
    public static final String STITCH_TYPE = "stitchingType";
    public static final String SUPPRESS_NULLS_SIBLINGS = "suppressNullsForSiblings";
    public static final String DATA_ITEM_NAME_PROPERTY = "dataItemName";
    public static final String NEED_TABSTREAM = "needTabularStream";
    public static final String TABQUERY_DEFINITION = "tabstreamDefinition";
    public static final String SUBTTABQUERY_POSTFIX = "_subTabularResult";
    public static final String WRAPTO = "wrapTo";
    public static final String DIM_PREFIX = "TBdimension_";
    public static final String HIER_PREFIX = "TBhierarchy_";
    public static final String LEVEL_PREFIX = "TBlevel_";
    public static final String PROPERTY_PREFIX = "TBproperty_";
    public static final String MEASURE_PREFIX = "TBmeasure_";
    public static final String AGGREGATE_PREFIX = "TBAggregate_";
    public static final String FACT_PREFIX = "FACTITEM_";
    public static final String ROLLUP_PREFIX = "ROLLUP_";
    public static final String SCOPE = "scope";
    public static final String RELXTAB = "relationalCrossTab";
    public static final String LEVELKEY = "LEVELKEY";
    public static final String NEED_DECOMPOSE = "needDecompose";
    public static final int FLAG_NUMERIC_OP = 1;
    public static final int FLAG_BOOLANDOLAP_OP = 2;
    public static final int FLAG_BOOL_OP = 4;
    public static final String DUMMY_CMDS = "aDummyCMDataSourceNameForRelXTab";
    public static final String DATAITEM_MD_OPTIMIZE = "itemMDOptimize";
    public static final String SAME_LEVEL_VALUESTS = "sameLevelValueSets";
    public static final String FROM_CALCULATION = "fromModelCalculation";
    public static final String ROLLUP_GROUPING_ITEMS = "rollupGroupingItems";

    public static boolean isFactItem(V5DataItem dataItem) {
        V5DataItem orgDI;
        Boolean b = (Boolean)dataItem.getPropertyValue("factItem");
        if (b != null && b == Boolean.TRUE) {
            return true;
        }
        String rollAggr = dataItem.getRollupAggregateProperty();
        if ("automatic".equals(rollAggr) && (orgDI = dataItem.getOriginalV5DataItem()) != null) {
            return TabStreamUtil.isFactItem(orgDI);
        }
        return !"none".equals(rollAggr);
    }

    public static void collectItemsInGroupBodySort(IXQEQueryNode valueSet, TreeSet<String> itemsInBodySort) {
        IXQEQueryNode[] sorts;
        IXQEQueryNode[] groupBodys;
        String refDataItemName = ((V5ValueSet)valueSet).getRefDataItemProperty();
        for (IXQEQueryNode aBody : groupBodys = valueSet.getChildrenOfType(101051)) {
            IXQEQueryNode[] refItems;
            V5GroupBody groupBody = (V5GroupBody)aBody;
            for (IXQEQueryNode aItem : refItems = groupBody.getChildrenOfType(101015)) {
                V5DataItemRef ref = (V5DataItemRef)aItem;
                String refName = ref.getDataItemRefProperty();
                if (refDataItemName == null || refDataItemName.equals(refName)) continue;
                itemsInBodySort.add(refName);
            }
        }
        for (IXQEQueryNode aSort : sorts = valueSet.getChildrenOfType(101056)) {
            String refName = ((V5SortItem)aSort).getRefDataItem();
            if (refDataItemName == null || refDataItemName.equals(refName)) continue;
            itemsInBodySort.add(refName);
        }
    }

    public static boolean itemUsedByGroupBody(IXQEQueryNode valueSet, String itemName) {
        IXQEQueryNode[] groupBodys;
        for (IXQEQueryNode aBody : groupBodys = valueSet.getChildrenOfType(101051)) {
            IXQEQueryNode[] refItems;
            V5GroupBody groupBody = (V5GroupBody)aBody;
            for (IXQEQueryNode aItem : refItems = groupBody.getChildrenOfType(101015)) {
                V5DataItemRef ref = (V5DataItemRef)aItem;
                String refName = ref.getDataItemRefProperty();
                if (!refName.equals(itemName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Dimension createDimensionWrapper(CubeWrapper cube) {
        int dimId = cube.getDimensions().size() - 1;
        return TabStreamUtil.createDimensionWrapper(cube, Integer.toString(dimId));
    }

    public static Dimension createDimensionWrapper(CubeWrapper cube, String name) {
        Dimension dimension = new Dimension(DIM_PREFIX + name);
        dimension.setType(DimensionTypeEnum.REGULAR);
        dimension.setProperty("isManual", "true");
        dimension.setConnection(cube.getConnection());
        cube.addDimension(dimension);
        dimension.setMembersRollup(false);
        Hierarchy hierarchy = new Hierarchy(HIER_PREFIX + name);
        hierarchy.setDimension(dimension);
        hierarchy.setProperty("isManual", "true");
        dimension.addHierarchy(hierarchy);
        dimension.setDefaultHierarchy(hierarchy);
        Level level = (Level)hierarchy.getLevel(0);
        level.setProperty("isManual", "true");
        Member allMember = new Member("all");
        allMember.setUniqueName(UniqueNameGenerator.appendUniqueName(hierarchy.getUniqueName(), "all"));
        level.addMember(allMember, allMember);
        level.addChildMetadataObject(allMember);
        hierarchy.setDefaultMember(allMember);
        return dimension;
    }

    public static Integer getDataItemPos(V5Selection selection, String dataItem) {
        IXQEQueryNode[] items = selection.getChildrenOfType(101003);
        for (int i = 0; i < items.length; ++i) {
            V5DataItem v5DataItem = (V5DataItem)items[i];
            if (!v5DataItem.getNameProperty().equals(dataItem)) continue;
            return XQEIntegerPool.getInteger(i);
        }
        return null;
    }

    protected static boolean isMDOpObject(IXQEQueryNode exprNode) {
        int type = exprNode.getType();
        return type == 101003 || type == 201097 || exprNode.isOfCategory(201116);
    }

    protected static void propagateExprNodeSummaries(WrapCommonObjects env, PlanningEnvironment environment, IXQENodeFactory factory, IXQEQueryNode exprNode, ArrayList<V5DataItemToLevelWrapper> scopeLevels) {
        IXQEQueryNode[] children;
        if (TabStreamUtil.isMDOpObject(exprNode)) {
            if (exprNode.getType() == 101003) {
                TabStreamUtil.propagateDataItemSummaries(environment, factory, (V5DataItem)exprNode);
            } else if (exprNode.getType() == 201097) {
                TabStreamUtil.propagateQueryItemReferenceSummaries(environment, factory, (V5BoundQueryItemReference)exprNode);
            } else if (exprNode.isOfCategory(201116)) {
                TabStreamUtil.propagateModelIdentifierSummaries(env, environment, factory, (V5BoundModelIdentifier)exprNode, scopeLevels);
            }
        }
        if (exprNode.getType() == 201031) {
            return;
        }
        for (IXQEQueryNode child : children = exprNode.getChildren()) {
            TabStreamUtil.propagateExprNodeSummaries(env, environment, factory, child, scopeLevels);
        }
    }

    protected static void propagateDataItemSummaries(PlanningEnvironment planningEnvironment, IXQENodeFactory factory, V5DataItem dataItem) {
        String aggrType;
        if (!TabStreamUtil.isFactItem(dataItem)) {
            return;
        }
        IXQEQueryNode expr = dataItem.getChild(0);
        if (expr.getType() == 101004) {
            expr = expr.getChild(0);
        }
        if ((aggrType = dataItem.getAggregateProperty()).equals("calculated")) {
            return;
        }
        if (expr.getType() == 201031) {
            IXQEQueryNode[] forclauses = expr.getDescendantsOfType(201037, true);
            if (forclauses.length == 0) {
                return;
            }
            for (IXQEQueryNode forclause : forclauses) {
                forclause.detach();
            }
        }
        IXQEQueryNode sum = TabStreamUtil.createAggregateFunction(planningEnvironment, factory, dataItem.getNameProperty(), aggrType, dataItem.getDataType());
        expr.insertParent(sum);
    }

    protected static void propagateQueryItemReferenceSummaries(PlanningEnvironment planningEnvironment, IXQENodeFactory factory, V5BoundQueryItemReference queryItemRef) {
        V5DataItem v5DataItem = queryItemRef.getRefDataItem();
        if (v5DataItem == null || !TabStreamUtil.isFactItem(v5DataItem)) {
            return;
        }
        String aggrType = v5DataItem.getAggregateProperty();
        if (aggrType.equals("calculated")) {
            aggrType = "minimum";
        }
        IXQEQueryNode sum = TabStreamUtil.createAggregateFunction(planningEnvironment, factory, v5DataItem.getNameProperty(), aggrType, v5DataItem.getDataType());
        queryItemRef.insertParent(sum);
    }

    protected static void propagateModelIdentifierSummaries(WrapCommonObjects env, PlanningEnvironment environment, IXQENodeFactory factory, V5BoundModelIdentifier node, ArrayList<V5DataItemToLevelWrapper> scopeLevels) {
        RefineAutomaticXtab.AggrTypeEnum aggr;
        String aggrType;
        IXQEQueryNode parent = node.getParent();
        int type = parent.getType();
        if (type == 101004 || type == 101003) {
            parent = null;
        }
        if ((aggrType = (aggr = RefineAutomaticXtab.determineModelDrivenAggregation(environment, node, parent)).getV5Name()).equals("none") && scopeLevels != null) {
            IXQEQueryNode nonFactToCheck = node;
            if (node.getParent() != null && node.getParent().getType() == 101003) {
                nonFactToCheck = node.getParent();
            }
            Object r = TabStreamUtil.getExistingLevelOrLevelPropertyWrapper(env, nonFactToCheck);
            boolean bError = false;
            if (r == null) {
                bError = true;
            } else if (r instanceof V5DataItemToLevelWrapper) {
                if (TabStreamUtil.checkLevelForUniqueValue(scopeLevels, (V5DataItemToLevelWrapper)r)) {
                    return;
                }
                bError = true;
            } else {
                V5DataItemToLevelAttributeWrapper attrObj = (V5DataItemToLevelAttributeWrapper)r;
                if (!TabStreamUtil.checkLevelForUniqueValue(scopeLevels, (V5DataItemToLevelWrapper)attrObj.getLevel())) {
                    bError = true;
                }
            }
            if (bError) {
                String objname = null;
                objname = nonFactToCheck.getType() == 101003 ? "[" + ((V5DataItem)nonFactToCheck).getNameProperty() + "]" : node.getIdentifier();
                V5SummaryFilter flt = (V5SummaryFilter)nonFactToCheck.getAncestorOfType(101011);
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_NonAggrObjectSummaryFilter, objname, flt.getOriginalExpression(), env.mV5Query.getV5QueryName());
            }
        }
        if (aggrType.equals("none") || aggrType.equals("summarize") || aggrType.equals("calculated")) {
            aggrType = "minimum";
        }
        IXQEQueryNode sum = TabStreamUtil.createAggregateFunction(environment, factory, node.getIdentifier(), aggrType, node.getDataType());
        node.insertParent(sum);
    }

    protected static boolean checkLevelForUniqueValue(ArrayList<V5DataItemToLevelWrapper> scopeLevels, V5DataItemToLevelWrapper level) {
        for (V5DataItemToLevelWrapper lvl : scopeLevels) {
            if (lvl == level) {
                return true;
            }
            for (V5DataItemToLevelWrapper p = (V5DataItemToLevelWrapper)lvl.getPreviousLevel(); p != null; p = (V5DataItemToLevelWrapper)p.getPreviousLevel()) {
                if (p != level) continue;
                return true;
            }
        }
        return false;
    }

    protected static IXQEQueryNode createAggregateFunction(PlanningEnvironment planningEnvironment, IXQENodeFactory factory, String itemName, String aggr, IDataType dataType) {
        IXQEQueryNode aggrFunc = factory.createNode(201031);
        AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(planningEnvironment, itemName, aggr, (V5ValueSummaryFunction)aggrFunc, dataType);
        return aggrFunc;
    }

    public static void transformExprNodeSummariesRemoveRefDataItems(WrapCommonObjects env, V5Selection selection, IXQEQueryNode exprNode, List<String> forclause, ArrayList<V5DataItemToLevelWrapper> scopeLevels) {
        LinkedList<IXQEQueryNode> stack = new LinkedList<IXQEQueryNode>();
        HashSet<IXQEQueryNode> modifiedDataItems = new HashSet<IXQEQueryNode>();
        TabStreamUtil.transformExprNodeSummaries(env, selection, exprNode, forclause, stack, modifiedDataItems, scopeLevels);
        for (IXQEQueryNode item : modifiedDataItems) {
            item.extract();
        }
    }

    private static void transformExprNodeSummaries(WrapCommonObjects env, V5Selection selection, IXQEQueryNode exprNode, List<String> forclause, LinkedList<IXQEQueryNode> stack, HashSet<IXQEQueryNode> modifiedDataItems, ArrayList<V5DataItemToLevelWrapper> scopeLevels) {
        IXQEQueryNode[] children;
        V5ValueSummaryFunction aggr;
        int subType;
        if (exprNode.getType() == 101003) {
            stack.addLast(exprNode);
        }
        if (TabStreamUtil.isMDOpObject(exprNode)) {
            TabStreamUtil.propagateExprNodeSummaries(env, env.mEnvironment, env.mFactory, exprNode, scopeLevels);
        }
        if (exprNode.getType() == 201031 && (subType = (aggr = (V5ValueSummaryFunction)exprNode).getSubType()) >= 1 && subType <= 20) {
            List<IXQEQueryNode> childAggrs = exprNode.getDescendantsOfTypeOrdered(201031, false);
            boolean bChanged = TabStreamUtil.addForClauseIfRequired(env, selection, aggr, forclause);
            Collections.reverse(childAggrs);
            for (IXQEQueryNode childAggr : childAggrs) {
                V5ValueSummaryFunction a = (V5ValueSummaryFunction)childAggr;
                int s = a.getSubType();
                if (s < 1 || s > 20 || !TabStreamUtil.addForClauseIfRequired(env, selection, a, forclause)) continue;
                bChanged = true;
            }
            if (bChanged) {
                modifiedDataItems.addAll(stack);
            }
            return;
        }
        for (IXQEQueryNode child : children = exprNode.getChildren()) {
            TabStreamUtil.transformExprNodeSummaries(env, selection, child, forclause, stack, modifiedDataItems, scopeLevels);
        }
        if (exprNode.getType() == 101003) {
            stack.removeLast();
        }
    }

    private static boolean addForClauseIfRequired(WrapCommonObjects env, V5Selection selection, V5ValueSummaryFunction aggr, List<String> forclause) {
        IXQEQueryNode forNode = aggr.getFirstChildByType(201037);
        if (forNode == null) {
            forNode = env.mFactory.createNode(201037);
            aggr.addChild(forNode);
        } else {
            V5AggregateBreakClause breakClause = (V5AggregateBreakClause)forNode;
            if (breakClause.getSubType() == 0 || breakClause.getNumberChildren() > 0) {
                List<IXQEQueryNode> mdOpItems = env.getMDOptimizaeItems();
                if (mdOpItems.isEmpty()) {
                    return false;
                }
                if (breakClause.getSubType() == 0) {
                    breakClause.setSubType(2);
                }
                for (IXQEQueryNode mdDI : mdOpItems) {
                    breakClause.addChild(env.mFactory.deepCopyNode(mdDI));
                }
                return true;
            }
        }
        ArrayList<String> forclauseMDLinks = new ArrayList<String>();
        ArrayList seen = (ArrayList)selection.getPropertyValue(SCOPE);
        if (seen != null) {
            ArrayList projed = (ArrayList)selection.getPropertyValue(RELXTAB);
            for (String mdLink : seen) {
                if (projed != null && projed.contains(mdLink)) continue;
                forclauseMDLinks.add(mdLink);
            }
        }
        if (forclause.isEmpty() && forclauseMDLinks.isEmpty()) {
            ((V5AggregateBreakClause)forNode).setSubType(0);
        } else {
            for (String mdLink : forclauseMDLinks) {
                forNode.addChild(env.mFactory.deepCopyNode(selection.getDataItemByRefName(mdLink)));
            }
            for (String item : forclause) {
                forNode.addChild(env.mFactory.deepCopyNode(selection.getDataItemByRefName(item)));
            }
        }
        return true;
    }

    public static RSAPIDataItem getRSAPIDataItemByName(IXQEQueryNode rsapiNode, String edgeName, String rowsetSetName, String itemName) {
        RSAPIEdge[] rsapiEdges;
        if (rsapiNode.getType() != 401005) {
            return null;
        }
        block0: for (RSAPIEdge aEdge : rsapiEdges = ((RSAPIDataset)rsapiNode).getEdges()) {
            RSAPIEdgeRowset[] rowsets;
            if (!aEdge.getName().equals(edgeName)) continue;
            for (RSAPIEdgeRowset aRowset : rowsets = aEdge.getRowsets()) {
                RSAPIDataItem[] items;
                if (!aRowset.getName().equals(rowsetSetName)) continue;
                for (RSAPIDataItem item : items = aRowset.getDataItems()) {
                    if (!item.getName().equals(itemName)) continue;
                    return item;
                }
                break block0;
            }
            break;
        }
        return null;
    }

    public static WrapCommonObjects createCommonObjectsWrapper(PlanningEnvironment environment, V5Query v5Query) {
        TabStreamUtil util = new TabStreamUtil();
        WrapCommonObjects env = util.new WrapCommonObjects();
        env.mEnvironment = environment;
        env.mFactory = environment.getNodeFactory();
        env.mV5Query = v5Query;
        env.mQuerySet = (V5QuerySet)env.mV5Query.getAncestorOfType(101002);
        env.mQRD = TabStreamUtil.getReferencedQRD(env.mQuerySet, env.mV5Query);
        env.mSelection = env.mV5Query.getV5Selection();
        env.mCube = (CubeWrapper)env.mV5Query.getV5Source().getPropertyValue(NEED_TABSTREAM);
        String subName = env.mCube.getTabularResultSetName();
        env.mTabQuery = env.mQuerySet.getV5Query(subName);
        env.mTabSelection = env.mTabQuery.getV5Selection();
        RSAPIDataset rsapiDataset = (RSAPIDataset)env.mTabQuery.getFirstChildByType(401005);
        IXQEQueryNode[] tabGroupBody = rsapiDataset.getDescendantsOfType(101051, false);
        env.mTabGroupBody = tabGroupBody[0];
        return env;
    }

    public static V5QueryResultDefinition getReferencedQRD(V5QuerySet querySet, V5Query v5Query) {
        List<IXQEQueryNode> qrds = querySet.getDescendantsOfTypeOrdered(101055, false);
        for (IXQEQueryNode node : qrds) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
            if (qrd.getPropertyValue(RELXTAB) == null || qrd.getV5Query() != v5Query) continue;
            return qrd;
        }
        return null;
    }

    public static WrapCommonObjects createCommonObjectsWrapper(PlanningEnvironment environment, V5QueryResultDefinition qrd) {
        TabStreamUtil util = new TabStreamUtil();
        WrapCommonObjects env = util.new WrapCommonObjects();
        env.mEnvironment = environment;
        env.mFactory = environment.getNodeFactory();
        env.mQRD = qrd;
        env.mRsapiNode = env.mQRD.getAncestorOfType(401005);
        env.mV5Query = env.mQRD.getV5Query();
        env.mQuerySet = (V5QuerySet)env.mQRD.getAncestorOfType(101002);
        env.mSelection = env.mV5Query.getV5Selection();
        env.mCube = (CubeWrapper)env.mV5Query.getV5Source().getPropertyValue(NEED_TABSTREAM);
        String subName = env.mCube.getTabularResultSetName();
        env.mTabQuery = env.mQuerySet.getV5Query(subName);
        env.mTabSelection = env.mTabQuery.getV5Selection();
        RSAPIDataset rsapiDataset = (RSAPIDataset)env.mTabQuery.getFirstChildByType(401005);
        IXQEQueryNode[] tabGroupBody = rsapiDataset.getDescendantsOfType(101051, false);
        env.mTabGroupBody = tabGroupBody[0];
        return env;
    }

    public static void addItemToListQuery(WrapCommonObjects env, V5DataItem subItem) {
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)env.mTabGroupBody.getParent().getPropertyValue("RSAPIEdgeRowset");
        String subItemName = subItem.getNameProperty();
        int colIdx = env.mTabSelection.getChildrenOfType(101003).length;
        env.mTabSelection.addChild(subItem);
        IXQEQueryNode dataItemRef = env.mFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", subItemName);
        env.mTabGroupBody.addChild(dataItemRef);
        rowset.setDataItem(colIdx, RSAPIUtilities.transferV5DataItemToRSAPIDataItem((V5DataItemRef)dataItemRef, env.mTabSelection, true));
    }

    public static boolean needDecompose(PlanningEnvironment environment, V5DataItem dataItem) {
        String aggr = dataItem.getAggregateProperty();
        if (RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(aggr) != RefineAutomaticXtab.AggrTypeEnum.CALCULATED) {
            return false;
        }
        return TabStreamUtil.needDecomposeExpression(environment, dataItem.getChild(0), false, 1, RefineAutomaticXtab.AggrTypeEnum.CALCULATED);
    }

    public static void getNonFactsAndFactsInExpression(PlanningEnvironment environment, IXQEQueryNode expr, boolean bAfterDecompPoint, int sepRules, RefineAutomaticXtab.AggrTypeEnum defaultAggr, ArrayList<IXQEQueryNode> nonFacts, ArrayList<IXQEQueryNode> facts) {
        if (expr.getType() == 101004) {
            expr = expr.getChild(0);
        }
        if (!TabStreamUtil.useMetadataObjects(expr, false)) {
            return;
        }
        boolean bDecompPoint = false;
        if (expr.isOfCategory(201120)) {
            V5SimpleNode simpleNode = (V5SimpleNode)expr;
            bDecompPoint = TabStreamUtil.checkDecomposePoint(simpleNode, sepRules);
        }
        if (!bDecompPoint) {
            IXQEQueryNode[] descendants = expr.getDescendantsOfTypes(new int[]{201060, 101003}, false);
            int n = 0;
            IXQEQueryNode[] iXQEQueryNodeArray = descendants;
            int n2 = iXQEQueryNodeArray.length;
            for (int i = 0; i < n2; ++i) {
                V5BoundDataItemReference ref;
                IXQEQueryNode c = iXQEQueryNodeArray[i];
                int tp = c.getType();
                if (tp == 201060 && (ref = (V5BoundDataItemReference)c).isQueryRefItem()) continue;
                ++n;
            }
            if (n > 0) {
                bDecompPoint = true;
            }
        }
        if (bDecompPoint) {
            IXQEQueryNode[] children;
            for (IXQEQueryNode child : children = expr.getChildren()) {
                TabStreamUtil.getNonFactsAndFactsInExpression(environment, child, true, sepRules, defaultAggr, nonFacts, facts);
            }
        } else if (bAfterDecompPoint) {
            IXQEQueryNode di = expr;
            if (expr.getType() == 201060) {
                di = ((V5BoundDataItemReference)expr).getRefDataItem();
            }
            if (di.getType() == 101003) {
                if (TabStreamUtil.isFactItem((V5DataItem)di)) {
                    facts.add(expr);
                } else {
                    nonFacts.add(expr);
                }
            } else {
                RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.determineAggrType(environment, expr, defaultAggr);
                RefineAutomaticXtab.AggrTypeEnum rollType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
                if (rollType.equals((Object)RefineAutomaticXtab.AggrTypeEnum.NONE)) {
                    nonFacts.add(expr);
                } else {
                    facts.add(expr);
                }
            }
        }
    }

    public static boolean needDecomposeExpression(PlanningEnvironment environment, IXQEQueryNode expr, boolean bAfterDecompPoint, int sepRules, RefineAutomaticXtab.AggrTypeEnum defaultAggr) {
        if (expr.getType() == 101004) {
            expr = expr.getChild(0);
        }
        while (expr.getType() == 101003 && ((V5DataItem)expr).isOLAPConstruct()) {
            expr = expr.getChild(0);
        }
        if (!TabStreamUtil.useMetadataObjects(expr, false) || expr.isOfCategories(MixedDMRRelUtil.V5OLAPCONSTRUCT)) {
            return false;
        }
        boolean bDecompPoint = false;
        if (expr.isOfCategory(201120)) {
            V5SimpleNode simpleNode = (V5SimpleNode)expr;
            bDecompPoint = TabStreamUtil.checkDecomposePoint(simpleNode, sepRules);
        }
        if (bDecompPoint) {
            if ((sepRules & 1) != 1) {
                sepRules |= 1;
            }
            IXQEQueryNode[] children = expr.getChildren();
            for (int cPos = 0; cPos < children.length; ++cPos) {
                int sepRulesChild = sepRules;
                if (expr.getType() == 201017 && cPos == 0 && (sepRulesChild & 4) != 4) {
                    sepRulesChild |= 4;
                }
                if (!TabStreamUtil.needDecomposeExpression(environment, children[cPos], true, sepRulesChild, defaultAggr)) continue;
                return true;
            }
            return false;
        }
        if (bAfterDecompPoint) {
            boolean b;
            if (expr.getType() == 101003 && ((b = TabStreamUtil.isFactItem((V5DataItem)expr)) || defaultAggr != RefineAutomaticXtab.AggrTypeEnum.CALCULATED)) {
                return b;
            }
            RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.determineAggrType(environment, expr, defaultAggr);
            RefineAutomaticXtab.AggrTypeEnum rollType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
            return !rollType.equals((Object)RefineAutomaticXtab.AggrTypeEnum.NONE);
        }
        return false;
    }

    protected static boolean exprHasComplexCalc(IXQEQueryNode expr) {
        IXQEQueryNode[] calcExprs;
        IXQEQueryNode parentDataitem = expr.getParent();
        for (IXQEQueryNode calc : calcExprs = expr.getDescendantsOfType(201014, false)) {
            if (parentDataitem != calc.getAncestorOfType(101003) || calc.getNumberChildrenOfType(101003) <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean checkDecomposePoint(V5SimpleNode simpleNode, int sepRules) {
        boolean bDecompPoint = false;
        if ((sepRules & 2) == 2) {
            boolean bl = bDecompPoint = simpleNode.getDataType() == BooleanType.BOOLEANTYPE || simpleNode.isOLAPConstruct();
        }
        if (!bDecompPoint && (sepRules & 4) == 4) {
            boolean bl = bDecompPoint = simpleNode.getDataType() == BooleanType.BOOLEANTYPE;
        }
        if (!bDecompPoint && (sepRules & 1) == 1) {
            bDecompPoint = simpleNode.getType() == 201014 && (simpleNode.getSubType() == 1 || simpleNode.getSubType() == 2 || simpleNode.getSubType() == 3 || simpleNode.getSubType() == 4) || simpleNode.getType() == 201040 && simpleNode.getSubType() != 6 || simpleNode.getType() == 201017 && TabStreamUtil.exprHasComplexCalc(simpleNode);
        }
        return bDecompPoint;
    }

    public static boolean useMetadataObjects(IXQEQueryNode expr, boolean bCheckRelLiteral) {
        IXQEQueryNode[] fromModel = expr.getDescendantsOfType(201116, true);
        if (fromModel.length > 0) {
            return true;
        }
        int[] types = new int[]{201060, 201097, 201103};
        IXQEQueryNode[] fromRefs = expr.getDescendantsOfTypes(types, true);
        if (fromRefs.length > 0) {
            return true;
        }
        if (bCheckRelLiteral) {
            IXQEQueryNode[] specials = expr.getDescendantsOfType(201025, true);
            return specials.length > 0;
        }
        return false;
    }

    public static boolean decomposeExpression(WrapCommonObjects env, IXQEQueryNode expr, boolean bDecompose, String topItemName, int sepRules, RefineAutomaticXtab.AggrTypeEnum defaultAggr) {
        if (expr.getType() == 101004) {
            expr = expr.getChild(0);
        }
        while (expr.getType() == 101003 && ((V5DataItem)expr).isOLAPConstruct()) {
            expr = expr.getChild(0);
        }
        if (expr.isOfCategories(MixedDMRRelUtil.V5OLAPCONSTRUCT)) {
            return false;
        }
        if (!TabStreamUtil.useMetadataObjects(expr, true)) {
            IXQEQueryNode[] fncsArray;
            List<IXQEQueryNode> fncs = expr.getDescendantsOfTypesOrdered(MixedDMRRelUtil.SCALARTYPES, true);
            if (!fncs.isEmpty() && DecomposeScalarFunction.checkScalarFunctions(fncsArray = fncs.toArray(new IXQEQueryNode[fncs.size()]), null)) {
                V5DataItemToMeasureWrapper measureWrapper = TabStreamUtil.createMeasureWrapperForExpr(env, topItemName, expr, RefineAutomaticXtab.AggrTypeEnum.MIN, RefineAutomaticXtab.AggrTypeEnum.MIN);
                TabStreamUtil.wrapExprWithMeasure(env, expr, measureWrapper, true);
            }
            return false;
        }
        boolean bDecompPoint = false;
        if (expr.isOfCategory(201120)) {
            V5SimpleNode simpleNode = (V5SimpleNode)expr;
            bDecompPoint = TabStreamUtil.checkDecomposePoint(simpleNode, sepRules);
        }
        if (bDecompPoint) {
            if (!TabStreamUtil.needDecomposeExpression(env.mEnvironment, expr, false, sepRules, defaultAggr)) {
                return false;
            }
            if ((sepRules & 1) != 1) {
                sepRules |= 1;
            }
            IXQEQueryNode[] children = expr.getChildren();
            for (int cPos = 0; cPos < children.length; ++cPos) {
                int sepRulesChild = sepRules;
                if (expr.getType() == 201017 && cPos == 0 && (sepRulesChild & 4) != 4) {
                    sepRulesChild |= 4;
                }
                TabStreamUtil.decomposeExpression(env, children[cPos], true, topItemName, sepRulesChild, defaultAggr);
            }
            return true;
        }
        if (bDecompose) {
            V5DataItemToMeasureWrapper measureWrapper = null;
            if (expr.getType() == 101003) {
                boolean bNeedDecomp = false;
                bNeedDecomp = (sepRules & 2) != 2 ? TabStreamUtil.needDecompose(env.mEnvironment, (V5DataItem)expr) : TabStreamUtil.needDecomposeExpression(env.mEnvironment, expr.getChild(0), false, sepRules, defaultAggr);
                if (bNeedDecomp) {
                    return TabStreamUtil.decomposeExpression(env, expr.getChild(0), bDecompose, topItemName, sepRules, defaultAggr);
                }
                V5DataItem dataItemInExpr = (V5DataItem)expr;
                V5DataItem itemUnderSelection = null;
                String calcV5Name = (String)dataItemInExpr.getPropertyValue(FROM_CALCULATION);
                if (calcV5Name != null) {
                    itemUnderSelection = env.mSelection.getDataItemByRefName(calcV5Name);
                    if (itemUnderSelection == null) {
                        itemUnderSelection = (V5DataItem)env.mFactory.deepCopyNode(dataItemInExpr);
                        itemUnderSelection.setNameProperty(calcV5Name);
                        env.mSelection.addChild(itemUnderSelection);
                    }
                } else {
                    String name = dataItemInExpr.getNameProperty();
                    itemUnderSelection = env.mSelection.getDataItemByRefName(name);
                }
                if ((measureWrapper = TabStreamUtil.getExistingMeasureWrapper(env, itemUnderSelection)) == null) {
                    V5DataItem dataItem = itemUnderSelection;
                    if (TabStreamUtil.checkIfDataItemIsWrapped(dataItem)) {
                        dataItem = dataItemInExpr;
                    }
                    measureWrapper = TabStreamUtil.createMeasureWrapper(env, dataItem, topItemName, defaultAggr);
                    TabStreamUtil.wrapExprWithMeasure(env, dataItem.getChild(0), measureWrapper, false);
                } else if (env.mQRD.getPropertyValue(SCOPE) != null && topItemName != null) {
                    V5DataItem orgItem = TabStreamUtil.getOriginalMeasureV5DataItem(env, measureWrapper, itemUnderSelection);
                    TabStreamUtil.addMeasureLevelScope(env, measureWrapper, orgItem, topItemName);
                }
            } else {
                RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.determineAggrType(env.mEnvironment, expr, defaultAggr);
                RefineAutomaticXtab.AggrTypeEnum rollType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
                measureWrapper = TabStreamUtil.createMeasureWrapperForExpr(env, topItemName, expr, aggrType, rollType);
            }
            TabStreamUtil.wrapExprWithMeasure(env, expr, measureWrapper, true);
            return true;
        }
        return false;
    }

    protected static V5DataItemToMeasureWrapper createMeasureWrapperForExpr(WrapCommonObjects env, String topItemName, IXQEQueryNode expr, RefineAutomaticXtab.AggrTypeEnum aggrType, RefineAutomaticXtab.AggrTypeEnum rollType) {
        V5DataItem dataItem = (V5DataItem)env.mFactory.createNode(101003);
        dataItem.setAggregateProperty(aggrType.getV5Name());
        dataItem.setRollupAggregateProperty(rollType.getV5Name());
        dataItem.setIsProjected();
        dataItem.setIsReferenced();
        dataItem.setReferencesWalked();
        String dataItemName = FACT_PREFIX + env.mTabSelection.getChildren().length;
        dataItem.setNameProperty(dataItemName);
        dataItem.addChild(env.mFactory.deepCopyNode(expr));
        V5DataItemToMeasureWrapper measureWrapper = TabStreamUtil.getExistingMeasureWrapper(env, dataItem);
        if (measureWrapper == null) {
            env.mSelection.addChild(dataItem);
            measureWrapper = TabStreamUtil.createMeasureWrapper(env, dataItem, topItemName, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
            TabStreamUtil.wrapExprWithMeasure(env, dataItem.getChild(0), measureWrapper, false);
        } else if (env.mQRD.getPropertyValue(SCOPE) != null && topItemName != null) {
            V5DataItem orgItem = TabStreamUtil.getOriginalMeasureV5DataItem(env, measureWrapper, dataItem);
            TabStreamUtil.addMeasureLevelScope(env, measureWrapper, orgItem, topItemName);
        }
        return measureWrapper;
    }

    protected static boolean checkIfDataItemIsWrapped(V5DataItem dataItem) {
        IXQEQueryNode[] modelObjects;
        for (IXQEQueryNode obj : modelObjects = dataItem.getDescendantsOfType(201116, false)) {
            IMetadata metaData = ((V5BoundModelIdentifier)obj).getMetadata();
            if (!(metaData instanceof V5DataItemToMeasureWrapper) && !(metaData instanceof V5DataItemToLevelWrapper) && !(metaData instanceof V5DataItemToLevelAttributeWrapper)) continue;
            return true;
        }
        return false;
    }

    public static void replaceRefDataItemWithWrapper(WrapCommonObjects env, IXQEQueryNode exprNode, String extra) {
        IXQEQueryNode[] children;
        if (exprNode.getType() == 101003) {
            V5DataItem item;
            IXQEQueryNode parent = exprNode.getParent();
            V5DataItem v5DataItem = (V5DataItem)exprNode;
            String name = v5DataItem.getNameProperty();
            if (env.mTabSelection.getDataItemByRefName(name) != null && (item = TabStreamUtil.getV5DataItem(env, name, parent, extra)) != null) {
                IXQEQueryNode[] objects = item.getDescendantsOfType(201116, false);
                V5BoundModelIdentifier metaObj = (V5BoundModelIdentifier)objects[0];
                IMetadata meta = metaObj.getMetadata();
                if (meta instanceof V5DataItemToLevelWrapper) {
                    IXQEQueryNode newNode = env.mFactory.deepCopyNode(item);
                    exprNode.exchange(newNode);
                } else if (meta instanceof V5DataItemToMeasureWrapper) {
                    IXQEQueryNode newNode = env.mFactory.deepCopyNode(item);
                    if (parent.getType() == 201039) {
                        V5SimpleNode setExpression = (V5SimpleNode)env.mFactory.createNode(201101);
                        setExpression.addChild(newNode);
                        newNode = setExpression;
                    }
                    exprNode.exchange(newNode);
                }
                return;
            }
        }
        for (IXQEQueryNode child : children = exprNode.getChildren()) {
            TabStreamUtil.replaceRefDataItemWithWrapper(env, child, extra);
        }
    }

    protected static V5DataItem getV5DataItem(WrapCommonObjects env, String name, IXQEQueryNode parent, String extra) {
        V5DataItem item = env.mSelection.getDataItemByRefName(name);
        if (item == null) {
            return null;
        }
        if (extra != null && extra.startsWith(AGGREGATE_PREFIX) && parent != null && parent.getType() == 201039 && env.mQRD != null) {
            IXQEQueryNode[] valueSets;
            String vsName = extra.substring(AGGREGATE_PREFIX.length());
            for (IXQEQueryNode vs : valueSets = env.mQRD.getDescendantsOfType(101057, false)) {
                IXQEQueryNode[] grps;
                if (!((V5ValueSet)vs).getNameProperty().equals(vsName)) continue;
                IXQEQueryNode parentGrp = vs.getParent();
                IXQEQueryNode parentOfParent = parentGrp.getParent();
                for (IXQEQueryNode grp : grps = parentOfParent.getChildrenOfType(101050)) {
                    V5DataItem itemA;
                    if (grp == parentGrp) continue;
                    V5ValueSet siblingVS = (V5ValueSet)grp.getFirstChildByType(101057);
                    String refItemName = siblingVS.getRefDataItemProperty();
                    if (refItemName.equals(name)) {
                        return item;
                    }
                    if (!refItemName.startsWith(name) || (itemA = env.mSelection.getDataItemByRefName(refItemName)) == null || !name.equals(itemA.getPropertyValue("orgName"))) continue;
                    return itemA;
                }
                break;
            }
        }
        return item;
    }

    public static V5DataItemToMeasureWrapper createMeasureWrapperForV5DataItem(WrapCommonObjects env, V5DataItem v5DataItem) {
        IXQEQueryNode[] existItems = env.mTabSelection.getChildrenOfType(101003);
        Integer columnPos = null;
        boolean reName = false;
        int[] types = new int[]{101004, 101003};
        for (int i = 0; i < existItems.length; ++i) {
            V5DataItem existItem = (V5DataItem)existItems[i];
            if (!v5DataItem.getNameProperty().equals(existItem.getNameProperty())) continue;
            reName = true;
            if (!v5DataItem.getAggregateProperty().equals(existItem.getAggregateProperty()) || !v5DataItem.getRollupAggregateProperty().equals(existItem.getRollupAggregateProperty()) || !TabStreamUtil.isSameExpression(v5DataItem, existItem, types)) break;
            columnPos = XQEIntegerPool.getInteger(i);
            break;
        }
        if (columnPos == null) {
            columnPos = XQEIntegerPool.getInteger(existItems.length);
            V5DataItem tabDataItem = (V5DataItem)env.mFactory.deepCopyNode(v5DataItem);
            List<IXQEQueryNode> mdOpItems = env.getMDOptimizaeItems();
            if (!mdOpItems.isEmpty()) {
                TabStreamUtil.addMDOptimizeItemsInForClause(env, tabDataItem, mdOpItems);
            }
            if (reName) {
                tabDataItem.setNameProperty(tabDataItem.getNameProperty().concat(columnPos.toString()));
            }
            TabStreamUtil.addItemToListQuery(env, tabDataItem);
        }
        V5DataItemToMeasureWrapper measure = TabStreamUtil.createMeasureWrapper(env, v5DataItem.getNameProperty(), TabStreamUtil.getDataItemLabel(v5DataItem), v5DataItem.getDataType(), v5DataItem.getRollupAggregateProperty());
        measure.setColumnPosition(Integer.toString(columnPos));
        return measure;
    }

    protected static void addMDOptimizeItemsInForClause(WrapCommonObjects env, IXQEQueryNode node, List<IXQEQueryNode> mdOpItems) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = node.getChildren()) {
            TabStreamUtil.addMDOptimizeItemsInForClause(env, child, mdOpItems);
        }
        if (node.getType() != 201031) {
            return;
        }
        V5ValueSummaryFunction aggr = (V5ValueSummaryFunction)node;
        IXQEQueryNode forNode = aggr.getFirstChildByType(201037);
        if (forNode == null) {
            return;
        }
        V5AggregateBreakClause breakClause = (V5AggregateBreakClause)forNode;
        if (breakClause.getSubType() == 0 || breakClause.getNumberChildren() > 0) {
            if (breakClause.getSubType() == 0) {
                breakClause.setSubType(2);
            }
            for (IXQEQueryNode mdDI : mdOpItems) {
                breakClause.addChild(env.mFactory.deepCopyNode(mdDI));
            }
        }
    }

    public static V5DataItemToMeasureWrapper createMeasureWrapper(WrapCommonObjects env, String dataItemName, String caption, IDataType dataType, String rollUp) {
        Dimension measuresDim = env.mCube.createAndReturnMeasuresDimension();
        Hierarchy measuresHier = (Hierarchy)measuresDim.getDefaultHierarchy();
        Level measuresLevel = (Level)measuresHier.getLevels().get(0);
        String measureName = MEASURE_PREFIX + measuresLevel.getMembers().size();
        V5DataItemToMeasureWrapper measure = new V5DataItemToMeasureWrapper(null, measuresDim, env.mCube.getConnection(), measureName, caption, dataType, rollUp);
        measure.setParentMetadataObject(measuresDim);
        measuresLevel.addMember(measure, null);
        measuresHier.setDefaultMember(measure);
        measuresDim.addChildMetadataObject(measure);
        measure.setProperty(DATA_ITEM_NAME_PROPERTY, dataItemName);
        return measure;
    }

    public static IXQEQueryNode getReportSummaryDetailEdgeGroup(V5ValueSet valueSet, V5DataItem v5DataItem, boolean[] extraInfo) {
        IXQEQueryNode[] siblings;
        String aggrType;
        IXQEQueryNode[] children = v5DataItem.getChildren();
        if (children == null || children.length != 1) {
            return null;
        }
        IXQEQueryNode expr = children[0];
        if (expr.getType() == 101004) {
            expr = expr.getChild(0);
        }
        if (expr.getType() == 201085) {
            expr = expr.getChild(0);
        }
        if (expr.getType() != 201032 || expr.getNumberChildren() != 2) {
            return null;
        }
        if (extraInfo != null && (aggrType = V5AggregateFunctionSubtype.getName(((V5MemberSummaryFunction)expr).getSubType())).equals("aggregate")) {
            extraInfo[0] = true;
        }
        IXQEQueryNode child0 = expr.getChild(0);
        IXQEQueryNode[] tmp = child0.getChildren();
        while (tmp.length > 0) {
            if (tmp.length != 1) {
                return null;
            }
            child0 = tmp[0];
            tmp = child0.getChildren();
        }
        if (child0.getType() != 201058) {
            return null;
        }
        IXQEQueryNode child1 = expr.getChild(1);
        if (child1.getType() != 201039) {
            return null;
        }
        if ((child1 = child1.getChild(0)).getType() != 101003) {
            return null;
        }
        V5DataItem detailItem = (V5DataItem)child1;
        if (extraInfo != null) {
            HashSet<IMetadata> metas = new HashSet<IMetadata>();
            TabStreamUtil.getWrapperObject(detailItem, metas);
            if (metas.isEmpty() || metas.iterator().next() instanceof V5DataItemToMeasureWrapper) {
                extraInfo[1] = true;
            }
        }
        String detailName = detailItem.getNameProperty();
        for (IXQEQueryNode sibling : siblings = valueSet.getParent().getParent().getChildrenOfType(101050)) {
            String ref;
            V5ValueSet vSet = (V5ValueSet)sibling.getFirstChildByType(101057);
            if (vSet.equals(valueSet) || !(ref = vSet.getRefDataItemProperty()).equals(detailName)) continue;
            return sibling;
        }
        return null;
    }

    public static void getWrapperObject(V5DataItem item, HashSet<IMetadata> metas) {
        IXQEQueryNode[] objects = item.getDescendantsOfType(201116, false);
        boolean bSeenLevel = false;
        boolean bSeenMeasure = false;
        for (IXQEQueryNode obj : objects) {
            V5BoundModelIdentifier metaObj = (V5BoundModelIdentifier)obj;
            IMetadata meta = metaObj.getMetadata();
            if (meta instanceof V5DataItemToLevelWrapper) {
                if (bSeenMeasure) {
                    metas.clear();
                    return;
                }
                bSeenLevel = true;
                metas.add(meta);
                continue;
            }
            if (!(meta instanceof V5DataItemToMeasureWrapper)) continue;
            if (bSeenLevel) {
                metas.clear();
                return;
            }
            bSeenMeasure = true;
            metas.add(meta);
        }
    }

    public static String addExternalRollUp(WrapCommonObjects env, ArrayList<ILevel> levelScope, V5DataItem orgItem) {
        V5QuerySet querySet;
        ArrayList<String> forClauseItems = new ArrayList<String>();
        for (ILevel level : levelScope) {
            ArrayList<String> items = new ArrayList<String>();
            String pos = (String)level.getProperty("expression");
            String itemName = TabStreamUtil.getDataItemNameByPos(env.mTabSelection, pos);
            items.add(itemName);
            for (ILevel preLevel = level.getPreviousLevel(); preLevel != null && preLevel instanceof V5DataItemToLevelWrapper; preLevel = preLevel.getPreviousLevel()) {
                pos = (String)((V5DataItemToLevelWrapper)preLevel).getProperty("expression");
                itemName = TabStreamUtil.getDataItemNameByPos(env.mTabSelection, pos);
                items.add(itemName);
            }
            Collections.reverse(items);
            forClauseItems.addAll(items);
        }
        Integer columnPos = XQEIntegerPool.getInteger(env.mTabSelection.getChildrenOfType(101003).length);
        V5DataItem tabDataItem = (V5DataItem)env.mFactory.createNode(101003);
        tabDataItem.setAggregateProperty("calculated");
        tabDataItem.setRollupAggregateProperty("calculated");
        tabDataItem.setIsProjected();
        tabDataItem.setIsReferenced();
        tabDataItem.setReferencesWalked();
        String tabDataItemName = ROLLUP_PREFIX + columnPos;
        tabDataItem.setNameProperty(tabDataItemName);
        tabDataItem.addChild(orgItem);
        TabStreamUtil.transformExprNodeSummariesRemoveRefDataItems(env, env.mTabSelection, tabDataItem.getChild(0), forClauseItems, null);
        TabStreamUtil.addItemToListQuery(env, tabDataItem);
        Governors gv = env.mV5Query.getGovernors();
        if (gv != null && Boolean.TRUE.equals(gv.getTreatRelXTabExtAggrAsListFooter())) {
            ArrayList<V5DataItem> scopeGrping = new ArrayList<V5DataItem>();
            for (String tabDIName : forClauseItems) {
                V5DataItem tabDI = env.mTabSelection.getDataItemByRefName(tabDIName);
                scopeGrping.add(tabDI);
            }
            tabDataItem.setPropertyValue(ROLLUP_GROUPING_ITEMS, scopeGrping);
        }
        if ((querySet = (V5QuerySet)tabDataItem.getAncestorOfType(101002)) != null) {
            for (IXQEQueryNode q : querySet.getChildren()) {
                if (q.getNodeType() != 101006 || q.getPropertyValue("queryUsesBridge") != Boolean.TRUE) continue;
                tabDataItem.setPropIsRollupExpression(true);
                break;
            }
        }
        return Integer.toString(columnPos);
    }

    public static String getDataItemNameByPos(V5Selection selection, String pos) {
        IXQEQueryNode[] children = selection.getChildrenOfType(101003);
        int p = Integer.parseInt(pos);
        if (p < 0 || p >= children.length) {
            return null;
        }
        return ((V5DataItem)children[p]).getNameProperty();
    }

    public static void addMeasureLevelScope(WrapCommonObjects env, V5DataItemToMeasureWrapper measure, V5DataItem v5DataItem, String scopedItemName) {
        IXQEQueryNode[] valueSets;
        for (IXQEQueryNode vs : valueSets = env.mQRD.getDescendantsOfType(101057, false)) {
            if (scopedItemName != null && !((V5ValueSet)vs).getRefDataItemProperty().equals(scopedItemName)) continue;
            ArrayList<ArrayList<ILevel>> levelScope = TabStreamUtil.getMeasureLevelScope(env, ((V5ValueSet)vs).getNameProperty());
            for (ArrayList<ILevel> scope : levelScope) {
                if (measure.containsScope(scope)) continue;
                String colPos = TabStreamUtil.addExternalRollUp(env, scope, (V5DataItem)env.mFactory.deepCopyNode(v5DataItem));
                measure.addScope(scope, colPos);
            }
        }
    }

    protected static ArrayList<ArrayList<ILevel>> getMeasureLevelScope(WrapCommonObjects env, String vsName) {
        ArrayList<ArrayList<ILevel>> rt = new ArrayList<ArrayList<ILevel>>();
        ArrayList<HashSet<String>> scope = TabStreamUtil.getScopeProperty(env.mQRD);
        for (HashSet<String> s : scope) {
            if (!s.contains(vsName)) continue;
            rt.add(TabStreamUtil.getLevelScope(env, s));
        }
        return rt;
    }

    protected static ArrayList<HashSet<String>> getScopeProperty(IXQEQueryNode node) {
        return (ArrayList)node.getPropertyValue(SCOPE);
    }

    protected static ArrayList<ILevel> getLevelScope(WrapCommonObjects env, HashSet<String> scope) {
        ArrayList<ILevel> scopeLevels = new ArrayList<ILevel>();
        TreeMap<String, Level> lowestLevel = new TreeMap<String, Level>();
        IXQEQueryNode[] vsets = env.mQRD.getDescendantsOfType(101057, false);
        for (IXQEQueryNode vs : vsets) {
            Dimension dim;
            String dimName;
            String name;
            Level level = (Level)vs.getPropertyValue(SCOPE);
            if (level == null || !scope.contains(name = ((V5ValueSet)vs).getNameProperty()) || lowestLevel.containsKey(dimName = (dim = (Dimension)level.getDimension()).getName()) && ((Level)lowestLevel.get(dimName)).getIndex() >= level.getIndex()) continue;
            lowestLevel.put(dimName, level);
        }
        for (Map.Entry entry : lowestLevel.entrySet()) {
            scopeLevels.add((ILevel)entry.getValue());
        }
        return scopeLevels;
    }

    public static V5DataItemToMeasureWrapper getExistingMeasureWrapper(WrapCommonObjects env, V5DataItem expr) {
        IXQEQueryNode[] items;
        V5DataItem item = env.mSelection.getDataItemByRefName(expr.getNameProperty());
        if (item != null) {
            V5BoundModelIdentifier metaObj;
            IMetadata meta;
            if (item.getNumberChildren() == 1 && item.getChild(0).getType() == 201116 && (meta = (metaObj = (V5BoundModelIdentifier)item.getChild(0)).getMetadata()) instanceof V5DataItemToMeasureWrapper) {
                return (V5DataItemToMeasureWrapper)meta;
            }
            return null;
        }
        int[] types = new int[]{101004};
        for (IXQEQueryNode child : items = env.mSelection.getChildrenOfType(101003)) {
            V5BoundModelIdentifier metaObj;
            IMetadata meta;
            item = (V5DataItem)child;
            V5DataItem orgItem = (V5DataItem)item.getPropertyValue(SCOPE);
            if (orgItem == null || !TabStreamUtil.isSameExpression(expr, orgItem, types) || item.getNumberChildren() != 1 || item.getChild(0).getType() != 201116 || !((meta = (metaObj = (V5BoundModelIdentifier)item.getChild(0)).getMetadata()) instanceof V5DataItemToMeasureWrapper)) continue;
            return (V5DataItemToMeasureWrapper)meta;
        }
        return null;
    }

    public static boolean isSameExpression(IXQEQueryNode node1, IXQEQueryNode node2, int[] types) {
        if (node1 == node2) {
            return true;
        }
        if ((node1 = TabStreamUtil.skipNodes(node1, types)) == (node2 = TabStreamUtil.skipNodes(node2, types))) {
            return true;
        }
        if (TabStreamUtil.isSameDefinition(node1, node2)) {
            boolean bRt = true;
            IXQEQueryNode[] children1 = node1.getChildren();
            IXQEQueryNode[] children2 = node2.getChildren();
            for (int idx = 0; bRt && idx < children1.length; ++idx) {
                bRt = TabStreamUtil.isSameExpression(children1[idx], children2[idx], types);
            }
            return bRt;
        }
        return false;
    }

    protected static IXQEQueryNode skipNodes(IXQEQueryNode expr, int[] types) {
        IXQEQueryNode realExpr = expr;
        while (realExpr.isOfTypes(types) && realExpr.getNumberChildren() == 1) {
            realExpr = realExpr.getChild(0);
        }
        return realExpr;
    }

    protected static boolean isSameDefinition(IXQEQueryNode node1, IXQEQueryNode node2) {
        if (node1.getType() != node2.getType() || node1.getNumberChildren() != node2.getNumberChildren() || !((XQEBaseQueryNode)node1).isSameSyntaxProperties(node2)) {
            return false;
        }
        boolean bRt = true;
        String s1 = null;
        String s2 = null;
        switch (node1.getType()) {
            case 201026: 
            case 201042: {
                bRt = node1.isSameExpression(node2, false);
                break;
            }
            case 201014: {
                s1 = ((V5ValueExpression)node1).getNodeSubTypeName();
                s2 = ((V5ValueExpression)node2).getNodeSubTypeName();
                bRt = s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
                break;
            }
            case 201013: {
                bRt = ((V5ComparisonExpression)node1).getOption() == ((V5ComparisonExpression)node2).getOption();
                break;
            }
            case 101003: {
                bRt = ((V5DataItem)node1).getNameProperty().equals(((V5DataItem)node2).getNameProperty()) || ((V5DataItem)node1).getAggregateProperty().equals(((V5DataItem)node2).getAggregateProperty()) && ((V5DataItem)node1).getRollupAggregateProperty().equals(((V5DataItem)node2).getRollupAggregateProperty());
                break;
            }
            case 201097: {
                bRt = ((V5BoundQueryItemReference)node1).getRefQueryItem() == ((V5BoundQueryItemReference)node2).getRefQueryItem();
                break;
            }
            case 201060: {
                bRt = ((V5BoundDataItemReference)node1).getRefDataItem() == ((V5BoundDataItemReference)node2).getRefDataItem();
                break;
            }
            case 201124: {
                bRt = ((V5AggregateFunction)node1).getPrefilter() == ((V5AggregateFunction)node2).getPrefilter() && ((V5AggregateFunction)node1).getDistinct() == ((V5AggregateFunction)node2).getDistinct();
                break;
            }
            case 201117: {
                s1 = ((V5BoundMemberUniqueName)node1).getExternalMemberUniqueName();
                s2 = ((V5BoundMemberUniqueName)node2).getExternalMemberUniqueName();
                bRt = s1 != null && s2 != null && s1.equals(s2);
                break;
            }
            case 201116: {
                s1 = ((V5BoundModelIdentifier)node1).getIdentifier();
                s2 = ((V5BoundModelIdentifier)node2).getIdentifier();
                bRt = s1 != null && s2 != null && s1.equals(s2);
                break;
            }
            default: {
                if (!node1.isOfCategory(201115)) break;
                s1 = ((V5BoundMultiPartIdentifier)node1).getIdentifier();
                s2 = ((V5BoundMultiPartIdentifier)node2).getIdentifier();
                bRt = s1 != null && s2 != null && s1.equals(s2);
            }
        }
        return bRt;
    }

    private static String getDataItemLabel(V5DataItem dataItem) {
        String label = (String)dataItem.getPropertyValue("label");
        if (label != null) {
            return label;
        }
        IXQEQueryNode firstChild = dataItem.getChild(0);
        if (firstChild != null && firstChild.getType() == 201116) {
            boolean isCollapsedExprNode;
            V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)firstChild;
            IMetadata metadata = identifier.getMetadata();
            if (metadata == null) {
                return dataItem.getNameProperty();
            }
            boolean bl = isCollapsedExprNode = firstChild.getBooleanPropertyValue("isCollapsedCaseExpr") == Boolean.TRUE || firstChild.getBooleanPropertyValue("isCollapsedIfThenElseExpr") == Boolean.TRUE;
            if (isCollapsedExprNode) {
                return dataItem.getNameProperty();
            }
            return metadata.getCaption();
        }
        return dataItem.getNameProperty();
    }

    public static void wrapExprWithMeasure(WrapCommonObjects env, IXQEQueryNode expr, V5DataItemToMeasureWrapper measureWrapper, boolean bToValue) {
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)env.mFactory.createNode(201116);
        newNode.setIdentifier(measureWrapper.getV5UniqueName());
        newNode.setMetadata(measureWrapper);
        if (!bToValue) {
            expr.exchange(newNode);
        } else {
            IXQEQueryNode tuple = env.mFactory.createNode(201110);
            tuple.addChild(newNode);
            IXQEQueryNode value = env.mFactory.createNode(201113);
            value.addChild(tuple);
            expr.exchange(value);
        }
    }

    public static V5DataItemToMeasureWrapper createMeasureWrapper(WrapCommonObjects env, V5DataItem dataItem, String scopeItemName, RefineAutomaticXtab.AggrTypeEnum defaultAggr) {
        if (!TabStreamUtil.isFactItem(dataItem) && defaultAggr == RefineAutomaticXtab.AggrTypeEnum.CALCULATED) {
            RefineAutomaticXtab.AggrTypeEnum aggrType = RefineAutomaticXtab.determineAggrType(env.mEnvironment, dataItem, defaultAggr);
            RefineAutomaticXtab.AggrTypeEnum rollType = RefineAutomaticXtab.determineRoolupAggrType(aggrType, RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
            dataItem.setAggregateProperty(aggrType.getV5Name());
            dataItem.setRollupAggregateProperty(rollType.getV5Name());
        }
        if (env.mQRD.getPropertyValue(SCOPE) == null) {
            return TabStreamUtil.createMeasureWrapperForV5DataItem(env, dataItem);
        }
        V5DataItemToMeasureWrapper measureWrapper = TabStreamUtil.createMeasureWrapper(env, dataItem.getNameProperty(), TabStreamUtil.getDataItemLabel(dataItem), dataItem.getDataType(), dataItem.getRollupAggregateProperty());
        TabStreamUtil.addMeasureLevelScope(env, measureWrapper, dataItem, scopeItemName);
        if (dataItem.getPropertyValue(SCOPE) == null) {
            dataItem.setPropertyValue(SCOPE, env.mFactory.deepCopyNode(dataItem));
        }
        return measureWrapper;
    }

    public static V5DataItemToLevelWrapper getLevel(WrapCommonObjects env, V5ValueSet valueSet) {
        String refItemName = valueSet.getRefDataItemProperty();
        V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(refItemName);
        IXQEQueryNode[] objects = v5DataItem.getDescendantsOfType(201116, false);
        if (objects.length == 0) {
            return null;
        }
        V5BoundModelIdentifier metaObj = (V5BoundModelIdentifier)objects[0];
        IMetadata meta = metaObj.getMetadata();
        if (meta instanceof V5DataItemToLevelWrapper) {
            return (V5DataItemToLevelWrapper)meta;
        }
        return null;
    }

    public static List<String> getForClauseItems(WrapCommonObjects env, V5ValueSet valueSet) {
        LinkedList<String> forClause = new LinkedList<String>();
        String itemName = TabStreamUtil.getColumnName(env, valueSet);
        forClause.add(itemName);
        IXQEQueryNode group = valueSet.getAncestorOfType(101050);
        for (group = group.getAncestorOfType(101050); group != null; group = group.getAncestorOfType(101050)) {
            V5ValueSet parentValueSet = (V5ValueSet)group.getChildrenOfType(101057)[0];
            itemName = TabStreamUtil.getColumnName(env, parentValueSet);
            if (itemName == null || forClause.contains(itemName)) continue;
            forClause.addFirst(itemName);
        }
        return forClause;
    }

    public static String getColumnName(WrapCommonObjects env, V5ValueSet valueSet) {
        V5DataItemToLevelWrapper level = TabStreamUtil.getLevel(env, valueSet);
        if (level == null) {
            return null;
        }
        String colPosStr = (String)level.getProperty("expression");
        int colPos = Integer.parseInt(colPosStr);
        IXQEQueryNode[] items = env.mTabSelection.getChildrenOfType(101003);
        if (colPos < 0 || colPos >= items.length) {
            return null;
        }
        V5DataItem tabItem = (V5DataItem)items[colPos];
        return tabItem.getNameProperty();
    }

    public static V5DataItemToLevelAttributeWrapper getLevelKeyProperty(WrapCommonObjects env, V5DataItemToLevelWrapper level) {
        String propName = "TBproperty_LEVELKEY";
        List<IMetadata> childrenMeta = level.getChildMetadataObjects();
        if (childrenMeta != null) {
            for (IMetadata meta : childrenMeta) {
                V5DataItemToLevelAttributeWrapper prop;
                if (!(meta instanceof V5DataItemToLevelAttributeWrapper) || !(prop = (V5DataItemToLevelAttributeWrapper)meta).getName().equals(propName)) continue;
                return prop;
            }
        }
        String pos = (String)level.getProperty("expression");
        String itemNameInTab = TabStreamUtil.getDataItemNameByPos(env.mTabSelection, pos);
        V5DataItem orgItem = env.mTabSelection.getDataItemByRefName(itemNameInTab);
        V5DataItemToLevelAttributeWrapper propObj = new V5DataItemToLevelAttributeWrapper(env.mCube.getConnection(), (Dimension)level.getDimension(), level, propName, orgItem.getDataType());
        level.addChildMetadataObject(propObj);
        propObj.setProperty("expression", pos);
        return propObj;
    }

    public static V5DataItemToLevelAttributeWrapper createALevelPropertyForDataItem(WrapCommonObjects env, String prop, int pos, V5DataItemToLevelWrapper level, List<String> processedNonFactDataItems) {
        V5DataItem tabDataItem;
        V5DataItem dataItem = env.mSelection.getDataItemByRefName(prop);
        String propName = PROPERTY_PREFIX + pos;
        V5DataItemToLevelAttributeWrapper propObj = new V5DataItemToLevelAttributeWrapper(env.mCube.getConnection(), (Dimension)level.getDimension(), level, propName, dataItem.getDataType());
        level.addChildMetadataObject(propObj);
        Integer colPos = XQEIntegerPool.getInteger(env.mTabSelection.getChildrenOfType(101003).length);
        propObj.setProperty("expression", Integer.toString(colPos));
        if (env.mQRD.getPropertyValue(SCOPE) != null && dataItem.getPropertyValue(SCOPE) == null) {
            dataItem.setPropertyValue(SCOPE, env.mFactory.deepCopyNode(dataItem));
        }
        if ((tabDataItem = (V5DataItem)env.mFactory.deepCopyNode(dataItem)).getAggregateProperty().equals("none")) {
            tabDataItem.setAggregateProperty("minimum");
        }
        if (tabDataItem.getRollupAggregateProperty().equals("none")) {
            tabDataItem.setRollupAggregateProperty("minimum");
        }
        if (env.mTabSelection.getAutoSummary()) {
            TabStreamUtil.transformExprNodeSummariesRemoveRefDataItems(env, env.mTabSelection, tabDataItem, processedNonFactDataItems, null);
        }
        tabDataItem.setAggregateProperty("calculated");
        tabDataItem.setRollupAggregateProperty("calculated");
        TabStreamUtil.addItemToListQuery(env, tabDataItem);
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)env.mFactory.createNode(201116);
        newNode.setIdentifier(propObj.getV5UniqueName());
        newNode.setMetadata(propObj);
        dataItem.getChild(0).exchange(newNode);
        return propObj;
    }

    public static void updateRSAPIDataItem(WrapCommonObjects env, V5DataItemToLevelAttributeWrapper propItem, String edgeName, String rowsetName, String itemName, RSAPIUsage usage) {
        RSAPIDataItem item = TabStreamUtil.getRSAPIDataItemByName(env.mRsapiNode, edgeName, rowsetName, itemName);
        if (item == null) {
            return;
        }
        IMetadata meta = item.getModelReference();
        if (meta instanceof V5DataItemToLevelAttributeWrapper) {
            return;
        }
        item.setModelReference(propItem);
        if (usage != null && usage != RSAPIUsage.NOT_SPECIFIED && usage != RSAPIUsage.UNKNOWN && usage != item.getUsage()) {
            item.setUsage(usage);
        }
    }

    public static boolean useSameDataItemAsParent(String refDataItem, IXQEQueryNode parent) {
        if (parent.getType() != 101050) {
            return false;
        }
        V5ValueSet valueSet = (V5ValueSet)parent.getFirstChildByType(101057);
        String parentRefDataItem = valueSet.getRefDataItemProperty();
        return refDataItem.equals(parentRefDataItem);
    }

    public static void getChildrenValueSetSameRefItem(IXQEQueryNode edgeGroup, IXQEQueryNode nodeSkip, String refDataItem, ArrayList<IXQEQueryNode> childrenSameItem) {
        IXQEQueryNode[] children;
        V5ValueSet valueSet = (V5ValueSet)edgeGroup.getFirstChildByType(101057);
        boolean bGoIntoChildrenGroups = false;
        if (valueSet == nodeSkip) {
            bGoIntoChildrenGroups = true;
        } else {
            String itemName = valueSet.getRefDataItemProperty();
            if (itemName.equals(refDataItem)) {
                bGoIntoChildrenGroups = true;
                childrenSameItem.add(valueSet);
            }
        }
        if (!bGoIntoChildrenGroups) {
            return;
        }
        for (IXQEQueryNode aChild : children = edgeGroup.getChildrenOfType(101050)) {
            TabStreamUtil.getChildrenValueSetSameRefItem(aChild, nodeSkip, refDataItem, childrenSameItem);
        }
    }

    public static RSAPIUsage getUsage(V5DataItem dataItem) {
        RSAPIUsage usage = null;
        String usagePropFromDataItem = (String)dataItem.getPropertyValue("usage");
        if (usagePropFromDataItem != null) {
            usage = RSAPIUtilities.convertUsageStringToRSAPIUsage(usagePropFromDataItem);
        } else {
            IXQEQueryNode node = dataItem.getChild(0);
            usage = RSAPIUtilities.resolveExpressionUsage(node, true);
        }
        return usage;
    }

    public static RefineAutomaticXtab.AggrTypeEnum determineCalculatedRollupAggrType(RefineAutomaticXtab.AggrTypeEnum aggrType) {
        switch (aggrType) {
            case TOTAL: {
                return RefineAutomaticXtab.AggrTypeEnum.TOTAL;
            }
            case MAX: {
                return RefineAutomaticXtab.AggrTypeEnum.MAX;
            }
            case MIN: {
                return RefineAutomaticXtab.AggrTypeEnum.MIN;
            }
            case CALCULATED: {
                return RefineAutomaticXtab.AggrTypeEnum.CALCULATED;
            }
            case COUNT: {
                return RefineAutomaticXtab.AggrTypeEnum.TOTAL;
            }
            case AVG: {
                return RefineAutomaticXtab.AggrTypeEnum.CALCULATED;
            }
            case NONE: {
                return RefineAutomaticXtab.AggrTypeEnum.MIN;
            }
            case AUTOMATIC: {
                return RefineAutomaticXtab.AggrTypeEnum.NONE;
            }
        }
        return RefineAutomaticXtab.AggrTypeEnum.CALCULATED;
    }

    public static V5DataItem getOriginalMeasureV5DataItem(WrapCommonObjects env, V5DataItemToMeasureWrapper measureObj, V5DataItem item) {
        V5DataItem orgItem = null;
        String measurePos = (String)measureObj.getProperty("expression");
        if (measurePos != null) {
            String measureItem = TabStreamUtil.getDataItemNameByPos(env.mTabSelection, measurePos);
            orgItem = env.mTabSelection.getDataItemByRefName(measureItem);
        } else {
            String dataItemName;
            V5DataItem itemInTopSel;
            orgItem = (V5DataItem)item.getPropertyValue(SCOPE);
            if (orgItem == null && (itemInTopSel = env.mSelection.getDataItemByRefName(dataItemName = (String)measureObj.getProperty(DATA_ITEM_NAME_PROPERTY))) != null) {
                orgItem = (V5DataItem)itemInTopSel.getPropertyValue(SCOPE);
            }
        }
        if (orgItem != null) {
            return (V5DataItem)env.mFactory.deepCopyNode(orgItem);
        }
        return null;
    }

    public static CubeWrapper createCubeWrapperAndSetRelDatasource(PlanningEnvironment env, CubeWrapper cube, MDXFromCube fromCube, V5Source src, V5QuerySet querySet, Governors governors) {
        String modelPath = null;
        String modelType = null;
        if (src != null) {
            modelPath = src.getModel();
            modelType = src.getModelType();
            if (modelPath != null && (modelPath = modelPath.trim()).length() == 0) {
                modelPath = null;
                modelType = null;
            }
        }
        if (modelPath == null) {
            modelPath = querySet.getModelPath();
            modelType = querySet.getModelType();
            if (modelPath != null && (modelPath = modelPath.trim()).length() == 0) {
                modelPath = null;
                modelType = null;
            }
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)env.getExecutionEnvironment();
        MetricsService.startCollectingMetric((RequestEnvironment)env.getRequestEnvironment(), "mfwRequest");
        MetadataConnection con = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(modelType, modelPath), modelPath, execEnv, true);
        if (cube == null) {
            cube = new CubeWrapper(con, governors);
        }
        boolean bRelDataSourceSet = false;
        List<IModelDataSource> datasources = con.getModelDataSources();
        String cmNameNoMacro = null;
        for (IModelDataSource ds : datasources) {
            String cmName;
            IDataSource dsToCheck;
            if (!ds.isRelational() || (dsToCheck = execEnv.getDataSourceByModelNameNoThrow(ds.getName())) == null || (cmName = dsToCheck.getCMDataSourceName()) == null || MacroExpander.isMacro(cmName)) continue;
            if (cmNameNoMacro == null) {
                cmNameNoMacro = cmName;
            }
            try {
                dsToCheck.getType();
            }
            catch (XQERuntimeException e) {
                continue;
            }
            String connString = null;
            try {
                connString = dsToCheck.getDataSourceConnection().getConnectionString();
            }
            catch (XQERuntimeException e) {
                continue;
            }
            if (!connString.contains("URL=jdbc:")) continue;
            cube.setDataSource(ds);
            if (dsToCheck.getMetadataProperties() != null) {
                if (!dsToCheck.getMetadataProperties().containsKey("queryType")) {
                    dsToCheck.setIsRelational();
                }
                bRelDataSourceSet = true;
            }
            if (fromCube == null) break;
            fromCube.bind(cube);
            break;
        }
        if (!bRelDataSourceSet) {
            if (cmNameNoMacro == null) {
                cmNameNoMacro = DUMMY_CMDS;
            }
            DummyRelationalDataSource ds = new DummyRelationalDataSource(cube.getName(), cmNameNoMacro);
            cube.setDataSource(ds);
            if (fromCube != null) {
                fromCube.bind(cube);
            }
        }
        MetricsService.endCollectingMetric((RequestEnvironment)env.getRequestEnvironment(), "mfwRequest");
        return cube;
    }

    public static void getProjectedAndNonProjectedNonFacts(WrapCommonObjects env, ArrayList<IXQEQueryNode> nonFacts, ArrayList<IXQEQueryNode> projectedNonFacts, ArrayList<Object> projectedLevelsOrProperties, ArrayList<IXQEQueryNode> nonProjectedNonFacts) {
        for (IXQEQueryNode nonFact : nonFacts) {
            Object levelOrProp = TabStreamUtil.getExistingLevelOrLevelPropertyWrapper(env, nonFact);
            if (levelOrProp != null) {
                projectedNonFacts.add(nonFact);
                projectedLevelsOrProperties.add(levelOrProp);
                continue;
            }
            nonProjectedNonFacts.add(nonFact);
        }
    }

    protected static Object getLevelOrPropertyWrapper(V5DataItem item) {
        if (item == null) {
            return null;
        }
        IXQEQueryNode[] objects = item.getDescendantsOfType(201116, false);
        if (objects.length != 1) {
            return null;
        }
        V5BoundModelIdentifier metaObj = (V5BoundModelIdentifier)objects[0];
        IMetadata meta = metaObj.getMetadata();
        if (meta instanceof V5DataItemToLevelWrapper || meta instanceof V5DataItemToLevelAttributeWrapper) {
            return meta;
        }
        return null;
    }

    protected static Object getExistingLevelOrLevelPropertyWrapper(WrapCommonObjects env, IXQEQueryNode nonFact) {
        IXQEQueryNode[] items;
        V5DataItem itemNonFact;
        V5DataItem item;
        Object r;
        if (nonFact.getType() == 101003 && (r = TabStreamUtil.getLevelOrPropertyWrapper(item = env.mSelection.getDataItemByRefName((itemNonFact = (V5DataItem)nonFact).getNameProperty()))) != null) {
            return r;
        }
        int[] types = new int[]{101003, 101004};
        for (IXQEQueryNode child : items = env.mSelection.getChildrenOfType(101003)) {
            V5DataItem orgItem;
            V5DataItem orgItem2;
            V5DataItemToLevelWrapper level;
            String pos;
            String itemNameInTab;
            V5DataItem item2 = (V5DataItem)child;
            Object r2 = TabStreamUtil.getLevelOrPropertyWrapper(item2);
            if (r2 == null || !(r2 instanceof V5DataItemToLevelWrapper ? (itemNameInTab = TabStreamUtil.getDataItemNameByPos(env.mTabSelection, pos = (String)(level = (V5DataItemToLevelWrapper)r2).getProperty("expression"))) != null && (orgItem2 = env.mTabSelection.getDataItemByRefName(itemNameInTab)) != null && TabStreamUtil.isSameExpression(nonFact, orgItem2, types) : (orgItem = (V5DataItem)item2.getPropertyValue(SCOPE)) != null && TabStreamUtil.isSameExpression(nonFact, orgItem, types))) continue;
            return r2;
        }
        return null;
    }

    public static IMember getOrCreateDummyMeasure(IXQENodeFactory nodeFactory, CubeWrapper cube, int flag) {
        Dimension measuresDim = cube.createAndReturnMeasuresDimension();
        Hierarchy measuresHier = (Hierarchy)measuresDim.getDefaultHierarchy();
        Level measuresLevel = (Level)measuresHier.getLevels().get(0);
        List<IMember> measures = measuresLevel.getMembers();
        for (IMember m : measures) {
            if (!DUMMY_MEASURE_NAME.equals(m.getName())) continue;
            return m;
        }
        V5DataItemToMeasureWrapper measure = new V5DataItemToMeasureWrapper(null, measuresDim, cube.getConnection(), DUMMY_MEASURE_NAME, DUMMY_MEASURE_NAME, IntegerType.INTEGERTYPE, "minimum");
        measure.setV5AggregateAttribute("minimum");
        V5LiteralValue valueNode = (V5LiteralValue)nodeFactory.createNode(201026);
        valueNode.setDataType(IntegerType.INTEGERTYPE);
        valueNode.setValue("1");
        measure.setBinaryExpression(valueNode);
        measure.setParentMetadataObject(measuresDim);
        measuresLevel.addMember(measure, null);
        measuresDim.addChildMetadataObject(measure);
        measure.setProperty(STITCH_TYPE, new Integer(flag));
        return measure;
    }

    public class WrapCommonObjects {
        protected PlanningEnvironment mEnvironment;
        protected IXQEQueryNode mRsapiNode;
        protected IXQENodeFactory mFactory;
        protected V5QueryResultDefinition mQRD;
        protected V5Query mV5Query;
        protected V5QuerySet mQuerySet;
        protected V5Selection mSelection;
        protected CubeWrapper mCube;
        protected V5Query mTabQuery;
        protected V5Selection mTabSelection;
        protected IXQEQueryNode mTabGroupBody;

        protected List<IXQEQueryNode> getMDOptimizaeItems() {
            ArrayList<IXQEQueryNode> rt = new ArrayList<IXQEQueryNode>();
            if (this.mTabSelection != null) {
                for (IXQEQueryNode di : this.mTabSelection.getChildren()) {
                    if (Boolean.TRUE != di.getPropertyValue(TabStreamUtil.DATAITEM_MD_OPTIMIZE)) continue;
                    rt.add(di);
                }
            }
            return rt;
        }
    }
}

