/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import java.util.Set;

public final class WrapRelationalExprInDMRQueryToTNode
extends Transformation {
    public WrapRelationalExprInDMRQueryToTNode() {
        this.mName = "Wrap relational expression in DMR query to a TNode.";
        this.mPassNumbers = new int[]{15};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] summaryFilters;
        IXQEQueryNode[] detailFilters;
        IXQEQueryNode[] v5Slicers;
        IXQEQueryNode[] items;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        V5Query query = qrd.getV5Query();
        int action = 0;
        Boolean bChecked = qrd.getBooleanPropertyValue("checkOLAPFuncOnRelDone");
        boolean bMixed = false;
        if (bChecked == null || bChecked != Boolean.TRUE) {
            bMixed = true;
            qrd.setPropertyValue("checkOLAPFuncOnRelDone", Boolean.TRUE);
            action = 1;
            if (qrd.isList()) {
                if (MixedDMRRelUtil.denyOLAPFuncOnRelInList(environment)) {
                    action |= 2;
                }
            } else if (MixedDMRRelUtil.denyOLAPFuncOnRelInXtab(environment)) {
                action |= 2;
            }
        }
        boolean bRelExpr = false;
        boolean bWrappedRelExpr = false;
        Set<String> dataItemsInGroupSort = MixedDMRRelUtil.dataItemNamesInGroupSort(qrd);
        V5Selection selection = query.getV5Selection();
        for (IXQEQueryNode item : items = selection.getChildrenOfType(101003)) {
            V5DataItem v5DataItem = (V5DataItem)item;
            if (!this.isUsedInQRD(v5DataItem, dataItemsInGroupSort) || !MixedDMRRelUtil.containRelationals(item, null)) continue;
            if (!qrd.isList() && MixedDMRRelUtil.isReportSummaryDataItem(qrd, (V5DataItem)item)) {
                MixedDMRRelUtil.checkthrowWarningReportSummaryWithinSet(environment, v5DataItem);
            } else {
                bRelExpr = true;
                MixedDMRRelUtil.applyActions(action, environment, item);
            }
            bWrappedRelExpr = true;
            this.wrapRelationalExpressionToTNode(nodeFactory, item.getChild(0));
            v5DataItem.setMixedDMRRelational(Boolean.TRUE);
        }
        for (IXQEQueryNode slicer : v5Slicers = query.getV5Slicers()) {
            if (!MixedDMRRelUtil.containRelationals(slicer, null)) continue;
            bRelExpr = true;
            MixedDMRRelUtil.checkthrowOLAPFuncOnRelSlicer(slicer, action, environment);
            bWrappedRelExpr = true;
            this.wrapRelationalExpressionToTNode(nodeFactory, slicer.getChild(0));
        }
        for (IXQEQueryNode aFilter : detailFilters = query.getV5DetailFilters()) {
            boolean postAggregation = ((V5DetailFilter)aFilter).getPostAutoAggregation();
            if (!postAggregation && DMRUtilities.allOLAPFunctionsCanBeConvertedToRelationalExpr(aFilter)) {
                if (aFilter.getPropertyValue("masterDetailDFilter") != Boolean.TRUE || !MixedDMRRelUtil.containRelationals(aFilter, null)) continue;
                aFilter.removeProperty("masterDetailDFilter");
                continue;
            }
            V5DetailFilter filter = (V5DetailFilter)aFilter;
            if (postAggregation && !filter.isOLAPConstruct()) {
                filter.setMixedDMRRelational(Boolean.TRUE);
            }
            if (!MixedDMRRelUtil.containRelationals(aFilter, null)) continue;
            bRelExpr = true;
            MixedDMRRelUtil.applyActions(action, environment, aFilter);
            bWrappedRelExpr = true;
            this.wrapRelationalExpressionToTNode(nodeFactory, aFilter.getChild(0));
        }
        for (IXQEQueryNode aSumFilter : summaryFilters = query.getV5SummaryFilters()) {
            if (!MixedDMRRelUtil.containRelationals(aSumFilter, null)) continue;
            bRelExpr = true;
            MixedDMRRelUtil.applyActions(action, environment, aSumFilter);
            bWrappedRelExpr = true;
            this.wrapRelationalExpressionToTNode(nodeFactory, aSumFilter.getChild(0));
        }
        if (bMixed && bRelExpr) {
            int aSeverity = 1;
            String queryName = (String)query.getPropertyValue("rootQueryName");
            if (queryName == null) {
                queryName = (String)query.getPropertyValue("name");
            }
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_mixedDMRAndRelational, queryName));
        }
        if (bWrappedRelExpr || !bMixed) {
            query.setMixedDMRRelational(Boolean.TRUE);
        } else {
            qrd.setMixedDMRRelational(null);
        }
    }

    private boolean isUsedInQRD(V5DataItem v5DataItem, Set<String> dataItemsInGroupSort) {
        if (v5DataItem.getIsProjected()) {
            return true;
        }
        return dataItemsInGroupSort != null && dataItemsInGroupSort.contains(v5DataItem.getNameProperty());
    }

    protected void wrapRelationalExpressionToTNode(IXQENodeFactory nodeFactory, IXQEQueryNode expr) {
        IXQEQueryNode[] children;
        if (expr.getType() == 601024) {
            return;
        }
        while (expr.getType() == 101003) {
            expr = expr.getChild(0);
        }
        if (!expr.isOfCategory(201120)) {
            return;
        }
        V5SimpleNode simpleNode = (V5SimpleNode)expr;
        if (!expr.isOfCategory(201126) && (expr.getPropertyValue("wrapValueSummary") == Boolean.TRUE || !simpleNode.isOLAPConstruct() && MixedDMRRelUtil.containRelationals(expr, null))) {
            RelationalOlapDecorationNode marker = (RelationalOlapDecorationNode)nodeFactory.createNode(601024);
            expr.insertParent(marker);
            return;
        }
        for (IXQEQueryNode child : children = expr.getChildren()) {
            this.wrapRelationalExpressionToTNode(nodeFactory, child);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        Boolean b = ((V5QueryResultDefinition)node).isMixedDMRRelational();
        boolean bl = status = b != null && b == Boolean.TRUE;
        if (status) {
            V5Query query = ((V5QueryResultDefinition)node).getV5Query();
            b = query.isMixedDMRRelational();
            boolean bl2 = status = b == null || b != Boolean.TRUE;
        }
        if (status) {
            this.traceNodeCondition(status, "need to wrap relational expression in DMR query to a TNode.", trace);
        } else {
            this.traceNodeCondition(status, "don't wrap.", trace);
        }
        return status;
    }
}

