/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;

public final class WrapV5DataItemToMeasure
extends Transformation {
    public WrapV5DataItemToMeasure() {
        this.mName = "Wrap fact V5DataItem in Relational CrossTab to a measure.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.removeProperty("wrapTo");
        V5DataItem v5DataItem = (V5DataItem)node;
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, (V5Query)v5DataItem.getAncestorOfType(101006));
        V5DataItemToMeasureWrapper measure = TabStreamUtil.createMeasureWrapper(env, v5DataItem, v5DataItem.getNameProperty(), RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC);
        TabStreamUtil.wrapExprWithMeasure(env, v5DataItem.getChild(0), measure, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String flag = (String)node.getPropertyValue("wrapTo");
        if (flag != null && flag.equals("summarize")) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "need to wrap fact V5DataItem in relatioanl crosstab to measure.", trace);
        } else {
            this.traceNodeCondition(status, "don't wrap fact V5DataItem to measure.", trace);
        }
        return status;
    }
}

