/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream.dmrtorel;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.transformation.decomposition.CastGroupedProperties;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.HashSet;
import java.util.List;

public final class DMRToRelUtil {
    public static final String PROP_BOOLEAN_FORCE_DMR_TO_RQP = "forceDMRtoRQP";
    public static final String DMR_CONTAINSONLY_PUSHED_DETIALFILTER = "containsDMRPushedDetailFilters";
    public static final String CONVERT_DMR_TO_REL_WITHOUT_WARNING = "convertDMRToRelWithoutWarning";

    public static boolean isInPushedDetailFilter(IXQEQueryNode node) {
        V5DetailFilter detailFilter = (V5DetailFilter)node.getAncestorOfType(101008);
        return detailFilter != null && detailFilter.getPropertyValue(DMR_CONTAINSONLY_PUSHED_DETIALFILTER) == Boolean.TRUE;
    }

    public static boolean forceDMRToRelational(V5Query query) {
        return DMRToRelUtil.isQueryWithOnlyDMRLevelPropertyAndRelObjectsAndNoOLAPFunctions(query, true);
    }

    protected static boolean isQueryWithOnlyDMRLevelPropertyAndRelObjectsAndNoOLAPFunctions(IXQEQueryNode query, boolean bCheckRelObj) {
        boolean bHasRelationalObj = false;
        boolean bHasDMRLevelPropery = false;
        List<IXQEQueryNode> modelObjects = query.getDescendantsOfCategory(201029, false);
        for (IXQEQueryNode obj : modelObjects) {
            IMetadata metaData = ((V5BoundToMetadata)obj).getMetadata();
            if (metaData == null) continue;
            if (metaData.getObjectType() == MetadataType.QUERY_ITEM) {
                if (((IQueryItem)metaData).getLevel() == null) {
                    bHasRelationalObj = true;
                    continue;
                }
                if (metaData.isDMR()) {
                    bHasDMRLevelPropery = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        if (!bHasDMRLevelPropery) {
            return false;
        }
        for (int i = 0; i < MixedDMRRelUtil.V5OLAPCONSTRUCT.length; ++i) {
            if (query.getDescendantsOfCategory(MixedDMRRelUtil.V5OLAPCONSTRUCT[i], false).isEmpty()) continue;
            return false;
        }
        if (bCheckRelObj) {
            if (bHasRelationalObj) {
                return true;
            }
            if (DMRToRelUtil.isReferencedByQRD((V5Query)query)) {
                return false;
            }
            if (Boolean.TRUE == query.getPropertyValue("REL_OVER_DMR")) {
                return false;
            }
            if (Boolean.TRUE == query.getPropertyValue("OLAPSubQuery")) {
                return false;
            }
            query.setPropertyValue(CONVERT_DMR_TO_REL_WITHOUT_WARNING, true);
        }
        return true;
    }

    private static boolean isReferencedByQRD(V5Query query) {
        IXQEQueryNode[] ds;
        IXQEQueryNode[] qrds;
        String queryName = query.getV5QueryName();
        V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
        for (IXQEQueryNode qrd : qrds = querySet.getChildrenOfType(101055)) {
            if (!queryName.equals(((V5QueryResultDefinition)qrd).getRefQueryProperty())) continue;
            return true;
        }
        for (IXQEQueryNode d : ds = querySet.getChildrenOfType(401005)) {
            if (!queryName.equals(((RSAPIDataset)d).getRefQueryName())) continue;
            return true;
        }
        return false;
    }

    public static void convertDMRToRelational(PlanningEnvironment environment, V5Query query) {
        DMRToRelUtil.unwindLevelProperty(environment, query);
    }

    protected static void unwindLevelProperty(PlanningEnvironment environment, IXQEQueryNode query) {
        List<IXQEQueryNode> modelObjects = query.getDescendantsOfCategory(201120, false);
        for (IXQEQueryNode obj : modelObjects) {
            IMetadata metaData = ((V5SimpleNode)obj).getMetadata();
            if (metaData == null || metaData.getObjectType() != MetadataType.QUERY_ITEM || ((IQueryItem)metaData).getLevel() == null) continue;
            if (obj.getType() == 201116) {
                IXQEQueryNode parent = obj.getParent();
                if (parent.getType() == 201051 && Boolean.TRUE == parent.getPropertyValue(PROP_BOOLEAN_FORCE_DMR_TO_RQP)) {
                    parent.exchange(obj);
                }
                MixedDMRRelUtil.unwindLevelPropertyToRelational(environment, obj);
                continue;
            }
            ((V5BoundParameter)obj).setMetadata(null);
            String itemExprStr = ((IQueryItem)metaData).getExpression();
            if (itemExprStr == null || itemExprStr.length() <= 0) continue;
            IXQEQueryNode itemExpr = RQPUtilities.createV5ValueExpression(itemExprStr, environment, null);
            if ((itemExpr = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, itemExpr)).isOfCategory(201120) && (metaData = ((V5SimpleNode)itemExpr).getMetadata()) != null && !metaData.isDMR()) {
                ((V5BoundParameter)obj).setMetadata(metaData);
            }
            itemExpr.detach();
        }
    }

    public static boolean needUnwindDMRToRelational(V5QueryResultDefinition qrd, V5Query query) {
        if (qrd.isList()) {
            return false;
        }
        List<V5DataItem> dataItems = CastGroupedProperties.getGroupedDataItems(qrd);
        if (dataItems.isEmpty()) {
            return false;
        }
        for (V5DataItem item : dataItems) {
            if (!DMRToRelUtil.needToUnwindDataItemExpress(item)) continue;
            return true;
        }
        return false;
    }

    protected static boolean needToUnwindDataItemExpress(V5DataItem item) {
        String rollUp = item.getRollupAggregateProperty();
        RefineAutomaticXtab.AggrTypeEnum rollUpType = RefineAutomaticXtab.AggrTypeEnum.valueOfV5String(rollUp);
        return rollUpType != null && rollUpType != RefineAutomaticXtab.AggrTypeEnum.NONE && rollUpType != RefineAutomaticXtab.AggrTypeEnum.AUTOMATIC && DMRToRelUtil.isQueryWithOnlyDMRLevelPropertyAndRelObjectsAndNoOLAPFunctions(item, false);
    }

    public static void unwindDMRToRelational(PlanningEnvironment environment, V5QueryResultDefinition qrd, V5Query query) {
        V5Selection selection = query.getV5Selection();
        IXQEQueryNode[] edges = qrd.getChildrenOfType(101049);
        HashSet<String> unwoundDataItems = new HashSet<String>();
        for (IXQEQueryNode edge : edges) {
            for (IXQEQueryNode valueSetNode : edge.getDescendantsOfType(101057, false)) {
                V5ValueSet valueSet = (V5ValueSet)valueSetNode;
                if (valueSet.getPropertyValue("isGroupedProperty") != Boolean.TRUE) continue;
                String refDataItemName = valueSet.getRefDataItemProperty();
                if (unwoundDataItems.contains(refDataItemName)) {
                    valueSet.removeProperty("isGroupedProperty");
                    continue;
                }
                V5DataItem dataItem = selection.getDataItemByRefName(refDataItemName);
                if (!DMRToRelUtil.needToUnwindDataItemExpress(dataItem)) continue;
                unwoundDataItems.add(refDataItemName);
                DMRToRelUtil.unwindLevelProperty(environment, dataItem);
                RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, dataItem);
                valueSet.removeProperty("isGroupedProperty");
            }
        }
    }
}

