/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.unwinding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.transformation.v5.binding.BindV5MemberUniqueName;
import com.cognos.xqe.transformation.v5.binding.BindV5MultiPartIdentifierToModel;
import com.cognos.xqe.transformation.v5.binding.ConvertV5MemberParameterToV5Parameter;
import com.cognos.xqe.transformation.v5.binding.ExpandRolapNamedSetMultiPartIdentifier;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class SubstituteDMRMeasureWithModelExp
extends Transformation {
    public static final String CREATEDFROMDMRMEASURE = "createdFromDMRMEasure";

    public SubstituteDMRMeasureWithModelExp() {
        this.mName = "SubstituteDMRMeasureWithModelExp";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201116};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        LoopDetectionChain ldc = new LoopDetectionChain();
        this.applyImplementation(node, environment, ldc);
    }

    protected void applyImplementation(IXQEQueryNode node, PlanningEnvironment environment, LoopDetectionChain ldc) {
        IMetadata metadata;
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        if (!ldc.push(v5BoundID.getIdentifier())) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, "Model Expression", ldc.serialize());
        }
        MetadataConnection mc = environment.getMetadataConnection();
        IXQEQueryNode tree = v5BoundID.getV5ValueExpression(environment);
        DMRUtilities.isDMRExpressionHasSummaryFunction(environment, v5BoundID, tree);
        IXQEQueryNode[] allV5MultiPartIdNodes = tree.getDescendantsOfType(201030, true);
        boolean exprCanBeReplaced = true;
        IDimension dimension = null;
        for (IXQEQueryNode v5Node : allV5MultiPartIdNodes) {
            V5MultiPartIdentifier multiPartId = (V5MultiPartIdentifier)v5Node;
            String identifier = multiPartId.getIdentifier();
            IMetadata metadata2 = mc.bindMetadataReference(identifier);
            IDimension tempDim = null;
            if (!(metadata2 instanceof IMeasure)) {
                exprCanBeReplaced = false;
                break;
            }
            IMeasure measure = (IMeasure)metadata2;
            tempDim = measure.getDimension();
            if (dimension != null && !tempDim.equals(dimension)) {
                exprCanBeReplaced = false;
                break;
            }
            dimension = tempDim;
        }
        if (exprCanBeReplaced) {
            metadata = v5BoundID.getMetadata();
            environment.getResponseMessageFolder().appendPlanningResponseMessageIfNotExist(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_DMRIngoreScopeCalculatedMeasure, metadata.getV5UniqueName());
            node.exchange(tree);
            this.bindAndUnwindExpression(tree, environment, ldc);
        } else {
            tree.removeFromIndex();
        }
        ldc.pop();
        if (exprCanBeReplaced) {
            metadata = v5BoundID.getMetadata();
            if (tree.getParent() == null) {
                return;
            }
            this.createV5MemberFunction(tree, metadata.getCaption(), metadata.getV5UniqueName(), ((IMeasure)metadata).getFormat(), environment);
        }
    }

    private void createV5MemberFunction(IXQEQueryNode node, String caption, String v5MUN, String format, PlanningEnvironment environment) {
        V5MemberFunction memberFunction = V5ToCogMDXUtilities.createV5MemberExpression(node, environment, v5MUN, caption);
        IHierarchy hierarchy = this.getMeasuresHierarchy(node, environment);
        XQENodeFactory factory = environment.getNodeFactory();
        V5BoundModelIdentifier measureHierarchy = (V5BoundModelIdentifier)factory.createNode(201116);
        measureHierarchy.setMetadata(hierarchy);
        measureHierarchy.setIdentifier(hierarchy.getV5UniqueName());
        memberFunction.addChild(measureHierarchy);
        memberFunction.setPropertyValue(CREATEDFROMDMRMEASURE, true);
        if (format != null) {
            memberFunction.setPropertyValue("format", format);
        }
    }

    private IHierarchy getMeasuresHierarchy(IXQEQueryNode node, PlanningEnvironment environment) {
        CubeWrapper cube = DMRUtilities.findCubeWrapper(node, environment, true);
        return cube.getMeasuresHierarchy();
    }

    protected IXQEQueryNode bindAndUnwindExpression(IXQEQueryNode expression, PlanningEnvironment environment, LoopDetectionChain ldc) {
        IXQEQueryNode[] allV5BoundNodes;
        IXQEQueryNode[] allV5ExpMemberParameter;
        IXQEQueryNode[] allV5NodesToBind;
        IXQEQueryNode parent = expression.getParent();
        int positionOfChild = parent.getPositionOfChild(expression);
        int[] pn = new int[]{1};
        Transformation transformation = new BindV5MultiPartIdentifierToModel(pn);
        for (IXQEQueryNode v5Node : allV5NodesToBind = expression.getDescendantsOfType(201030, true)) {
            if (!transformation.passesQueryCondition(v5Node, environment)) continue;
            transformation.apply(v5Node, environment);
        }
        transformation = new ExpandRolapNamedSetMultiPartIdentifier();
        for (IXQEQueryNode v5Node : allV5NodesToBind = expression.getDescendantsOfType(201116, true)) {
            if (!transformation.passesNodeCondition(v5Node, environment)) continue;
            transformation.apply(v5Node, environment);
        }
        transformation = new BindV5MemberUniqueName(pn);
        for (IXQEQueryNode v5Node : allV5NodesToBind = expression.getDescendantsOfType(201028, true)) {
            if (!transformation.passesQueryCondition(v5Node, environment)) continue;
            transformation.apply(v5Node, environment);
        }
        transformation = new ConvertV5MemberParameterToV5Parameter();
        for (IXQEQueryNode v5Node : allV5ExpMemberParameter = expression.getDescendantsOfType(201027, true)) {
            if (!transformation.passesQueryCondition(v5Node, environment)) continue;
            transformation.apply(v5Node, environment);
        }
        for (IXQEQueryNode v5Node : allV5BoundNodes = parent.getChild(positionOfChild).getDescendantsOfType(this.mTypes[0], true)) {
            if (!this.passesNodeCondition(v5Node, environment)) continue;
            this.applyImplementation(v5Node, environment, ldc);
        }
        return parent.getChild(positionOfChild);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (ROLAPUtilities.isQueryROLAP(node, environment)) {
            this.traceNodeCondition(false, "The node does not represent a DMR measure.", xqeTrace);
            return false;
        }
        return this.checkIsMeasure(node, xqeTrace);
    }

    protected boolean checkIsMeasure(IXQEQueryNode node, XQETrace xqeTrace) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        IMetadata metadata = v5BoundID.getMetadata();
        if (!(metadata instanceof IMeasure)) {
            this.traceNodeCondition(false, "The node is not a MFWMeasure.", xqeTrace);
            return false;
        }
        if (((IMeasure)metadata).getRegularAggregate() != AggregateTypeEnum.CALCULATED) {
            this.traceNodeCondition(false, "It is not a calculated measure..", xqeTrace);
            return false;
        }
        String modelExpression = v5BoundID.getExpression();
        if (modelExpression == null || modelExpression.length() == 0) {
            this.traceNodeCondition(false, "There is no model expression associated with the measure.", xqeTrace);
            return false;
        }
        return true;
    }
}

