/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.util;

import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.VariablePromptTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterCapabilities;
import com.cognos.xqe.query.parameters.Parameters;
import java.util.List;

public class BindV5ParameterUtil {
    public static boolean passBaseCondition(IXQEQueryNode node, PlanningEnvironment environment, StringBuilder msg) {
        String prop;
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (querySet == null) {
            msg.append("There is no QuerySet for this node.");
            return false;
        }
        IXQEQueryNode embeddedFilter = ((V5Parameter)node).getAncestorOfType(801035);
        if (embeddedFilter != null && !embeddedFilter.getGovernors().getDesignMode().booleanValue() && (prop = (String)embeddedFilter.getPropertyValue("filterType")) != null && prop.equals("previewFilter")) {
            msg.append("designMode Governor is set to False for embedded DesignMode (Preview) filter.");
            return false;
        }
        V5Parameter v5Parameter = (V5Parameter)node;
        IXQEQueryNode parent = v5Parameter.getParent();
        if (parent instanceof V5GenericFunction) {
            V5GenericFunction function = (V5GenericFunction)parent;
            IDataType dt = BindV5ParameterUtil.getDataTypeFromResolvedParameter(v5Parameter.getParameterName(), environment);
            if (dt != null) {
                return true;
            }
            List<IDataType> dataTypes = V5GenericFunction.getPossibleDataTypesForArgument(function, v5Parameter);
            if (dataTypes.size() == 1) {
                List<V5Parameter> v5Parameters;
                if (dataTypes.get(0) == VariantType.VARIANT && (v5Parameters = v5Parameter.getV5ParametersWithName()) != null) {
                    for (V5Parameter p : v5Parameters) {
                        V5GenericFunction func;
                        List<IDataType> funcDTs;
                        if (p == v5Parameter || !(p.getParent() instanceof V5GenericFunction ? (funcDTs = V5GenericFunction.getPossibleDataTypesForArgument(func = (V5GenericFunction)p.getParent(), p)).size() == 1 && funcDTs.get(0) != VariantType.VARIANT : p.getParent() instanceof V5SimpleNode)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (dataTypes.size() > 1) {
                List<V5Parameter> v5Parameters = v5Parameter.getV5ParametersWithName();
                if (v5Parameters != null) {
                    for (V5Parameter p : v5Parameters) {
                        if (p == v5Parameter || (!(p.getParent() instanceof V5SimpleNode) || p.getParent() instanceof V5GenericFunction) && 1 != V5GenericFunction.getPossibleDataTypesForArgument(function, v5Parameter).size()) continue;
                        return false;
                    }
                }
                return true;
            }
        } else if (parent instanceof V5DataItem) {
            IDataType dt = BindV5ParameterUtil.getDataTypeFromResolvedParameter(v5Parameter.getParameterName(), environment);
            if (dt != null) {
                return true;
            }
            List<V5Parameter> v5Parameters = v5Parameter.getV5ParametersWithName();
            if (v5Parameters != null) {
                for (V5Parameter p : v5Parameters) {
                    if (p == v5Parameter || !(p.getParent() instanceof V5SimpleNode)) continue;
                    return false;
                }
            }
        }
        return v5Parameter.getDataType() != null;
    }

    public static void setDataType(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Parameter v5Parameter = (V5Parameter)node;
        IXQEQueryNode parent = v5Parameter.getParent();
        if (parent instanceof V5GenericFunction) {
            V5GenericFunction function = (V5GenericFunction)parent;
            IDataType dt = BindV5ParameterUtil.getDataTypeFromResolvedParameter(v5Parameter.getParameterName(), environment);
            if (dt != null) {
                dt = BindV5ParameterUtil.getBestDataType(dt, v5Parameter, function);
                v5Parameter.setDataType(dt);
            } else {
                List<IDataType> dataTypes = V5GenericFunction.getPossibleDataTypesForArgument(function, v5Parameter);
                if (dataTypes.size() == 1) {
                    List<V5Parameter> v5Parameters;
                    if (dataTypes.get(0) == VariantType.VARIANT && (v5Parameters = v5Parameter.getV5ParametersWithName()) != null) {
                        for (V5Parameter p : v5Parameters) {
                            V5GenericFunction func;
                            List<IDataType> funcDTs;
                            if (p == v5Parameter || !(p.getParent() instanceof V5GenericFunction ? (funcDTs = V5GenericFunction.getPossibleDataTypesForArgument(func = (V5GenericFunction)p.getParent(), p)).size() == 1 && funcDTs.get(0) != VariantType.VARIANT : p.getParent() instanceof V5SimpleNode)) continue;
                            return;
                        }
                    }
                    v5Parameter.setDataType(dataTypes.get(0));
                } else if (dataTypes.size() > 1) {
                    List<V5Parameter> v5Parameters = v5Parameter.getV5ParametersWithName();
                    if (v5Parameters != null) {
                        for (V5Parameter p : v5Parameters) {
                            if (p == v5Parameter || (!(p.getParent() instanceof V5SimpleNode) || p.getParent() instanceof V5GenericFunction) && 1 != V5GenericFunction.getPossibleDataTypesForArgument(function, v5Parameter).size()) continue;
                            return;
                        }
                    }
                    v5Parameter.setDataType(dataTypes.get(0));
                }
            }
        } else if (!v5Parameter.isMemberParameter() && parent instanceof V5DataItem) {
            IDataType dt = BindV5ParameterUtil.getDataTypeFromResolvedParameter(v5Parameter.getParameterName(), environment);
            if (dt != null) {
                v5Parameter.setDataType(dt);
            } else {
                List<V5Parameter> v5Parameters = v5Parameter.getV5ParametersWithName();
                if (v5Parameters != null) {
                    for (V5Parameter p : v5Parameters) {
                        if (p == v5Parameter || !(p.getParent() instanceof V5SimpleNode)) continue;
                        return;
                    }
                }
            }
        }
    }

    public static IDataType getDataTypeFromResolvedParameter(String name, PlanningEnvironment environment) {
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnv.getRequestParameters();
        Parameter parameter = parameters.getParameter(name);
        if (null == parameter) {
            return null;
        }
        return parameter.getDataType();
    }

    public static IDataType getBestDataType(IDataType dataType, V5Parameter v5Parameter, V5GenericFunction function) {
        List<IDataType> validDataTypes = V5GenericFunction.getPossibleDataTypesForArgument(function, v5Parameter);
        IDataType dt = null;
        for (int i = 0; i < validDataTypes.size(); ++i) {
            block3: {
                try {
                    dt = DataTypeComparator.getMoreRestrictiveDataType(v5Parameter.getParameterName(), dataType, validDataTypes.get(i));
                }
                catch (XQERuntimeException e) {
                    if (i != validDataTypes.size() - 1) break block3;
                    throw e;
                }
            }
            if (dt != null) break;
        }
        return dt;
    }

    public static void setParameterProperties(V5Parameter v5Parameter, Parameter parameter, PlanningEnvironment env) {
        boolean isRequiredPrompt;
        if (v5Parameter.getDataType().isBlob()) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidPromptDataType, (Object)v5Parameter.getParameterName(), (Object)v5Parameter.getModelIdentifier(), (Object)v5Parameter.getModelIdentifier());
        }
        parameter.setDataType(v5Parameter.getDataType());
        IQueryItem mfwQueryItem = null;
        if (v5Parameter.getMetadata() != null && v5Parameter.getMetadata() instanceof IQueryItem) {
            mfwQueryItem = (IQueryItem)v5Parameter.getMetadata();
            parameter.setModelSize(mfwQueryItem.getDatatypeSize());
        }
        boolean isLiteral = v5Parameter.isLiteral();
        boolean isMasterDetail = v5Parameter.isMasterDetail();
        parameter.setIsLiteral(isLiteral);
        parameter.setMasterDetailLinkParameter(isMasterDetail);
        parameter.setProviderName(v5Parameter.getPlanningEnvironment(), v5Parameter.getMetadata());
        parameter.setQueryName(v5Parameter.getQueryName());
        if (v5Parameter.getMetadata() != null && v5Parameter.getMetadata().isDMR()) {
            parameter.setIsDMRParameter(true);
        }
        if ((isRequiredPrompt = v5Parameter.isRequired()) && !isMasterDetail && parameter.isIgnored()) {
            parameter.clearParameterValueItems();
            parameter.setErrorCode(UnresolvedParameterException.ParameterErrorCodeEnum.NIL_VALUE_REQ_PROMPT);
        }
        String modelFilterItem = v5Parameter.getModelFilterItem();
        String modelIdentifier = v5Parameter.getModelIdentifier();
        String valueExpression = v5Parameter.getValueExpression();
        if (modelFilterItem != null) {
            parameter.setModelItem(modelFilterItem);
        } else if (modelIdentifier != null) {
            parameter.setModelItem(modelIdentifier);
        } else {
            parameter.setValueExpression(valueExpression);
        }
        if (!isLiteral && v5Parameter.getDataType() == HierarchyType.HIERARCHYTYPE) {
            parameter.setPromptType(VariablePromptTypeEnum.HIERARCHY_PICKLIST.getFaultPromptType());
        }
        parameter.setDataItemRef(v5Parameter.getDataItemReference());
        ParameterCapabilities capabilities = parameter.getCapabilities();
        capabilities.setMultivalued(v5Parameter.isMultivalued());
        if (capabilities.isUsedInSingleAndMultiValueContext()) {
            ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PromptMultiAndSingleSelect, parameter.getName());
            env.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
        }
        boolean isUnderSelectionNode = v5Parameter.getAncestorOfType(101009) != null;
        boolean isProjected = false;
        if (isUnderSelectionNode) {
            IXQEQueryNode[] diList;
            for (IXQEQueryNode dataItem : diList = v5Parameter.getAncestorsOfTypeWithAnchor(101003, 101009)) {
                if (!((V5DataItem)dataItem).getIsProjected()) continue;
                isProjected = true;
                break;
            }
        }
        if (isUnderSelectionNode) {
            if (isProjected) {
                capabilities.setOptional(false);
            }
        } else {
            capabilities.setOptional(v5Parameter.isOptional());
        }
        if (v5Parameter.isBoundRange()) {
            capabilities.setRangeSupport(ParameterCapabilityEnum.boundRange);
        } else if (v5Parameter.isRightHandOperandOfInRange()) {
            capabilities.setRangeSupport(ParameterCapabilityEnum.unboundedRange);
        } else {
            capabilities.setRangeSupport(ParameterCapabilityEnum.discreteValue);
        }
    }

    public static void updateDetailFilter(Parameter parameter, IXQEQueryNode node, boolean isDMR) {
        if (node == null || !(node instanceof V5DetailFilter)) {
            return;
        }
        if (isDMR) {
            node.setPropertyValue("masterDetailDFilter", Boolean.TRUE);
        } else {
            String qrdName = (String)node.getPropertyValue("qrdName");
            if (qrdName != null) {
                V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
                V5QueryResultDefinition detailQrd = querySet.getQRD(qrdName);
                if (detailQrd == null) {
                    V5Query query = (V5Query)node.getAncestorOfType(101006);
                    for (IXQEQueryNode qrd : query.getChildrenOfType(101055)) {
                        if (!((V5QueryResultDefinition)qrd).getName().equals(qrdName)) continue;
                        detailQrd = (V5QueryResultDefinition)qrd;
                        break;
                    }
                }
                if (detailQrd == null || node.getPropertyValue("masterDetailDFilter") == Boolean.TRUE && detailQrd.getPropertyValue("mdQueryTransformed") != null) {
                    node.getParent().detachChild(node);
                }
            }
        }
    }
}

