/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.List;

public final class ValidateWithinDetailClause
extends Transformation {
    public ValidateWithinDetailClause() {
        this.mName = "Validate Within Detail Clause.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{201039};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node;
        if (withinClause.getWithinClauseType() != 1) {
            return false;
        }
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query == null) {
            return false;
        }
        V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
        if (querySet == null) {
            return false;
        }
        List<V5QueryResultDefinition> qrds = querySet.getReferencedQRDs(query);
        for (V5QueryResultDefinition qrd : qrds) {
            if (!qrd.isList()) continue;
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedWithinDetailInList, node);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        return false;
    }
}

