/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5LogicalOperatorToMDXLogicalOperator
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5LogicalOperatorToMDXLogicalOperator() {
        this.mName = "Convert a V5 Logical Operator to the corresponding MDX Logical Operator.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode newNode = null;
        switch (((V5LogicalExpression)node).getSubType()) {
            case 0: {
                newNode = nodeFactory.createNode(1110);
                break;
            }
            case 1: {
                newNode = nodeFactory.createNode(1111);
                break;
            }
            case 2: {
                newNode = nodeFactory.createNode(1109);
                break;
            }
        }
        node.getParent().exchangeChildNode(node, newNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int logicalExprType = ((V5LogicalExpression)node).getSubType();
        int nbrChildren = node.getNumberChildren();
        if (nbrChildren == 2 && (logicalExprType == 0 || logicalExprType == 1)) {
            status = true;
        } else if (nbrChildren == 1 && logicalExprType == 2) {
            status = true;
        }
        if (status) {
            for (int idx = 0; status && idx < nbrChildren; ++idx) {
                if (node.getChild(idx).isOfCategory(1071)) continue;
                status = false;
            }
        }
        if (status) {
            this.traceNodeCondition(status, "The V5 Logical Operator is valid expression.", trace);
        } else {
            this.traceNodeCondition(status, "The V5 Logical Operator is invalid expression.", trace);
        }
        return status;
    }
}

