/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPEdgeDecoration;
import com.cognos.xqe.ast.localprocessing.OLAPEmptyRowDecoration;
import com.cognos.xqe.ast.localprocessing.OLAPEmptyValueSetDecoration;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.NodeConditions.IsProjectedDescendant;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.ArrayList;
import java.util.List;

public final class ConvertV5ValueSetToCogMDXGroup
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5ValueSetToCogMDXGroup() {
        this.mName = "Convert V5ValueSet To CogMDXGroup.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean asReportSummary;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5ValueSet valueSet = (V5ValueSet)node;
        String refDataItemName = valueSet.getRefDataItemProperty();
        IXQEQueryNode valueSetParent = valueSet.getParent();
        List<OLAPEmptyRowDecoration> emptyRowDecos = valueSet.transferEmptyRowDecorationsProperty();
        OLAPEmptyValueSetDecoration emptyValueSetDecoration = (OLAPEmptyValueSetDecoration)valueSet.getPropertyValue("emptyValueSetDeco");
        IXQEQueryNode ancestorCogMDXAggregate = valueSet.getAncestorOfCategory(1012);
        IXQEQueryNode ancestorCogMDXCount = valueSet.getAncestorOfCategory(1087);
        CogMDXGroup cogMDXGroup = (CogMDXGroup)nodeFactory.createNode(1027);
        cogMDXGroup.setRefDataItemProperty(refDataItemName);
        RSAPIDataItem rsapiRefDataItem = valueSet.getRSAPIDataItem();
        cogMDXGroup.setRSAPIDataItem(rsapiRefDataItem);
        RSAPIEdgeRowset rsapiRowset = (RSAPIEdgeRowset)valueSet.getPropertyValue("RSAPIEdgeRowset");
        if (rsapiRowset != null && rsapiRowset.isCrosstabSpace() == RSAPIEdgeRowset.CrosstabSpaceType.NOT) {
            if (valueSet.isSpacerCellValue()) {
                rsapiRowset.setIsCrosstabSpace(RSAPIEdgeRowset.CrosstabSpaceType.WITHCELLVALUE);
            } else if (valueSet.isSpacerNoCellValue()) {
                rsapiRowset.setIsCrosstabSpace(RSAPIEdgeRowset.CrosstabSpaceType.NOCELLVALUE);
            }
        }
        cogMDXGroup.setRSAPIEdgeRowset(rsapiRowset);
        cogMDXGroup.setDataItemIndexesProjectingSameSet(valueSet.getDataItemIndexesProjectingSameSet());
        cogMDXGroup.setSpacerReplacement(valueSet.isSpacerReplacement());
        if (valueSet.hasDiffHierOrderOnSiblingPath()) {
            cogMDXGroup.setHasDiffHierOrderOnSiblingPath(CogMDXGroup.HAS_DIFF_HIER_ORDER_ON_SIBLING_PATH_TRUE);
        }
        if ((asReportSummary = (Boolean)valueSet.getPropertyValue("treatedAsReportSummary")) != null) {
            cogMDXGroup.setPropertyValue("treatedAsReportSummary", asReportSummary);
        }
        if (valueSet.isNonDetailGroupBodyValue()) {
            cogMDXGroup.setNonDetailGroupBodyValue(true);
            String contextGroupType = (String)valueSet.getPropertyValue("typeOfCurrentContextGroup");
            if (contextGroupType != null) {
                cogMDXGroup.setPropertyValue("typeOfCurrentContextGroup", contextGroupType);
            }
        }
        V5Query v5Query = (V5Query)valueSet.getAncestorOfType(101006);
        MDXQuery mdxQuery = (MDXQuery)valueSet.getAncestorOfType(1002);
        if (mdxQuery == null) {
            valueSet.throwInternalError("Error finding MDXQuery node.");
        }
        if (v5Query == null) {
            v5Query = mdxQuery.getRefV5Query();
        }
        if (rsapiRowset == null && valueSet.getDescendantsOfType(1027, false).length == 0) {
            cogMDXGroup.setPropertyValue("detail", "false");
        } else {
            String isReportDetail = valueSet.isReportDetail() ? "true" : "false";
            cogMDXGroup.setPropertyValue("detail", isReportDetail);
            cogMDXGroup.setDetailAutomatic(valueSet.getIsDetailAutomatic());
        }
        CogMDXReportSummary.updateRefSummary(valueSet, cogMDXGroup);
        if (valueSetParent.getType() == 101050) {
            cogMDXGroup.setSpacerList(((V5EdgeGroup)valueSetParent).getSpacerList());
        }
        if (valueSet.getContextProperty() != null && valueSet.getContextProperty().length > 0) {
            cogMDXGroup.setContextNames(valueSet.getContextProperty());
        }
        valueSetParent.exchangeChildNode(valueSet, cogMDXGroup, true);
        IHierarchy hier = cogMDXGroup.getFirstSetHierarchy();
        if (ancestorCogMDXAggregate == null && ancestorCogMDXCount == null && (emptyRowDecos != null || emptyValueSetDecoration != null)) {
            IXQEQueryNode topDecoForEdge = mdxQuery.getParent();
            while (topDecoForEdge.getType() != 401005 && topDecoForEdge.getParent().isOfCategory(601008) && (!topDecoForEdge.isOfCategory(601008) || ((OLAPEdgeDecoration)topDecoForEdge).getEdgeOrdinalProperty() == -1 || ((OLAPEdgeDecoration)topDecoForEdge).getEdgeOrdinalProperty() == rsapiRowset.getEdge().getOrdinal())) {
                topDecoForEdge = topDecoForEdge.getParent();
            }
            if (emptyValueSetDecoration != null) {
                topDecoForEdge.insertParent(emptyValueSetDecoration);
                emptyValueSetDecoration.setHierarchy(hier);
                topDecoForEdge = emptyValueSetDecoration;
            }
            if (emptyRowDecos != null) {
                for (OLAPEmptyRowDecoration emptyRowDeco : emptyRowDecos) {
                    emptyRowDeco.setHierarchy(hier);
                    topDecoForEdge.insertParent(emptyRowDeco);
                }
            }
        }
        if (rsapiRowset != null && cogMDXGroup.getAncestorOfType(1080) == null) {
            AbstractMDXSet firstChild = (AbstractMDXSet)cogMDXGroup.getChild(0);
            ArrayList<IXQEQueryNode> calcRefs = new ArrayList<IXQEQueryNode>();
            IsProjectedDescendant isProjCalcRef = new IsProjectedDescendant(firstChild);
            int[] nodeTypes = new int[]{1013};
            isProjCalcRef.setNodeTypes(nodeTypes);
            firstChild.getDescendantsForCondition(calcRefs, isProjCalcRef, false);
            if (calcRefs.size() == 1) {
                MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)calcRefs.get(0);
                calcRef.setV5Caption(refDataItemName);
            }
        }
        if (node.getPropertyValue("Wrapped Measure") != null) {
            cogMDXGroup.setPropertyValue("Wrapped Measure", true);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesQueryCondition(node, environment)) {
            return false;
        }
        V5ValueSet valueSet = (V5ValueSet)node;
        if (valueSet.isReportSummary() != null) {
            this.traceQueryCondition(false, "The V5ValueSet node 'isReportSummary' property has not been set.", environment.getTrace());
            return false;
        }
        this.traceQueryCondition(true, "The V5ValueSet node 'isReportSummary' property has been set.", environment.getTrace());
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getChildrenOfType(101052).length != 0) {
            this.traceNodeCondition(false, "The V5ValueSet node has a V5GroupFooter child node.", trace);
            return false;
        }
        if (node.getChildrenOfType(101051).length != 0) {
            this.traceNodeCondition(false, "The V5ValueSet node has a V5GroupBody child node.", trace);
            return false;
        }
        if (node.getPropertyValue("refDataItem") == null) {
            this.traceNodeCondition(false, "The V5ValueSet node has no refDataItem property.", trace);
            return false;
        }
        if (node.getChildrenOfType(101056).length > 0) {
            this.traceNodeCondition(false, "The V5ValueSet node has unresolved V5SortItem nodes.", trace);
            return false;
        }
        IXQEQueryNode firstExpression = node.getChild(0);
        if (node.getNumberChildren() >= 1 && firstExpression.isOfCategory(1021)) {
            IXQEQueryNode secondExpression = null;
            for (int idx = 1; idx < node.getNumberChildren(); ++idx) {
                IXQEQueryNode tmpChild = node.getChild(idx);
                if (tmpChild.getType() == 1080) continue;
                if (secondExpression == null) {
                    secondExpression = tmpChild;
                    continue;
                }
                this.traceNodeCondition(false, "The V5ValueSet node has invalid number of child expression.", trace);
                return false;
            }
            if (secondExpression != null && !secondExpression.isOfCategory(1021)) {
                this.traceNodeCondition(false, "The inner projected expression is not a set expression.", trace);
                return false;
            }
            MDXHierInfo firstHierarchyInfo = ((AbstractMDXNode)firstExpression).getHierarchyInfo();
            if (firstHierarchyInfo.getNumProjectedHierarchies() != 1) {
                V5ValueSet valueSet = (V5ValueSet)node;
                String param = valueSet.getRefDataItemProperty();
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedMultidimensionalDataItem, param);
            }
            IHierarchy hierarchy = firstHierarchyInfo.getProjectedHierarchy(0);
            RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
            if (environment.getRoot().getType() == 101002 && !rsapiDataset.isCrossTabReport() && !hierarchy.isShell() && hierarchy.getDimension().isMeasuresDimension()) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppGroupingOnCellValueExpression, node.getPropertyValue("refDataItem").toString(), node.getPropertyValue("name").toString());
            }
            this.traceNodeCondition(true, "The V5ValueSet contains valid expressions.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The V5ValueSet contains invalid expression type.", trace);
        return false;
    }
}

