/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPEmptyRowDecoration;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5exptomdxexp.handlingreplicas.RemoveReplicasFromGroupBodyHeaderFooter;
import com.cognos.xqe.transformation.v5exptomdxexp.handlingreplicas.RemoveReplicasWithinDetailValueSet;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.List;

public final class ConvertV5ValueSetToCogMDXNest
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5ValueSetToCogMDXNest() {
        this.mName = "Convert V5ValueSet To CogMDXNest";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode parent = node;
        IXQEQueryNode[] sortNodes = node.getChildrenOfType(101058);
        if (sortNodes.length == 1) {
            parent = sortNodes[0];
        }
        V5GroupBody groupBody = (V5GroupBody)parent.getChildrenOfType(101051)[0];
        IXQEQueryNode[] dataItemRefs = groupBody.getChildrenOfTypeOrdered(101015);
        CogMDXNest newNode = null;
        IXQEQueryNode parentNode = null;
        IXQEQueryNode query = node.getAncestorOfType(1002);
        V5ValueSet valueSet = (V5ValueSet)node;
        RSAPIEdgeRowset rsapiRowset = (RSAPIEdgeRowset)valueSet.getPropertyValue("RSAPIEdgeRowset");
        List<OLAPEmptyRowDecoration> emptyRowDecos = valueSet.transferEmptyRowDecorationsProperty();
        OLAPEmptyRowDecoration emptyHeaderDeco = null;
        OLAPEmptyRowDecoration emptyFooterDeco = null;
        IXQEQueryNode ancestorCogMDXAggregate = node.getAncestorOfCategory(1012);
        IXQEQueryNode ancestorCogMDXCount = node.getAncestorOfCategory(1087);
        if (ancestorCogMDXAggregate == null && ancestorCogMDXCount == null) {
            IXQEQueryNode topDecoForEdge = query.getParent();
            while (topDecoForEdge.isOfCategory(601008) && topDecoForEdge.getParent().isOfCategory(601008)) {
                topDecoForEdge = topDecoForEdge.getParent();
            }
            if (emptyRowDecos != null) {
                for (OLAPEmptyRowDecoration emptyRowDeco : emptyRowDecos) {
                    topDecoForEdge.insertParent(emptyRowDeco);
                    if (emptyRowDeco.getSubType() == 101053) {
                        emptyHeaderDeco = emptyRowDeco;
                    }
                    if (emptyRowDeco.getSubType() != 101052) continue;
                    emptyFooterDeco = emptyRowDeco;
                }
            }
        }
        for (IXQEQueryNode dataItemRef : dataItemRefs) {
            V5DataItemRef v5DataItemRef = (V5DataItemRef)dataItemRef;
            String refDataItemName = (String)v5DataItemRef.getPropertyValue("refDataItem");
            CogMDXNest cogMDXNest = (CogMDXNest)nodeFactory.createNode(1026);
            cogMDXNest.setRefDataItemProperty(refDataItemName);
            RSAPIDataItem rsapiRefDataItem = (RSAPIDataItem)dataItemRef.getPropertyValue("RSAPIRefDataItem");
            cogMDXNest.setRSAPIDataItem(rsapiRefDataItem);
            cogMDXNest.setRSAPIEdgeRowset((RSAPIEdgeRowset)valueSet.getPropertyValue("RSAPIEdgeRowset"));
            IXQEQueryNode child = V5ToCogMDXUtilities.getChildOverSet(v5DataItemRef.getChild(0), 1039);
            if (rsapiRowset != null && child.getType() == 1013 && v5DataItemRef.getAncestorOfType(1080) == null) {
                MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)child;
                calcRef.setV5Caption(refDataItemName);
            }
            v5DataItemRef.move(cogMDXNest);
            v5DataItemRef.extract();
            if (newNode == null) {
                newNode = cogMDXNest;
                parentNode = newNode;
            } else {
                parentNode.addChild(cogMDXNest);
                parentNode = cogMDXNest;
            }
            if (emptyHeaderDeco != null && emptyHeaderDeco.getHierarchy() == null) {
                emptyHeaderDeco.setHierarchy(cogMDXNest.getFirstSetHierarchy());
            }
            if (emptyFooterDeco != null && emptyFooterDeco.getHierarchy() == null) {
                emptyFooterDeco.setHierarchy(cogMDXNest.getFirstSetHierarchy());
            }
            this.copyContextFromRefDataItem(node, refDataItemName, cogMDXNest);
        }
        parent.exchangeChildNode(groupBody, newNode, true);
    }

    private void copyContextFromRefDataItem(IXQEQueryNode node, String refDataItemName, AbstractMDXSet abstractMDXSet) {
        String[] context;
        MDXQuery mdQuerySpec = (MDXQuery)node.getAncestorOfType(1002);
        if (mdQuerySpec == null) {
            return;
        }
        String refQueryName = mdQuerySpec.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Selection v5Selection = v5QuerySet.getV5Query(refQueryName).getV5Selection();
        String errorMsg = "Failed to get referenced data item.";
        V5DataItem v5DataItem = v5Selection.getDataItemByRefName(refDataItemName);
        if (v5DataItem == null) {
            node.throwInternalError("Failed to get referenced data item.");
        }
        if ((context = v5DataItem.getContextProperty()) == null || context.length == 0) {
            return;
        }
        abstractMDXSet.setContextNames(context);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesQueryCondition(node, environment)) {
            return false;
        }
        V5ValueSet valueSet = (V5ValueSet)node;
        if (valueSet.isReportSummary() == null) {
            this.traceQueryCondition(true, "The V5ValueSet node 'isReportSummary' property has been set.", environment.getTrace());
            return true;
        }
        this.traceQueryCondition(false, "The V5ValueSet node 'isReportSummary' property has not been set.", environment.getTrace());
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5GroupBody groupBody;
        IXQEQueryNode[] dataItemRefs;
        IXQEQueryNode[] groupBodyNodes;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("refDataItem") != null) {
            this.traceNodeCondition(false, "The V5ValueSet node has a refDataItem property.", trace);
            return false;
        }
        IXQEQueryNode parent = node;
        IXQEQueryNode[] sortNodes = node.getChildrenOfType(101058);
        if (sortNodes.length == 1) {
            parent = sortNodes[0];
        }
        if ((groupBodyNodes = parent.getChildrenOfType(101051)).length != 1) {
            this.traceNodeCondition(false, "The V5ValueSet node does not have a single V5GroupBody child node.", trace);
            return false;
        }
        if (groupBodyNodes.length == 1 && node.getAncestorOfType(101049) != null) {
            if (RemoveReplicasWithinDetailValueSet.nodeCondition(node, null)) {
                this.traceNodeCondition(false, "Apply first RemoveReplicasWithinDetailValueSet.", trace);
                return false;
            }
            V5ValueSet ancestorValueSet = (V5ValueSet)node.getAncestorOfType(101057);
            if (ancestorValueSet != null) {
                while (ancestorValueSet != null) {
                    if (!ancestorValueSet.getChild(0).isOfCategory(1001)) {
                        this.traceNodeCondition(false, "Ancestor value set set is not an AbstractMDXNode.", trace);
                        return false;
                    }
                    ancestorValueSet = (V5ValueSet)ancestorValueSet.getAncestorOfType(101057);
                }
            }
            if (RemoveReplicasFromGroupBodyHeaderFooter.queryCondition(groupBodyNodes[0], environment, null) && RemoveReplicasFromGroupBodyHeaderFooter.nodeCondition(groupBodyNodes[0], null)) {
                this.traceNodeCondition(false, "Apply first RemoveReplicasFromGroupBodyHeaderFooter.", trace);
                return false;
            }
        }
        if ((dataItemRefs = (groupBody = (V5GroupBody)groupBodyNodes[0]).getChildrenOfType(101015)).length == 0) {
            this.traceNodeCondition(false, "The V5GroupBody child node does not have any V5DataItemRef children.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        boolean isListReport = mdxQuery.isListReport();
        for (int idx = 0; idx < dataItemRefs.length; ++idx) {
            IXQEQueryNode childNode = dataItemRefs[idx].getChild(0);
            if (dataItemRefs[idx].getNumberChildren() == 1 && childNode.isOfCategory(1021)) {
                MDXHierInfo hierarchyInfo = ((AbstractMDXNode)childNode).getHierarchyInfo();
                if (hierarchyInfo.getNumProjectedHierarchies() != 1) {
                    String param = ((V5DataItemRef)dataItemRefs[idx]).getDataItemRefProperty();
                    throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedMultidimensionalDataItem, param);
                }
                IHierarchy hierarchy = hierarchyInfo.getProjectedHierarchy(0);
                if (hierarchy.isShell() || !isListReport || !hierarchy.getDimension().isMeasuresDimension() || V5ToCogMDXUtilities.getChildOverSet(childNode, 1039).isOfCategory(1022)) continue;
                this.traceNodeCondition(false, "The projected expression is a set expression for the measure dimension over a list report.", trace);
                return false;
            }
            this.traceNodeCondition(false, "The V5 DataItemRef has invalid expression.", trace);
            return false;
        }
        int[] types = new int[]{101053, 101052};
        IXQEQueryNode[] groupHeaderFooterNodes = parent.getChildrenOfTypes(types);
        for (int i = 0; i < groupHeaderFooterNodes.length; ++i) {
            IXQEQueryNode[] dRefs = groupHeaderFooterNodes[i].getChildrenOfType(101015);
            if (dRefs.length != 0) continue;
            this.traceNodeCondition(false, "wait for empty groupHeader/Footer to be processed first.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The V5GroupBody child node has at least one V5DataItemRef child node.", trace);
        return true;
    }
}

