/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class CreateMDQueryAxis
extends AbstractV5ToCogMDXTransformation {
    public CreateMDQueryAxis() {
        this.mName = "Convert V5 Edge to MDX Edge";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{101049};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean bReportMeasure;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXEdge mdxEdge = (MDXEdge)nodeFactory.createNode(1006);
        V5Edge v5edge = (V5Edge)node;
        mdxEdge.setSpacerList(v5edge.getSpacerList());
        if (v5edge.getPropertyValue("reportHierarchies") != null) {
            mdxEdge.setPropertyValue("reportHierarchies", v5edge.getPropertyValue("reportHierarchies"));
        }
        if (Boolean.TRUE.equals(bReportMeasure = (Boolean)v5edge.getPropertyValue("reportMeasure"))) {
            mdxEdge.setPropertyValue("reportMeasure", bReportMeasure);
        }
        int edgeId = v5edge.getEdgeID();
        mdxEdge.setEdgeID(edgeId);
        mdxEdge.setV5Name((String)v5edge.getPropertyValue("name"));
        for (IQueryItem property : v5edge.getPropertiesForDimension()) {
            mdxEdge.addCustomMemberProperty(property);
        }
        if (v5edge.getNumberChildren() > 1) {
            IXQEQueryNode mdxSet = nodeFactory.createNode(1039);
            v5edge.getParent().exchangeChildNode(v5edge, mdxSet, true);
            mdxSet.insertParent(mdxEdge);
        } else {
            v5edge.getParent().exchangeChildNode(v5edge, mdxEdge, true);
        }
        MDXQuery mdxQuery = (MDXQuery)mdxEdge.getParent();
        if (CreateMDQueryAxis.propagateV5EdgeNullsSuppressionToMDXEdge(mdxQuery)) {
            boolean visualZeroSuppression;
            boolean visualSuppression = v5edge.isNullVisualSuppression();
            if (visualSuppression) {
                mdxEdge.setMDXNonEmptyProperty(visualSuppression);
            }
            if (visualZeroSuppression = v5edge.isZeroVisualSuppression()) {
                mdxEdge.setPowerCubeZeroSuppress(visualZeroSuppression);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Edge v5edge = (V5Edge)node;
        if (v5edge.getParent() == null || v5edge.getParent().getType() != 1002) {
            this.traceNodeCondition(false, "Wait for the parent to become an MDXQuery.", trace);
            return false;
        }
        IXQEQueryNode[] childSetExpr = node.getChildrenOfCategory(1021);
        if (node.getNumberChildren() >= 1 && node.getNumberChildren() == childSetExpr.length) {
            if (childSetExpr.length == 1) {
                this.traceNodeCondition(true, "The V5 Edge contains a single set expression, i.e. we simply need to collapse the node.", trace);
                return true;
            }
            MDXHierInfo firstExprInfo = ((AbstractMDXSet)childSetExpr[0]).getHierarchyInfo();
            for (int idx = 1; idx < childSetExpr.length; ++idx) {
                MDXHierInfo nextExprInfo = ((AbstractMDXSet)childSetExpr[idx]).getHierarchyInfo();
                if (firstExprInfo.compareProjectedHierarchies(nextExprInfo)) continue;
                this.traceNodeCondition(false, "The expressions within the V5 Edge are not from the same hierarchies.", trace);
                return false;
            }
            this.traceNodeCondition(true, "Need to perform the union of the children expression.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The V5 Edge is invalid...", trace);
        return false;
    }

    public static boolean propagateV5EdgeNullsSuppressionToMDXEdge(MDXQuery mdxQuery) {
        return !mdxQuery.isRelationaCrosstab() && mdxQuery.getCapabilities().isSupported("v5.suppress.nulls.useMDXNonEmpty");
    }
}

