/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeProjProperty;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;

public class HandleRowsProjectingDuplicatedSets
extends AbstractV5ToCogMDXTransformation {
    public static final int ASSOCIATED_TO_DEFINITION_SET = -2;
    public static final int FULL_SET_ON_HIERARCHY = 1;
    public static final int FULL_SET_ON_LEVEL = 2;
    public static final String TRANFORMATION_APPLIED = "HandleRowsProjectingDuplicatedSetsApplied";

    public HandleRowsProjectingDuplicatedSets() {
        this.mName = "Handle rows projecting duplicated sets.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1027, 1026};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXSet projSet = (AbstractMDXSet)node;
        AbstractMDXSet associateSet = null;
        if (projSet.getType() == 1026 && projSet.getChild(0).getType() == 1116) {
            associateSet = HandleRowsProjectingDuplicatedSets.findSameGroupSetToAssociateProperty((TNodeProjProperty)projSet.getChild(0));
        }
        if (associateSet == null) {
            associateSet = HandleRowsProjectingDuplicatedSets.findOuterSetToAssociateMemberSet(projSet);
        }
        RSAPIEdgeRowset projRowset = null;
        int projDataItemIndex = -1;
        if (projSet.isOfCategory(1027) && (projRowset = ((CogMDXGroup)projSet).getRSAPIEdgeRowset()) != null) {
            projDataItemIndex = projRowset.getDataItemOrdinal(((CogMDXGroup)projSet).getFirstRSAPIDataItem());
        }
        if (projSet.isOfCategory(1026) && (projRowset = ((CogMDXNest)projSet).getRSAPIEdgeRowset()) != null) {
            projDataItemIndex = projRowset.getDataItemOrdinal(((CogMDXNest)projSet).getFirstRSAPIDataItem());
        }
        if (projRowset != null) {
            associateSet.appendDataItemIndexProjectingSameSet(projRowset.getRowsetId(), projDataItemIndex);
        }
        associateSet.appendDataItemIndexProjectingSameSet(projSet.getDataItemIndexesProjectingSameSet());
        HandleRowsProjectingDuplicatedSets.updateQueryOfAssociatedSet(projSet, associateSet);
        HandleRowsProjectingDuplicatedSets.associateProjectSets((AbstractMDXSet)projSet.getChild(0), (AbstractMDXSet)associateSet.getChild(0));
        projSet.extract();
    }

    private static CogMDXNest findSameGroupSetToAssociateProperty(TNodeProjProperty projProperty) {
        MDXHierInfo nestHierInfo;
        AbstractMDXSet projSet = (AbstractMDXSet)projProperty.getChild(0);
        MDXHierInfo projHierInfo = projSet.getHierarchyInfo();
        AbstractMDXSet aNestSet = null;
        ArrayList<CogMDXNest> allNestSets = new ArrayList<CogMDXNest>();
        IXQEQueryNode aNestNode = projProperty.getAncestorOfType(1026);
        while (aNestNode != null) {
            if ((aNestNode = aNestNode.getAncestorOfType(1026)) == null || !projHierInfo.compareProjectedHierarchies(nestHierInfo = (aNestSet = (AbstractMDXSet)aNestNode.getChild(0)).getHierarchyInfo())) continue;
            allNestSets.add((CogMDXNest)aNestNode);
        }
        aNestNode = projProperty.getAncestorOfType(1026);
        while (aNestNode.getChildrenOfType(1026).length == 1) {
            aNestSet = (AbstractMDXSet)(aNestNode = aNestNode.getChildrenOfType(1026)[0]).getChild(0);
            nestHierInfo = aNestSet.getHierarchyInfo();
            if (!projHierInfo.compareProjectedHierarchies(nestHierInfo)) continue;
            allNestSets.add((CogMDXNest)aNestNode);
        }
        CogMDXNest retNest = null;
        int retMatchLevel = -1;
        for (CogMDXNest aNest : allNestSets) {
            aNestSet = (AbstractMDXSet)aNest.getChild(0);
            int propMatchLevel = HandleRowsProjectingDuplicatedSets.canPropertyBeAssociated(projProperty, aNestSet);
            if (propMatchLevel == -2) {
                retNest = aNest;
                break;
            }
            if (propMatchLevel == -1 || retNest != null && propMatchLevel >= retMatchLevel) continue;
            retNest = aNest;
            retMatchLevel = propMatchLevel;
        }
        return retNest;
    }

    private static AbstractMDXSet findOuterSetToAssociateMemberSet(AbstractMDXSet projGroup) {
        IXQEQueryNode parentGroup;
        int[] edgeNodes = new int[]{101049, 1006};
        if (projGroup.getAncestorOfTypes(edgeNodes) == null) {
            return null;
        }
        int[] types = new int[]{1027, 1026};
        AbstractMDXSet projSet = (AbstractMDXSet)projGroup.getChild(0);
        MDXHierInfo projHierInfo = projSet.getHierarchyInfo();
        AbstractMDXSet parentSet = null;
        MDXHierInfo parentHierInfo = null;
        for (parentGroup = projGroup.getAncestorOfTypes(types); parentGroup != null; parentGroup = parentGroup.getAncestorOfTypes(types)) {
            if (parentGroup.getNumberChildren() == 0 || !parentGroup.getChild(0).isOfCategory(1021)) {
                return null;
            }
            parentSet = (AbstractMDXSet)parentGroup.getChild(0);
            parentHierInfo = parentSet.getHierarchyInfo();
            if (!projHierInfo.compareProjectedHierarchies(parentHierInfo)) continue;
            if (HandleRowsProjectingDuplicatedSets.canMemberSetBeAssociated(projSet, parentSet)) break;
            if (parentGroup.getType() != 1027) continue;
            parentGroup = null;
            break;
        }
        if (parentGroup != null) {
            return (AbstractMDXSet)parentGroup;
        }
        return null;
    }

    private static int isFullSet(IXQEQueryNode projSet) {
        if (projSet.getType() == 1073 || projSet.getType() == 1040 && projSet.getNumberChildren() == 1 && projSet.getChild(0).getType() == 1073) {
            return 1;
        }
        if (projSet.getType() == 1065 || projSet.getType() == 1040 && projSet.getNumberChildren() == 1 && projSet.getChild(0).getType() == 1065) {
            return 2;
        }
        return 0;
    }

    private static AbstractMDXNode getProjectedSet(AbstractMDXNode projSet) {
        if (projSet.getType() == 1116) {
            projSet = (AbstractMDXSet)projSet.getChild(0);
        }
        while (projSet != null && projSet.getType() == 1039 && projSet.getNumberChildren() == 1) {
            projSet = (AbstractMDXNode)projSet.getChild(0);
        }
        return projSet;
    }

    public static int canPropertyBeAssociated(TNodeProjProperty projProperty, AbstractMDXNode associateSet) {
        AbstractMDXNode projSet = HandleRowsProjectingDuplicatedSets.getProjectedSet(projProperty);
        IHierarchy projHier = projSet.getHierarchyInfo().getProjectedHierarchy(0);
        if (projSet.isSameExpression(associateSet = HandleRowsProjectingDuplicatedSets.getProjectedSet(associateSet), false)) {
            return -2;
        }
        if (HandleRowsProjectingDuplicatedSets.isFullSet(projSet) == 1) {
            MDXLevelInfo associateLevelInfo;
            if (HandleRowsProjectingDuplicatedSets.isFullSet(associateSet) == 1) {
                return -2;
            }
            if (!associateSet.isContextDependent(projHier) && (associateLevelInfo = associateSet.getLevelInfo()).getNumProjectedLevels(projHier) > 0) {
                return associateLevelInfo.getLowestProjectedLevel(projHier).getIndex();
            }
            return -1;
        }
        if (HandleRowsProjectingDuplicatedSets.isFullSet(projSet) == 2) {
            ILevel projLevel = projSet.getLevelInfo().getProjectedLevel(projHier, 0);
            if (associateSet.isContextDependent(projHier)) {
                return -1;
            }
            MDXLevelInfo associateLevelInfo = associateSet.getLevelInfo();
            if (associateLevelInfo.getNumProjectedLevels(projHier) == 1 && associateLevelInfo.getProjectedLevel(projHier, 0) == projLevel) {
                return -2;
            }
        }
        return -1;
    }

    private static boolean canMemberSetBeAssociated(AbstractMDXNode projSet, AbstractMDXNode associateSet) {
        IXQEQueryNode initAssociateGroup = associateSet.getParent();
        projSet = HandleRowsProjectingDuplicatedSets.getProjectedSet(projSet);
        associateSet = HandleRowsProjectingDuplicatedSets.getProjectedSet(associateSet);
        if (projSet == null || associateSet == null) {
            return false;
        }
        if (projSet.getType() == 1076 && initAssociateGroup.getType() == 1027) {
            return true;
        }
        IHierarchy projHier = projSet.getHierarchyInfo().getProjectedHierarchy(0);
        if (projSet.isContextDependent(projHier) || associateSet.isContextDependent(projHier)) {
            return false;
        }
        if (projSet.isSameExpression(associateSet, false) && projSet.noAncestorDescendantRelationshipAmongProjectedMembers()) {
            return true;
        }
        MDXLevelInfo projLevelInfo = projSet.getLevelInfo();
        MDXLevelInfo associateLevelInfo = associateSet.getLevelInfo();
        if (projLevelInfo.getNumProjectedLevels(projHier) == 1 && associateLevelInfo.getNumProjectedLevels(projHier) == 1) {
            ILevel associateLevel;
            ILevel projLevel = projLevelInfo.getProjectedLevel(projHier, 0);
            return projLevel.equals(associateLevel = associateLevelInfo.getProjectedLevel(projHier, 0)) && HandleRowsProjectingDuplicatedSets.isFullSet(projSet) == 2;
        }
        return projHier.isParentChild() && projLevelInfo.projectedLevelsOverlap(associateLevelInfo) && projSet.getParent().getType() != 1027 && (projSet.getParent().getType() == 1116 || associateSet.getParent().getType() == 1116);
    }

    public static void associateProjectSets(AbstractMDXSet projSet, AbstractMDXSet associateSet) {
        projSet.detach();
        if (projSet.getType() == 1116) {
            if (associateSet.getType() != 1116) {
                projSet.detachChild(0);
                associateSet.insertParent(projSet);
                projSet.addChild(associateSet.detach(), 0);
                projSet.setPropertyValue(TRANFORMATION_APPLIED, Boolean.TRUE);
            } else {
                int numProperties = projSet.getNumberChildren();
                while (--numProperties > 0) {
                    IXQEQueryNode propNode = projSet.getChild(numProperties);
                    associateSet.addChild(propNode.detach());
                }
                if (projSet.getPropertyValue(TRANFORMATION_APPLIED) != null) {
                    associateSet.setPropertyValue(TRANFORMATION_APPLIED, Boolean.TRUE);
                }
            }
        } else if (associateSet.getType() == 1116) {
            associateSet.detachChild(0);
            projSet.insertParent(associateSet);
            associateSet.addChild(projSet.detach(), 0);
            associateSet.setPropertyValue(TRANFORMATION_APPLIED, Boolean.TRUE);
        }
    }

    public static void updateQueryOfAssociatedSet(IXQEQueryNode projSet, IXQEQueryNode associateSet) {
        String oldGroupName = (String)projSet.getPropertyValue("refDataItem");
        String newGroupName = (String)associateSet.getPropertyValue("refDataItem");
        if (oldGroupName != null && newGroupName != null) {
            MDXQuery queryNode = (MDXQuery)projSet.getAncestorOfType(1002);
            if (queryNode == null) {
                return;
            }
            IXQEQueryNode[] cogSummaryFilter = queryNode.getDescendantsOfType(1011, false);
            for (int j = 0; j < cogSummaryFilter.length; ++j) {
                ((CogMDXSummaryFilter)cogSummaryFilter[j]).replaceScopedDateItemName(oldGroupName, newGroupName);
            }
            IXQEQueryNode[] reportSummaries = queryNode.getDescendantsOfType(1080, false);
            if (reportSummaries.length == 0) {
                return;
            }
            int depth = 1;
            for (IXQEQueryNode parent = projSet.getParent(); parent != null && parent.getType() == 1027 && !newGroupName.equals(parent.getPropertyValue("refDataItem")); parent = parent.getParent()) {
                ++depth;
            }
            for (int idx = 0; idx < reportSummaries.length; ++idx) {
                IXQEQueryNode[] groupNodes;
                CogMDXReportSummary reportSummary = (CogMDXReportSummary)reportSummaries[idx];
                if (reportSummary.getDetailExpr() == projSet) {
                    reportSummary.bindSummaryToDetailExpr(associateSet);
                }
                int[] types = new int[]{1027, 1026};
                for (IXQEQueryNode groupNode : groupNodes = reportSummary.getDescendantsOfTypes(types, false)) {
                    if (!oldGroupName.equals(groupNode.getPropertyValue("refDataItem"))) continue;
                    if (projSet.getType() == 1026 && associateSet.getType() == 1026) {
                        groupNode.detachChild(0);
                        groupNode.extract();
                        continue;
                    }
                    IXQEQueryNode parentNode = groupNode.getParent();
                    for (int i = 1; parentNode != null && parentNode.getType() == 1027 && i < depth; ++i, parentNode = parentNode.getParent()) {
                    }
                    if (!newGroupName.equals(parentNode.getPropertyValue("refDataItem"))) continue;
                    groupNode.detachChild(0);
                    groupNode.extract();
                }
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = null;
        if (trace != null && (trace.getTraceLevel() & 1) != 0) {
            traceMsg = new StringBuilder();
        }
        boolean status = HandleRowsProjectingDuplicatedSets.nodeCondition(node, environment, traceMsg);
        if (traceMsg != null) {
            this.traceNodeCondition(status, traceMsg.toString(), trace);
        }
        return status;
    }

    public static boolean nodeCondition(IXQEQueryNode node, PlanningEnvironment environment, StringBuilder traceMsg) {
        AbstractMDXSet firstChildExpression;
        MDXHierInfo firstChildHierarchyInfo;
        if (node.getAncestorOfType(1006) == null) {
            if (traceMsg != null) {
                traceMsg.append("Wait for the MDXEdge to be created.");
            }
            return false;
        }
        if (node.getAncestorOfType(1080) != null) {
            if (traceMsg != null) {
                traceMsg.append("This CogMDXGroup(Nest) node is in reportSummary.");
            }
            return false;
        }
        IXQEQueryNode parentGroup = node.getAncestorOfType(1027);
        if (parentGroup != null) {
            if (parentGroup.getChild(1).getType() == 1039) {
                IXQEQueryNode siblingSet = parentGroup.getChild(1);
                if (siblingSet.getNumberChildren() != 2 || siblingSet.getChild(1).getType() == 1027 || siblingSet.getChild(1).getDescendantsOfType(1080, true).length > 0) {
                    if (traceMsg != null) {
                        traceMsg.append("This CogMDXGroup(Nest) node has other siblings.");
                    }
                    return false;
                }
            } else if (parentGroup.getDescendantsOfType(1117, false).length > 0) {
                if (traceMsg != null) {
                    traceMsg.append("This CogMDXGroup(Nest) node has sorting.");
                }
                return false;
            }
        }
        if ((firstChildHierarchyInfo = (firstChildExpression = (AbstractMDXSet)node.getChild(0)).getHierarchyInfo()) == null || firstChildHierarchyInfo.getNumProjectedHierarchies() > 1) {
            if (traceMsg != null) {
                traceMsg.append("This CogMDXGroup(Nest) node has invalid hierarchy information.");
            }
            return false;
        }
        IHierarchy hierarchy = firstChildHierarchyInfo.getProjectedHierarchy(0);
        if (hierarchy.isShell() || hierarchy.getDimension().isMeasuresDimension()) {
            if (traceMsg != null) {
                traceMsg.append("This CogMDXGroup(Nest) node projects measure set.");
            }
            return false;
        }
        if (node.getType() == 1026 && firstChildExpression.getType() == 1116 && firstChildExpression.getPropertyValue(TRANFORMATION_APPLIED) == null && HandleRowsProjectingDuplicatedSets.isFullSet(firstChildExpression.getChild(0)) > 0 && HandleRowsProjectingDuplicatedSets.findSameGroupSetToAssociateProperty((TNodeProjProperty)firstChildExpression) != null) {
            if (traceMsg != null) {
                traceMsg.append("This CogMDXGroup(Nest) node projects a property ");
                traceMsg.append("that can be associated to another set in the same group.");
            }
            return true;
        }
        if (firstChildExpression.isContextDependent(hierarchy) || HandleRowsProjectingDuplicatedSets.findOuterSetToAssociateMemberSet((AbstractMDXSet)node) == null) {
            if (traceMsg != null) {
                traceMsg.append("This CogMDXGroup(Nest) node is not nested under another same hierarchy set.");
            }
            return false;
        }
        if (traceMsg != null) {
            traceMsg.append("This CogMDXGroup(Nest) node will be associated to another same level set if possible.");
        }
        return true;
    }
}

