/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AbstractAssignHierToCalcMemberInValueSet;
import java.util.List;
import java.util.Set;

public class AssignHierarchyToCalculatedMemberSiblingInTuple
extends Transformation {
    public AssignHierarchyToCalculatedMemberSiblingInTuple() {
        this.mName = "Assign a hierarchy to non-projected calculated member in the context of a tuple already containing a measure.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition = ((MDXCalculatedMemberReference)node).getDefinition();
        mdxCalculatedMemberDefinition.throwOnInvalidChildCategories();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Set<IHierarchy> queryHierarchies = AbstractAssignHierToCalcMemberInValueSet.getReferencedHierarchies(mdxQuery);
        MDXTuple parentTuple = (MDXTuple)node.getParent();
        MDXHierInfo tupleHierInfo = parentTuple.getHierarchyInfo();
        List<IHierarchy> tupleHierarchies = tupleHierInfo.getProjectedHierarchies();
        MDXHierInfo calcRealHierInfo = AbstractAssignHierToCalcMemberInValueSet.resolveMDXHierInfoForCalculation((MDXCalculatedMemberReference)node);
        IHierarchy hierarchy = null;
        for (IHierarchy currHierarchy : queryHierarchies) {
            if (tupleHierarchies.contains(currHierarchy) || !calcRealHierInfo.projectsHierarchy(currHierarchy)) continue;
            hierarchy = currHierarchy;
            break;
        }
        if (hierarchy == null) {
            for (IHierarchy currHierarchy : queryHierarchies) {
                if (tupleHierarchies.contains(currHierarchy)) continue;
                hierarchy = currHierarchy;
                break;
            }
        }
        if (hierarchy == null) {
            hierarchy = AbstractAssignHierToCalcMemberInValueSet.getUnreferencedHierarchy(mdxQuery);
        }
        if (hierarchy == null) {
            Integer nodeId = node.getId();
            throw new XQERuntimeException(XQEMessageKeys.PLN_AssignHierarchyToCalculatedMemberFail, nodeId.toString());
        }
        mdxCalculatedMemberDefinition.setHierarchy(hierarchy);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getParent().getType() != 1069) {
            this.traceNodeCondition(false, "The parent node is not an MDXTuple.", trace);
            return false;
        }
        MDXHierInfo tupleMDXHierInfo = ((MDXTuple)node.getParent()).getHierarchyInfo();
        if (!tupleMDXHierInfo.projectsMeasures()) {
            this.traceNodeCondition(false, "The parent tuple does not project measures.", trace);
            return false;
        }
        boolean status = AbstractAssignHierToCalcMemberInValueSet.validateCalcDefinition((MDXCalculatedMemberReference)node, environment);
        if (!status) {
            this.traceQueryCondition(false, "The target node is not a valid planned node yet.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The MDXCalculatedMemberReference node is not within an MDXQuery node.", trace);
            return false;
        }
        MDXHierInfo mdxHierInfo = ((MDXCalculatedMemberReference)node).getHierarchyInfo();
        if (!mdxHierInfo.projectsShellHierarchy()) {
            this.traceNodeCondition(status, "The hierarchy of the calculated member has been resolved already.", trace);
            return false;
        }
        IXQEQueryNode v5Edge = node.getAncestorOfType(101049);
        if (v5Edge != null) {
            this.traceNodeCondition(false, "The MDXCalculatedMemberReference node is within an V5Edge node.", trace);
            return false;
        }
        MDXEdge mdxEdge = (MDXEdge)node.getAncestorOfType(1006);
        if (mdxEdge != null && mdxEdge.isProjectedDescendant((MDXCalculatedMemberReference)node)) {
            this.traceNodeCondition(status, "The node is projected.", trace);
            return false;
        }
        MDXCalculatedMemberDefinition definition = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        if (definition != null && !mdxQuery.getProjectedReferences(definition).isEmpty() && definition.getHierarchy() == ((MDXCalculatedMemberReference)node).getHierarchy()) {
            this.traceNodeCondition(status, "The ancestor MDXCalculatedMemberDefinition is using the same shell hierarchy.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The parent tuple does project measures.", trace);
        return true;
    }
}

