/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AbstractAssignHierToCalcMemberInValueSet;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.ChosenHierarchy;
import java.util.List;

public class HandleSpacerCalcMembersWithShellHiearchy
extends AbstractAssignHierToCalcMemberInValueSet {
    private static final String PARENT_V5_GROUP_NULL = "parentV5Group == null";
    private static final String GRANDPARENT_V5_GROUP_NULL = "grandparentV5Group == null";
    private static final String GRANDPARENT_COGMDXGROUP_NULL = "grandparentCogMDXGroup == null";

    public HandleSpacerCalcMembersWithShellHiearchy() {
        this.mName = "Transforms the crosstab spacer calc into a currentMember of the hierarchy of the ancestor CogMDXGroup.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        ChosenHierarchy result = this.resolveCalculationHierarchy(node);
        MDXCalculatedMemberReference calcMemberReference = (MDXCalculatedMemberReference)node;
        HandleSpacerCalcMembersWithShellHiearchy.applyHierarchy(calcMemberReference, environment, result, true);
        MDXCurrentMember currMember = MDXBuilder.buildMDXCurrentMemberExpr(factory, result.getChosenHiearchy());
        calcMemberReference.getParent().exchangeChildNode(node, currMember);
    }

    @Override
    protected ChosenHierarchy resolveCalculationHierarchy(IXQEQueryNode node) {
        MDXCalculatedMemberReference calcMemberReference = (MDXCalculatedMemberReference)node;
        IHierarchy hierarchy = null;
        CogMDXGroup parentGroup = (CogMDXGroup)calcMemberReference.getAncestorOfCategory(1027);
        if (parentGroup != null) {
            CogMDXGroup grandparentGroup = (CogMDXGroup)parentGroup.getAncestorOfCategory(1027);
            if (grandparentGroup == null) {
                node.throwInternalError(GRANDPARENT_COGMDXGROUP_NULL);
            }
            hierarchy = grandparentGroup.getHierarchyInfo().getProjectedHierarchy(0);
        } else {
            V5EdgeGroup grandParentV5Group;
            V5EdgeGroup parentV5Group = (V5EdgeGroup)calcMemberReference.getAncestorOfType(101050);
            if (parentV5Group == null) {
                node.throwInternalError(PARENT_V5_GROUP_NULL);
            }
            if ((grandParentV5Group = (V5EdgeGroup)parentV5Group.getAncestorOfType(101050)) == null) {
                node.throwInternalError(GRANDPARENT_V5_GROUP_NULL);
            }
            hierarchy = grandParentV5Group.getPropertyHierarchy();
        }
        ChosenHierarchy result = new ChosenHierarchy();
        result.setChosenHiearchy(hierarchy);
        result.setTakenFrom("the hiearchy at or above the calculation depth.");
        result.setDefinition(calcMemberReference.getDefinition());
        return result;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberReference calculatedMemberReference = (MDXCalculatedMemberReference)node;
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberDefinition definition = calculatedMemberReference.getDefinition();
        IHierarchy hierarchy = definition.getHierarchy();
        String notApplicable = "Target calculated references is not a crosstab spacers assigned to a shell hierarchy.";
        if (!hierarchy.isShell()) {
            this.traceNodeCondition(false, "Target calculated references is not a crosstab spacers assigned to a shell hierarchy.", trace);
            return false;
        }
        if (HandleSpacerCalcMembersWithShellHiearchy.isNestedCrosstabSpacerWithCellValue(calculatedMemberReference)) {
            MDXQuery mdxQuery = (MDXQuery)definition.getAncestorOfType(1002);
            IXQEQueryNode[] definitions = mdxQuery.getChildrenOfType(1005);
            ChosenHierarchy result = this.resolveCalculationHierarchy(calculatedMemberReference);
            if (result.getChosenHiearchy() == null) {
                this.traceNodeCondition(false, "Target calculated references is not a crosstab spacers assigned to a shell hierarchy.", trace);
                return false;
            }
            for (int i = 0; i < definitions.length; ++i) {
                IHierarchy currHierarchy = ((MDXCalculatedMemberDefinition)definitions[i]).getHierarchy();
                if (!currHierarchy.equals(hierarchy)) continue;
                ((MDXCalculatedMemberDefinition)definitions[i]).setHierarchy(hierarchy);
                List<MDXCalculatedMemberReference> calcRefs = ((MDXCalculatedMemberDefinition)definitions[i]).getCalcMemberRefs();
                for (MDXCalculatedMemberReference currCalcRef : calcRefs) {
                    V5EdgeGroup grandPV5Group;
                    if (calculatedMemberReference == currCalcRef || null != currCalcRef.getAncestorOfCategory(1005)) continue;
                    CogMDXGroup parentGroup = (CogMDXGroup)currCalcRef.getAncestorOfCategory(1027);
                    IHierarchy grandparentHierarchy = null;
                    boolean grandPProjectsCalculation = false;
                    if (parentGroup != null) {
                        CogMDXGroup grandparentGroup = (CogMDXGroup)parentGroup.getAncestorOfCategory(1027);
                        if (grandparentGroup != null) {
                            grandparentHierarchy = grandparentGroup.getHierarchyInfo().getProjectedHierarchy(0);
                            grandPProjectsCalculation = grandparentGroup.getChild(0).getType() == 1039 && ((MDXSet)grandparentGroup.getChild(0)).getChildrenOfType(1013).length > 0;
                        } else {
                            grandPV5Group = (V5EdgeGroup)parentGroup.getAncestorOfType(101050);
                            if (grandPV5Group == null) {
                                currCalcRef.throwInternalError(GRANDPARENT_V5_GROUP_NULL);
                            }
                            grandparentHierarchy = grandPV5Group.getPropertyHierarchy();
                            boolean bl = grandPProjectsCalculation = grandPV5Group.getChild(0).getType() == 101057 && grandPV5Group.getChild(0).getChild(0).getType() == 1039 && grandPV5Group.getChild(0).getChild(0).getChildrenOfType(1013).length > 0;
                            if (!grandPProjectsCalculation) {
                                grandPProjectsCalculation = grandPV5Group.getChild(0).getType() == 101057 && grandPV5Group.getChild(0).getChild(0).getType() == 201101 && grandPV5Group.getChild(0).getChild(0).getChildrenOfType(201085).length > 0;
                            }
                        }
                    } else {
                        V5EdgeGroup parentV5Group = (V5EdgeGroup)currCalcRef.getAncestorOfType(101050);
                        if (parentV5Group == null) {
                            currCalcRef.throwInternalError(PARENT_V5_GROUP_NULL);
                        }
                        if ((grandPV5Group = (V5EdgeGroup)parentV5Group.getAncestorOfType(101050)) == null) {
                            currCalcRef.throwInternalError(GRANDPARENT_V5_GROUP_NULL);
                        }
                        grandparentHierarchy = grandPV5Group.getPropertyHierarchy();
                        boolean bl = grandPProjectsCalculation = grandPV5Group.getChild(0).getType() == 101057 && grandPV5Group.getChild(0).getChild(0).getType() == 1039 && grandPV5Group.getChild(0).getChild(0).getChildrenOfType(1013).length > 0;
                        if (!grandPProjectsCalculation) {
                            boolean bl2 = grandPProjectsCalculation = grandPV5Group.getChild(0).getType() == 101057 && grandPV5Group.getChild(0).getChild(0).getType() == 201101 && grandPV5Group.getChild(0).getChild(0).getChildrenOfType(201085).length > 0;
                        }
                    }
                    if (!grandPProjectsCalculation || grandparentHierarchy == null || !grandparentHierarchy.equals(result.getChosenHiearchy())) continue;
                    this.traceNodeCondition(false, "The transformation is not applicable.", trace);
                    return false;
                }
            }
            String msg = "Target calculated references is a crosstab spacers assigned to a shell hierarchy.";
            this.traceNodeCondition(true, "Target calculated references is a crosstab spacers assigned to a shell hierarchy.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Target calculated references is not a crosstab spacers assigned to a shell hierarchy.", trace);
        return false;
    }

    public static boolean isNestedCrosstabSpacerWithCellValue(MDXCalculatedMemberReference calculatedMemberReference) {
        V5EdgeGroup grandParentV5Group;
        V5EdgeGroup parentV5Group;
        V5ValueSet parentValueSet;
        CogMDXGroup grandparentGroup;
        IHierarchy calcHierarchy = calculatedMemberReference.getDefinition().getHierarchy();
        CogMDXGroup parentGroup = (CogMDXGroup)calculatedMemberReference.getAncestorOfType(1027);
        if (parentGroup != null && parentGroup.isSpacerReplacement() && (grandparentGroup = (CogMDXGroup)parentGroup.getAncestorOfType(1027)) != null && grandparentGroup.isProjectedDescendant(parentGroup) && !grandparentGroup.getHierarchyInfo().getProjectedHierarchy(0).isShell()) {
            MDXHierInfo patternHierInfo = null;
            V5Edge v5Edge = (V5Edge)calculatedMemberReference.getAncestorOfType(101049);
            if (v5Edge != null) {
                patternHierInfo = v5Edge.getPropertyPatternHierInfo();
            }
            if (patternHierInfo == null) {
                calculatedMemberReference.throwInternalError("Failed to compute the hierarchy info for the edge projecting this calculation.");
            }
            boolean isCalcHierarchyLastInPattern = patternHierInfo.projectsHierarchy(calcHierarchy) && patternHierInfo.getProjectedHierarchyIndex(calcHierarchy) == patternHierInfo.getNumProjectedHierarchies() - 1;
            IHierarchy grandparentGroupHier = grandparentGroup.getFirstSetHierarchy();
            int grandparentGroupHierIdx = patternHierInfo.getProjectedHierarchyIndex(grandparentGroupHier);
            if (!isCalcHierarchyLastInPattern && grandparentGroupHierIdx < patternHierInfo.getNumProjectedHierarchies() - 1 && parentGroup.getNumberChildren() == 1) {
                return false;
            }
            if (grandparentGroupHierIdx < patternHierInfo.getNumProjectedHierarchies() - 1 && parentGroup.getNumberChildren() > 1) {
                IHierarchy nestedUndeCalcHier = parentGroup.getHierarchyInfo().getProjectedHierarchy(1);
                if (nestedUndeCalcHier.isShell() || !patternHierInfo.projectsHierarchy(nestedUndeCalcHier)) {
                    return false;
                }
                int nestedUndeCalcHierIdx = patternHierInfo.getProjectedHierarchyIndex(nestedUndeCalcHier);
                if (nestedUndeCalcHierIdx > grandparentGroupHierIdx + 1) {
                    return false;
                }
            }
            if (!BuildXOLAPEdgeMappingUtilities.isDMForNormalization(grandparentGroup.getRefDataItemProperty())) {
                return true;
            }
        }
        if (parentGroup == null && (parentValueSet = (V5ValueSet)calculatedMemberReference.getAncestorOfType(101057)) != null && parentValueSet.isSpacerReplacement() && (parentV5Group = (V5EdgeGroup)parentValueSet.getAncestorOfType(101050)) != null && parentV5Group.getPropertyHierarchy().equals(calculatedMemberReference.getDefinition().getHierarchy()) && (grandParentV5Group = (V5EdgeGroup)parentV5Group.getAncestorOfType(101050)) != null && grandParentV5Group.getPropertyHierarchy() != null && !grandParentV5Group.getPropertyHierarchy().isShell()) {
            V5Edge v5Edge = (V5Edge)calculatedMemberReference.getAncestorOfType(101049);
            MDXHierInfo patternHierInfo = v5Edge.getPropertyPatternHierInfo();
            boolean isCalcHierarchyLastInPattern = patternHierInfo.projectsHierarchy(calcHierarchy) && patternHierInfo.getProjectedHierarchyIndex(calcHierarchy) == patternHierInfo.getNumProjectedHierarchies() - 1;
            IHierarchy grandparentGroupHier = grandParentV5Group.getPropertyHierarchy();
            int grandparentGroupHierIdx = patternHierInfo.getProjectedHierarchyIndex(grandparentGroupHier);
            if (!isCalcHierarchyLastInPattern && grandparentGroupHierIdx < patternHierInfo.getNumProjectedHierarchies() - 1 && parentValueSet.getNumberChildren() == 1) {
                return false;
            }
            if (grandparentGroupHierIdx < patternHierInfo.getNumProjectedHierarchies() - 1 && parentValueSet.getNumberChildren() > 1 && parentValueSet.getChildrenOfType(101050) != null) {
                for (IXQEQueryNode nestedV5Group : parentValueSet.getChildrenOfType(101050)) {
                    IHierarchy nestedUndeCalcHier = ((V5EdgeGroup)nestedV5Group).getPropertyHierarchy();
                    if (nestedUndeCalcHier.isShell() || !patternHierInfo.projectsHierarchy(nestedUndeCalcHier)) {
                        return false;
                    }
                    int nestedUndeCalcHierIdx = patternHierInfo.getProjectedHierarchyIndex(nestedUndeCalcHier);
                    if (nestedUndeCalcHierIdx <= grandparentGroupHierIdx + 1) continue;
                    return false;
                }
            }
            if (!BuildXOLAPEdgeMappingUtilities.isDMForNormalization(((V5ValueSet)grandParentV5Group.getChild(0)).getRefDataItemProperty())) {
                return true;
            }
        }
        return false;
    }
}

