/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.NormalizedCalcGroup;
import java.util.List;

public class NormalizeNotInnermostCalcGroup
extends Transformation {
    private static final String PLN_INVALID_HIERARCHIES = "PLN_InvalidHierarchies";
    private static final String THE_TRANSFORMATION_IS_NOT_APPLICABLE = "The transformation is not applicable.";
    protected static final String TRANSFORMATION_APPLIED = "NormalizeNotInnermostCalcGroupApplied";
    public static final String CURRENT_MEMBER_OF_CALC = "currentMemberOfCalc";
    public static final String FIRST_CURRENT_MEMBER_OF_CALC = "firstCurrentMemberOfCalc";

    public NormalizeNotInnermostCalcGroup() {
        this.mName = "Normalizes a not innermost MDXCalculatedMemberReference's CogMDXGroup.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
        MDXCalculatedMemberReference calculatedMemberReference = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition definition = calculatedMemberReference.getDefinition();
        IHierarchy calcHierarchy = definition.getHierarchy();
        CogMDXGroup parentGroup = (CogMDXGroup)calculatedMemberReference.getParent().getParent();
        MDXHierInfo patternHierInfo = NormalizedCalcGroup.findPaternHierInfo(calcHierarchy, parentGroup);
        int calcHierIndex = patternHierInfo.getProjectedHierarchyIndex(calcHierarchy);
        int startIndex = -1;
        if (parentGroup.getParent().getType() == 1039) {
            for (IXQEQueryNode sibling : parentGroup.getParent().getChildren()) {
                IHierarchy siblingHier;
                int siblinHierIndex;
                if (sibling == parentGroup || (siblinHierIndex = patternHierInfo.getProjectedHierarchyIndex(siblingHier = ((CogMDXGroup)sibling).getFirstSetHierarchy())) >= calcHierIndex) continue;
                if (startIndex == -1) {
                    startIndex = siblinHierIndex;
                    continue;
                }
                if (startIndex <= siblinHierIndex) continue;
                startIndex = siblinHierIndex;
            }
        }
        if (startIndex == -1) {
            startIndex = calcHierIndex + 1;
        }
        CogMDXGroup grandparentGroup = (CogMDXGroup)parentGroup.getAncestorOfCategory(1027);
        IHierarchy grandparentGroupHier = null;
        if (grandparentGroup != null) {
            grandparentGroupHier = grandparentGroup.getFirstSetHierarchy();
        }
        List<IHierarchy> hierarchies = patternHierInfo.getProjectedHierarchies();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXGroup targetGroup = parentGroup;
        MDXHierInfo targetGroupHierInfo = null;
        try {
            targetGroupHierInfo = targetGroup.getHierarchyInfo();
        }
        catch (XQERuntimeException e) {
            if (e.getMessageKey().getName().equals(PLN_INVALID_HIERARCHIES)) {
                targetGroupHierInfo = null;
            }
            throw e;
        }
        if (targetGroupHierInfo == null && targetGroup.getNumberChildren() == 2 && targetGroup.getChild(1).getType() == 1039) {
            for (IXQEQueryNode nestedGroup : targetGroup.getChild(1).getChildren()) {
                CogMDXGroup aNestedGroup = (CogMDXGroup)nestedGroup;
                IHierarchy nestedGroupHier = aNestedGroup.getFirstSetHierarchy();
                startIndex = calcHierarchy.equals(nestedGroupHier) ? calcHierIndex + 1 : calcHierIndex;
                targetGroup = aNestedGroup;
                targetGroupHierInfo = targetGroup.getHierarchyInfo();
                grandparentGroupHier = calcHierarchy;
                this.normalizeHierarchies(targetGroupHierInfo, calcHierIndex, startIndex, grandparentGroupHier, hierarchies, nodeFactory, targetGroup);
            }
        } else {
            this.normalizeHierarchies(targetGroupHierInfo, calcHierIndex, startIndex, grandparentGroupHier, hierarchies, nodeFactory, targetGroup);
        }
    }

    private void normalizeHierarchies(MDXHierInfo targetGroupHierInfo, int calcHierIndex, int startIndex, IHierarchy grandparentGroupHier, List<IHierarchy> hierarchies, IXQENodeFactory nodeFactory, CogMDXGroup targetGroup) {
        IHierarchy calcHier = hierarchies.get(calcHierIndex);
        IHierarchy targetGroupHier = targetGroup.getFirstSetHierarchy();
        boolean targetGroupIsOfCalcHier = calcHier.equals(targetGroupHier);
        for (int i = startIndex; i < hierarchies.size(); ++i) {
            IHierarchy currHierarchy = hierarchies.get(i);
            if (targetGroupHierInfo.projectsHierarchy(currHierarchy)) continue;
            AbstractMDXMember abstractMDXMember = null;
            abstractMDXMember = currHierarchy.equals(grandparentGroupHier) ? MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, currHierarchy) : MDXBuilder.buildMDXDefaultMemberExpr(nodeFactory, currHierarchy);
            MDXSet set = MDXBuilder.buildMDXSetExpr(nodeFactory, abstractMDXMember);
            CogMDXGroup currGroup = (CogMDXGroup)nodeFactory.createNode(1027);
            currGroup.addChild(set);
            if (targetGroup.getParent().getType() == 1039 && targetGroup.getParent().getPositionOfChild(targetGroup) == 0 && !targetGroupIsOfCalcHier && currHierarchy.equals(calcHier)) {
                currGroup.setPropertyValue(FIRST_CURRENT_MEMBER_OF_CALC, Boolean.TRUE);
            }
            StringBuilder propertyValue = null;
            if (currHierarchy.equals(grandparentGroupHier)) {
                propertyValue = new StringBuilder("currentMember");
                if (targetGroup.getParent().getType() == 1039 && !targetGroupIsOfCalcHier && currHierarchy.equals(calcHier)) {
                    currGroup.setPropertyValue(CURRENT_MEMBER_OF_CALC, Boolean.TRUE);
                }
            } else {
                propertyValue = new StringBuilder("defaultMember");
            }
            propertyValue.append("_");
            currGroup.setRefDataItemProperty(propertyValue.toString());
            if (startIndex <= calcHierIndex) {
                IXQEQueryNode parent = targetGroup.getParent();
                int position = parent.getPositionOfChild(targetGroup);
                parent.detachChild(targetGroup);
                parent.addChild(currGroup, position);
                currGroup.addChild(targetGroup);
                continue;
            }
            IXQEQueryNode nested = null;
            if (targetGroup.getNumberChildren() == 2) {
                nested = targetGroup.detachChild(1);
            }
            currGroup.insertParent(targetGroup);
            if (nested != null) {
                currGroup.addChild(nested);
            }
            targetGroup = currGroup;
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXHierInfo patternHierInfo;
        CogMDXGroup parentGroup;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(TRANSFORMATION_APPLIED) != null) {
            this.traceNodeCondition(false, "The transformation was applied already.", trace);
            return false;
        }
        MDXCalculatedMemberReference calculatedMemberReference = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition definition = calculatedMemberReference.getDefinition();
        IHierarchy calcHierarchy = definition.getHierarchy();
        if (calcHierarchy.isShell()) {
            this.traceNodeCondition(false, "The hierarchy for the target node has not been resolved.", trace);
            return false;
        }
        if (!calculatedMemberReference.getParent().getParent().isOfCategory(1027)) {
            this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return false;
        }
        CogMDXGroup targetGroup = parentGroup = (CogMDXGroup)calculatedMemberReference.getParent().getParent();
        do {
            if (targetGroup.getNumberChildren() == 1) {
                this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
                return false;
            }
            if (targetGroup.getNumberChildren() > 2) {
                this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
                return false;
            }
            if (targetGroup.getNumberChildren() != 2 || targetGroup.getChild(1).isOfCategory(1027)) continue;
            if (targetGroup.getChild(1).getType() != 1039) {
                this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
                return false;
            }
            try {
                ((MDXSet)targetGroup.getChild(1)).getHierarchyInfo();
                break;
            }
            catch (XQERuntimeException e) {
                if (e.getMessageKey().getName().equals(PLN_INVALID_HIERARCHIES)) {
                    boolean foundSpacer = false;
                    for (IXQEQueryNode nestedGroup : ((MDXSet)targetGroup.getChild(1)).getChildren()) {
                        if (!nestedGroup.isOfCategory(1027)) {
                            this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
                            return false;
                        }
                        CogMDXGroup aNestedGroup = (CogMDXGroup)nestedGroup;
                        try {
                            if (aNestedGroup.isSpacerReplacement() && aNestedGroup.getHierarchyInfo().getNumProjectedHierarchies() == 1 && aNestedGroup.getHierarchyInfo().getProjectedHierarchy(0).equals(calcHierarchy)) {
                                foundSpacer = true;
                                continue;
                            }
                            aNestedGroup.getHierarchyInfo();
                        }
                        catch (Throwable t) {
                            this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
                            return false;
                        }
                    }
                    if (foundSpacer) {
                        this.traceNodeCondition(true, "The transformation is required for a branch with an spacer.", trace);
                        return true;
                    }
                }
                this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
                return false;
            }
            catch (Throwable t) {
                this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
                return false;
            }
        } while ((targetGroup = (CogMDXGroup)targetGroup.getChild(1)).getNumberChildren() != 1);
        if (parentGroup.getParent().getType() == 1039) {
            for (IXQEQueryNode sibling : parentGroup.getParent().getChildren()) {
                if (sibling.isOfCategory(1027)) continue;
                this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
                return false;
            }
        }
        if ((patternHierInfo = NormalizedCalcGroup.findPaternHierInfo(calcHierarchy, parentGroup)) != null && patternHierInfo.getNumProjectedHierarchies() > 0) {
            this.traceNodeCondition(true, "The transformation is required.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The transformation is not required.", trace);
        return false;
    }
}

