/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ReplaceBoundMultiPartIdentifier
extends AbstractV5ToCogMDXTransformation {
    public ReplaceBoundMultiPartIdentifier() {
        this.mName = "Replace bound identifier with MDX expression.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        AbstractMDXNode newNode = null;
        try {
            newNode = ReplaceBoundMultiPartIdentifier.createAbstractMDXNodeFromMetadata(environment, metaData, mdxQuery);
            ReplaceBoundMultiPartIdentifier.throwOnFailure(metaData, newNode == null);
        }
        catch (XQERuntimeException e) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnableToReplaceBoundMultipartID, (Throwable)e, ((V5BoundModelIdentifier)node).getIdentifier());
        }
        node.getParent().exchangeChildNode(node, newNode, false);
        newNode.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
    }

    public static void throwOnFailure(IMetadata metaData, boolean condition) {
        if (condition) {
            String param = metaData.getClass().toString();
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnableToReplaceBoundObjectOfType, param);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AbstractMDXNode createAbstractMDXNodeFromMetadata(PlanningEnvironment environment, IMetadata metaData, MDXQuery mdxQuery) {
        IXQEQueryNode newNode = null;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (metaData.getObjectType() == MetadataType.MEMBER) {
            newNode = nodeFactory.createNode(1067);
            ((BaseMember)newNode).bind((IMember)metaData);
            return (AbstractMDXNode)newNode;
        }
        if (metaData.getObjectType() == MetadataType.LEVEL) {
            newNode = nodeFactory.createNode(1065);
            ((BaseLevel)newNode).bind((ILevel)metaData);
            return (AbstractMDXNode)newNode;
        }
        if (metaData.getObjectType() == MetadataType.HIERARCHY) {
            newNode = nodeFactory.createNode(1073);
            ((BaseHierarchy)newNode).bind((IHierarchy)metaData);
            return (AbstractMDXNode)newNode;
        }
        if (metaData.getObjectType() == MetadataType.DIMENSION) {
            if (((IDimension)metaData).isMeasuresDimension()) {
                newNode = nodeFactory.createNode(1073);
                ((BaseHierarchy)newNode).bind(((IDimension)metaData).getDefaultHierarchy());
                return (AbstractMDXNode)newNode;
            }
            String param = metaData.getV5UniqueName();
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedUseOfDimensionMetaObject, param, (IXQEQueryNode)mdxQuery);
            throw new XQERuntimeException(message);
        }
        if (metaData.getObjectType() != MetadataType.CALCULATION) return (AbstractMDXNode)newNode;
        String calcType = ((ICalculation)metaData).getCalcType();
        ReplaceBoundMultiPartIdentifier.throwOnFailure(metaData, !calcType.equals("namedSet") && !calcType.equals("macros"));
        return (AbstractMDXNode)newNode;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        boolean status = false;
        StringBuilder msgStr = new StringBuilder("The node is");
        String s1 = "a property or a cube namedSet.";
        if (metaData.getObjectType() == MetadataType.MEMBER || metaData.getObjectType() == MetadataType.LEVEL || metaData.getObjectType() == MetadataType.HIERARCHY || metaData.getObjectType() == MetadataType.DIMENSION) {
            status = true;
        }
        if (status) {
            msgStr.append(" ");
            msgStr.append("neither");
            msgStr.append(" ");
            msgStr.append(s1);
        } else {
            boolean unSupportedMetadata = true;
            if (metaData.getObjectType() == MetadataType.QUERY_ITEM) {
                this.traceNodeCondition(false, "QueryItem has not been updated with a level or measure", trace);
                return false;
            }
            if (metaData.getObjectType() == MetadataType.CALCULATION) {
                String calcType = ((ICalculation)metaData).getCalcType();
                if (calcType.equals("namedSet")) {
                    unSupportedMetadata = false;
                }
            } else if (metaData.getObjectType() == MetadataType.NAMED_SET) {
                this.traceNodeCondition(false, "NamedSets are processed by ReplaceNamedSetBoundMultiPartIdentifier.", trace);
                return false;
            }
            if (unSupportedMetadata) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedMetadataType, metaData.getObjectType().name(), metaData.getV5UniqueName());
            }
            msgStr.append(" ");
            msgStr.append("either");
            msgStr.append(" ");
            msgStr.append(s1);
        }
        this.traceNodeCondition(status, msgStr.toString(), trace);
        return status;
    }
}

