/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXGenericSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5GenericSetFunction;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.ArrayList;

public final class ConvertV5GenericToMDXGeneric
extends AbstractV5ToCogMDXTransformation {
    public static final String PROP_STRING_ERROR = "error";
    public static final String PROP_STRING_UDF = "udf.set.";

    public ConvertV5GenericToMDXGeneric() {
        this.mName = "Convert V5 Generic Set function to MDX Generic Set function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201140};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXGenericSet mdxGeneric = (MDXGenericSet)nodeFactory.createNode(1183);
        node.getParent().exchangeChildNode(node, mdxGeneric, true);
        String functionName = ((V5GenericSetFunction)node).getNativeName().toLowerCase();
        mdxGeneric.setNativeName(functionName);
        StringBuilder sb = new StringBuilder(PROP_STRING_UDF);
        sb.append(functionName);
        sb.append("[");
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        messageContext.add(node);
        for (int i = 0; i < mdxGeneric.getNumberChildren(); ++i) {
            IXQEQueryNode child = mdxGeneric.getChild(i);
            if (i > 0) {
                sb.append(",");
            }
            if (!child.isOfCategory(1022)) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedFunctionWithDimension, mdxGeneric.getNativeName(), messageContext);
                throw new XQEOlapUnsupportedQueryException(message);
            }
            sb.append("member");
        }
        sb.append("]");
        MDXQuery mdxQuery = (MDXQuery)mdxGeneric.getAncestorOfType(1002);
        String definition = mdxQuery.getCapabilities().getStringValue(sb.toString(), PROP_STRING_ERROR);
        if (definition.equals(PROP_STRING_ERROR)) {
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedFunctionWithDimension, mdxGeneric.getNativeName(), messageContext);
            throw new XQERuntimeException(message);
        }
        mdxGeneric.setDefinition(definition);
        sb = new StringBuilder(PROP_STRING_UDF);
        sb.append(functionName);
        sb.append(".relativeLevelOffset");
        Integer relativeLevelOffset = mdxQuery.getCapabilities().getIntegerValue(sb.toString());
        mdxGeneric.setRelativeLevelOffset(relativeLevelOffset);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "Node does not project any children.", trace);
            return false;
        }
        for (IXQEQueryNode child : node.getChildren()) {
            if (child.isOfCategory(1022)) continue;
            this.traceNodeCondition(false, "One of the arguments is not defining a member expression.", trace);
            return false;
        }
        this.traceNodeCondition(true, "V5GenericSet function can be converted to an MDXGenericSet expression.", trace);
        return true;
    }
}

