/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5SetToMDXSet
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5SetToMDXSet() {
        this.mName = "Convert the V5 Set function by the MDX Set function: { ... }.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201101};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxSiblingsNode = nodeFactory.createNode(1039);
        node.getParent().exchangeChildNode(node, mdxSiblingsNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5DataItem;
        XQETrace trace = environment.getTrace();
        V5SetFunction v5SetFunction = (V5SetFunction)node;
        V5DataItemRef v5DataItemRef = (V5DataItemRef)v5SetFunction.getAncestorOfType(101015);
        boolean isDetailFilter = false;
        isDetailFilter = v5SetFunction.getAncestorOfType(1010) != null;
        String dataItemName = null;
        if (!isDetailFilter && (v5DataItem = (V5DataItem)ASTUtil.getFirstNodeOfTypeFromAncestorQueryLineage(v5SetFunction, 101003)) != null) {
            dataItemName = v5DataItem.getNameProperty();
        }
        if (v5SetFunction.getNumberChildren() == 0) {
            if (dataItemName != null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidEmptySetExpressionInItem, dataItemName);
            }
            if (isDetailFilter) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidEmptySetExpressionInDetailFilter);
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidEmptySetExpression);
        }
        IXQEQueryNode[] children = v5SetFunction.getChildren();
        int shellCount = 0;
        for (IXQEQueryNode child : children) {
            if (!child.isOfCategory(1022)) {
                this.traceNodeCondition(false, "At least one of the arguments of the V5SetFunction is not defining a member expression.", trace);
                return false;
            }
            AbstractMDXMember currMember = (AbstractMDXMember)child;
            IHierarchy currHierarchy = currMember.getHierarchy();
            if (currHierarchy == null || !currHierarchy.isShell()) continue;
            ++shellCount;
        }
        if (shellCount > 0 && shellCount != children.length) {
            this.traceNodeCondition(false, "The V5SetFunction has many children but only some belong to a shell hierarchy.", trace);
            return false;
        }
        IHierarchy firstHierarchy = null;
        boolean status = true;
        for (IXQEQueryNode child : children) {
            AbstractMDXMember currMember = (AbstractMDXMember)child;
            IHierarchy currHierarchy = currMember.getHierarchy();
            if (firstHierarchy == null) {
                V5ValueSet valueSet;
                firstHierarchy = currHierarchy;
                if (v5DataItemRef == null || v5SetFunction.isCoercion() || !firstHierarchy.getDimension().isMeasuresDimension() || (valueSet = (V5ValueSet)v5SetFunction.getAncestorOfType(101057)).getRefDataItemProperty() != null) continue;
                IXQEQueryNode ancestor = v5SetFunction.getParent();
                while (ancestor != v5DataItemRef && (ancestor = ancestor.getParent()).isOfCategory(201122)) {
                }
                if (ancestor != v5DataItemRef) continue;
                if (dataItemName == null) {
                    dataItemName = v5DataItemRef.getDataItemRefProperty();
                }
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedMeasureSetExpressionInDetailColumn, dataItemName);
            }
            if (firstHierarchy.equals(currHierarchy)) continue;
            if (dataItemName != null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidMutiHierSetExpressionInItem, dataItemName);
            }
            if (isDetailFilter) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidMutiHierSetExpressionInDetailFilter);
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidMutiHierSetExpression);
        }
        if (status) {
            this.traceNodeCondition(status, "All children of the V5SetFunction are AbstractMDXMember nodes from the same hierarchy.", trace);
        } else {
            this.traceNodeCondition(status, "Not all children of the V5SetFunction are AbstractMDXMember nodes from the same hierarchy.", trace);
        }
        return status;
    }
}

