/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5UnionFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5UnionToMDXUnion
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5UnionToMDXUnion() {
        this.mName = "Convert the V5 Union function by the MDX Union function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201111};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxSetNode = nodeFactory.createNode(1039);
        node.getParent().exchangeChildNode(node, mdxSetNode, true);
        if (!((V5UnionFunction)node).getAll()) {
            IXQEQueryNode mdxDistinctNode = nodeFactory.createNode(1033);
            mdxSetNode.insertParent(mdxDistinctNode);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() != 2) {
            this.traceNodeCondition(status, "The V5 Union expression doesn't have a 2 arguments", trace);
            return status;
        }
        if (node.getChild(0).isOfCategory(1021) && node.getChild(1).isOfCategory(1021)) {
            MDXHierInfo firstExprHierInfo = ((AbstractMDXNode)node.getChild(0)).getHierarchyInfo();
            MDXHierInfo secondExprHierInfo = ((AbstractMDXNode)node.getChild(1)).getHierarchyInfo();
            if (firstExprHierInfo.getNumProjectedHierarchies() == 1 && secondExprHierInfo.getNumProjectedHierarchies() == 1 && firstExprHierInfo.compareProjectedHierarchies(secondExprHierInfo)) {
                status = true;
                this.traceNodeCondition(status, "The V5 Union has valid arguments.", trace);
                return status;
            }
            this.traceNodeCondition(status, "The both argument are not from the same single hierarchy or at least one argument involve more than one hierarchy.", trace);
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidUnionMembers);
        }
        this.traceNodeCondition(status, "One of the argument is not from a valid expression type.", trace);
        return status;
    }
}

