/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.rsapicompensation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public final class UpdateRSAPIDataTypeForCogMDXGroup
extends Transformation {
    public static final String RSAPI_DATA_TYPE_AND_USAGE_UPDATED = "rsapiDataTypeAndUsageUpdated";

    public UpdateRSAPIDataTypeForCogMDXGroup() {
        this.mName = "Update RSAPI expression usage to identifier when within a CogMDX Group.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup group = (CogMDXGroup)node;
        List<RSAPIDataItem> rsapiRefDataItems = group.getRSAPIDataItemList();
        for (RSAPIDataItem rsapiRefDataItem : rsapiRefDataItems) {
            if (rsapiRefDataItem.getUsage() != RSAPIUsage.FACT) continue;
            rsapiRefDataItem.setDataType(MemberType.MEMBERTYPE);
            rsapiRefDataItem.setUsage(RSAPIUsage.IDENTIFIER);
        }
        node.setPropertyValue(RSAPI_DATA_TYPE_AND_USAGE_UPDATED, Boolean.TRUE);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(RSAPI_DATA_TYPE_AND_USAGE_UPDATED) == Boolean.TRUE) {
            this.traceQueryCondition(false, "The RSAPI usage and data type does not need to be updated.", trace);
            return false;
        }
        CogMDXGroup group = (CogMDXGroup)node;
        List<RSAPIDataItem> rsapiRefDataItems = group.getRSAPIDataItemList();
        for (RSAPIDataItem rsapiRefDataItem : rsapiRefDataItems) {
            if (rsapiRefDataItem.getUsage() != RSAPIUsage.FACT) continue;
            this.traceQueryCondition(true, "The RSAPI usage and data type need to be updated.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The related RSAPI usage not set as fact.", trace);
        return false;
    }
}

