/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.rsapicompensation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.CogMDXReportSummaryExpr;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;

public final class UpdateRSAPIDataTypeForReportSummary
extends Transformation {
    public static final String REPORTSUMMARY_DATATYPE_UPDATED = "reportSummaryDataTypeUpdated";

    public UpdateRSAPIDataTypeForReportSummary() {
        this.mName = "Update the CogMDX Report Summary Expression RSAPI data type to fact/double when set to identifier.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{1028};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXReportSummaryExpr summaryExpr = (CogMDXReportSummaryExpr)node;
        CogMDXReportSummary summary = (CogMDXReportSummary)summaryExpr.getAncestorOfCategory(1080);
        RSAPIDataItem rsapiDataItem = summary.getRSAPIDataItem(summaryExpr);
        rsapiDataItem.setDataType(DoubleType.DOUBLETYPE);
        rsapiDataItem.setUsage(RSAPIUsage.FACT);
        node.setPropertyValue(REPORTSUMMARY_DATATYPE_UPDATED, "true");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(REPORTSUMMARY_DATATYPE_UPDATED) != null) {
            this.traceNodeCondition(false, "The transformation has already been applied.", trace);
            return false;
        }
        CogMDXReportSummaryExpr summaryExpr = (CogMDXReportSummaryExpr)node;
        CogMDXReportSummary summary = (CogMDXReportSummary)summaryExpr.getAncestorOfCategory(1080);
        RSAPIDataItem rsapiDataItem = summary.getRSAPIDataItem(summaryExpr);
        if (rsapiDataItem == null) {
            this.traceNodeCondition(false, "The node does not have a referenced RSAPIRefDataItem.", trace);
            return false;
        }
        if (rsapiDataItem.getDataType() != MemberType.MEMBERTYPE) {
            boolean measuresFound = false;
            for (IXQEQueryNode calcRef : node.getDescendantsOfType(1013, false)) {
                MDXCalculatedMemberReference mdxCalcMemberReference = (MDXCalculatedMemberReference)calcRef;
                AbstractMDXValueExpression calcExpression = (AbstractMDXValueExpression)mdxCalcMemberReference.getDefinition().getChild(0);
                MDXHierInfo hierInfo = calcExpression.getResolvedHierarchyInfo(calcExpression);
                if (hierInfo.projectsShellHierarchy()) {
                    mdxCalcMemberReference.throwInternalError("hierInfo.projectsShellHierarchy()");
                }
                if (!hierInfo.projectsMeasures()) continue;
                measuresFound = true;
                break;
            }
            if (measuresFound && rsapiDataItem.getUsage() == RSAPIUsage.IDENTIFIER) {
                this.traceNodeCondition(true, "The summary has explicit measure defined.", trace);
                return true;
            }
            this.traceNodeCondition(false, "The dataType of the referenced RSAPIRefDataItem is not MEMBER.", trace);
            return false;
        }
        IXQEQueryNode aggrExp = node.getChild(0);
        if (aggrExp.getType() == 1012) {
            V5RollupAggregateEnum rollupAggregate;
            if (aggrExp.getNumberChildren() == 2 && ((rollupAggregate = ((AbstractMDXNode)aggrExp.getChild(1)).getRollupAggregate()) == V5RollupAggregateEnum.COUNT || rollupAggregate == V5RollupAggregateEnum.COUNT_DISTINCT)) {
                this.traceQueryCondition(false, "The summary is about something that will resolve count(distinct).", trace);
                return false;
            }
        } else if (node.getChild(0).getType() == 1087) {
            this.traceQueryCondition(false, "The summary is about count.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The summary having member/identifer defined over RSAPI.", trace);
        return true;
    }
}

