/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.rsapicompensation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.Iterator;
import java.util.List;

public final class ValidateDetailFlagOnProjectedDataItem
extends Transformation {
    public ValidateDetailFlagOnProjectedDataItem() {
        this.mName = "Update RSAPI data type and for projected data item.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode tNode = node.getAncestorOfCategory(1139);
        CogMDXGroup detailGroup = (CogMDXGroup)tNode.getFirstChildByType(1027);
        String itemName = ((CogMDXGroup)node).getRefDataItemProperty();
        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_DetailFlagOnMeasureNotSupported, detailGroup.getRefDataItemProperty(), itemName);
    }

    public CogMDXGroup findGroupByName(String itemName, IXQEQueryNode node) {
        if (itemName == null || node.getParent() == null) {
            return null;
        }
        List<IXQEQueryNode> groups = node.getParent().getDescendantsOfTypeOrdered(1027, false);
        Iterator<IXQEQueryNode> groupIterator = groups.iterator();
        CogMDXGroup group = null;
        while (groupIterator.hasNext()) {
            IXQEQueryNode childNode = groupIterator.next();
            String name = ((CogMDXGroup)childNode).getRefDataItemProperty();
            if (name == null || !name.equals(itemName)) continue;
            group = (CogMDXGroup)childNode;
            break;
        }
        return group;
    }

    public boolean isDataItemFact(String itemName, CogMDXGroup detailGroup, CogMDXReportSummary summary) {
        boolean isUsageFact = false;
        CogMDXGroup group = this.findGroupByName(itemName, summary);
        if (group == null || detailGroup == null) {
            return false;
        }
        List<IXQEQueryNode> groups = detailGroup.getDescendantsOfTypeOrdered(1027, false);
        Iterator<IXQEQueryNode> groupIterator = groups.iterator();
        boolean isItemNestedUnder = false;
        while (groupIterator.hasNext()) {
            IXQEQueryNode childNode = groupIterator.next();
            String name = ((CogMDXGroup)childNode).getRefDataItemProperty();
            if (name == null || !name.equals(itemName)) continue;
            isItemNestedUnder = true;
            break;
        }
        if (!isItemNestedUnder) {
            return false;
        }
        RSAPIDataItem dataItem = group.getFirstRSAPIDataItem();
        if (dataItem == null) {
            return false;
        }
        if (dataItem.getUsage() == RSAPIUsage.FACT) {
            isUsageFact = true;
        }
        return isUsageFact;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup group = (CogMDXGroup)node;
        if (group.getDetailProperty() != null && group.getDetailProperty().equals("false") || group.getPropertyValue("detailIsAutomatic") != null && group.getIsDetailAutomatic()) {
            this.traceNodeCondition(false, "The detail attribute has not originally been set to true.", trace);
            return false;
        }
        CogMDXReportSummary summary = (CogMDXReportSummary)group.getAncestorOfCategory(1080);
        if (summary == null) {
            this.traceNodeCondition(false, "The target is not nested under the date item involved to summary.", trace);
            return false;
        }
        boolean isWithDetailSummary = false;
        AbstractMDXNumericValueFunction countFunc = null;
        MDXSummaryFunction summaryFunc = (MDXSummaryFunction)group.getAncestorOfCategory(1060);
        if (summaryFunc != null) {
            isWithDetailSummary = summaryFunc.isWithinDetailCalc();
        }
        if (!isWithDetailSummary) {
            countFunc = (MDXCount)group.getAncestorOfCategory(1087);
        }
        if (countFunc != null) {
            isWithDetailSummary = countFunc.isWithinDetailCalc();
        }
        if (!isWithDetailSummary) {
            this.traceNodeCondition(false, "The node is not a within detail summary.", trace);
            return false;
        }
        IXQEQueryNode tNode = node.getAncestorOfCategory(1139);
        if (tNode == null) {
            this.traceNodeCondition(false, "The node is not under a RemoveNonDetailSets node.", trace);
            return false;
        }
        CogMDXGroup detailGroup = (CogMDXGroup)tNode.getFirstChildByType(1027);
        String itemName = group.getRefDataItemProperty();
        boolean isFact = this.isDataItemFact(itemName, detailGroup, summary);
        if (!isFact) {
            this.traceNodeCondition(false, "The transformation only applicable for facts.", trace);
            return false;
        }
        this.traceNodeCondition(true, "We can't build the within detail aggregation, throw exception.", trace);
        return true;
    }
}

