/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;

public final class ConvertMultipleWithinSetOperandsToSingleSet
extends Transformation {
    public ConvertMultipleWithinSetOperandsToSingleSet() {
        this.mName = "Convert multiple 'within set' operands to a single set.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201039};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode[] children = node.getChildren();
        node.detachChildren();
        MDXCrossjoin crossjoin = MDXBuilder.buildMDXCrossjoinExpr(factory, children);
        node.addChild(crossjoin);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node;
        if (withinClause.getWithinClauseType() != 0) {
            this.traceNodeCondition(false, "The V5AggregateWithinClause is not within set.", trace);
            return false;
        }
        if (node.getNumberChildren() == 0) {
            StringBuilder param = new StringBuilder("data item = ");
            V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
            if (valueSet != null) {
                param.append(valueSet.getPropertyValue("refDataItem"));
            }
            node.throwInternalError(param.toString());
        } else if (node.getNumberChildren() == 1) {
            this.traceNodeCondition(false, "The V5AggregateWithinClause does not have more than 1 child node.", trace);
            return false;
        }
        IXQEQueryNode[] children = node.getChildren();
        ArrayList<IHierarchy> hierarchies = new ArrayList<IHierarchy>();
        for (int i = 0; i < children.length; ++i) {
            String param;
            IXQEQueryNode child = children[i];
            if (!child.isOfCategory(1021)) {
                this.traceNodeCondition(false, "One of the child nodes cannot be coerced to an AbstractMDXSet node.", trace);
                return false;
            }
            AbstractMDXNode set = (AbstractMDXNode)child;
            MDXHierInfo hierInfo = set.getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() == 0) {
                param = this.getDataItemName(node);
                node.throwInternalError(param);
            }
            if (hierInfo.getNumProjectedHierarchies() != 1) {
                param = this.getDataItemName(node);
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedMultiHierSetWithinClause, param);
            }
            if (hierarchies.contains(hierInfo.getProjectedHierarchy(0))) {
                this.traceNodeCondition(false, "The WITHIN SET clause has multiple set operands from the same hierarchy.", trace);
                return false;
            }
            hierarchies.add(hierInfo.getProjectedHierarchy(0));
        }
        this.traceNodeCondition(true, "The within set summary function can be replaced.", trace);
        return true;
    }

    private String getDataItemName(IXQEQueryNode node) {
        V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
        String param = null;
        if (valueSet != null) {
            param = (String)valueSet.getPropertyValue("refDataItem");
        }
        return param;
    }
}

