/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXIsEmpty;
import com.cognos.xqe.ast.olap.MDXNull;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class DropMeasureHierarchyFromReportSummaryContext
extends Transformation {
    public DropMeasureHierarchyFromReportSummaryContext() {
        this.mName = "Drop the measures hierarchy from the report summary context.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1027, 1026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode summaryExpr = node.getAncestorOfCategory(1060);
        if (summaryExpr == null) {
            summaryExpr = node.getAncestorOfCategory(1087);
        }
        IXQEQueryNode parent = node.getParent();
        node.detachChild(node.getChild(0));
        node.extract();
        if ((parent.getType() == 1139 || parent.getType() == 1039) && parent.getNumberChildren() == 0) {
            parent.extract();
        }
        XQENodeFactory factory = environment.getNodeFactory();
        if (summaryExpr.getNumberChildren() == 1) {
            if (summaryExpr.getType() == 1060) {
                MDXSummaryFunctionTypeEnum aggregate = ((MDXSummaryFunction)summaryExpr).getSummaryType();
                if (aggregate == MDXSummaryFunctionTypeEnum.AGGREGATE || aggregate == MDXSummaryFunctionTypeEnum.SUM || aggregate == MDXSummaryFunctionTypeEnum.MINIMUM || aggregate == MDXSummaryFunctionTypeEnum.MAXIMUM || aggregate == MDXSummaryFunctionTypeEnum.AVERAGE || aggregate == MDXSummaryFunctionTypeEnum.MEDIAN) {
                    MDXBuilder.coerceToNumericValueExpression(summaryExpr.getChild(0), factory);
                    summaryExpr.extract();
                } else if (aggregate == MDXSummaryFunctionTypeEnum.STANDARD_DEVIATION || aggregate == MDXSummaryFunctionTypeEnum.VARIANCE) {
                    summaryExpr.detachChild(0);
                    MDXNull nullExpr = (MDXNull)factory.createNode(1089);
                    summaryExpr.exchange(nullExpr);
                } else if (aggregate == MDXSummaryFunctionTypeEnum.STANDARD_DEVIATION_POPULATION || aggregate == MDXSummaryFunctionTypeEnum.VARIANCE_POPULATION) {
                    summaryExpr.detachChild(0);
                    MDXNumericConstant zero = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 0);
                    summaryExpr.exchange(zero);
                } else {
                    StringBuilder errMsg = new StringBuilder("DropMeasureHierarchyFromReportSummaryContext");
                    errMsg.append(" does not support MDX aggregation=\"");
                    errMsg.append(((MDXSummaryFunction)summaryExpr).getMDXSummaryString());
                    errMsg.append("\" ");
                    throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TemporarilyUnsupportedFeature, errMsg.toString());
                }
                return;
            }
            if (summaryExpr.getType() == 1012) {
                V5RollupAggregateEnum rollupAggregate = ((AbstractMDXValueExpression)summaryExpr.getChild(0)).getRollupAggregate();
                if (rollupAggregate == V5RollupAggregateEnum.COUNT) {
                    AbstractMDXValueExpression valExpr = (AbstractMDXValueExpression)summaryExpr.detachChild(0);
                    MDXIsEmpty mdxIsEmpty = MDXBuilder.buildMDXIsEmptyExpr(factory, valExpr);
                    MDXNumericConstant one = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 1);
                    MDXNumericConstant zero = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 0);
                    MDXNumericIIF mdxIf = MDXBuilder.buildMDXNumericIIFExpr(factory, mdxIsEmpty, zero, one);
                    summaryExpr.exchange(mdxIf);
                } else if (rollupAggregate == V5RollupAggregateEnum.TOTAL || rollupAggregate == V5RollupAggregateEnum.MAXIMUM || rollupAggregate == V5RollupAggregateEnum.MINIMUM || rollupAggregate == V5RollupAggregateEnum.NONE || rollupAggregate == V5RollupAggregateEnum.AVERAGE || rollupAggregate == V5RollupAggregateEnum.CALCULATED || rollupAggregate == V5RollupAggregateEnum.MEDIAN) {
                    MDXBuilder.coerceToNumericValueExpression(summaryExpr.getChild(0), factory);
                    summaryExpr.extract();
                } else if (rollupAggregate == V5RollupAggregateEnum.STANDARD_DEVIATION || rollupAggregate == V5RollupAggregateEnum.VARIANCE) {
                    summaryExpr.detachChild(0);
                    MDXNull nullExpr = (MDXNull)factory.createNode(1089);
                    summaryExpr.exchange(nullExpr);
                } else {
                    StringBuilder errMsg = new StringBuilder("DropMeasureHierarchyFromReportSummaryContext ");
                    errMsg.append("does not support rollupAggregate=\"");
                    errMsg.append(rollupAggregate.getName());
                    errMsg.append("\"");
                    throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TemporarilyUnsupportedFeature, errMsg.toString());
                }
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXValueExpression valueExpr;
        List<IXQEQueryNode> list;
        MDXCalculatedMemberReference calcRef;
        boolean targetNodeIsFirstSetUnderSummaryExpr;
        MDXCount mdxCount;
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getAncestorOfType(1080) == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of a CogMDXReportSummary node.", trace);
            return false;
        }
        IXQEQueryNode summaryExpr = node.getAncestorOfCategory(1060);
        if (summaryExpr == null && (mdxCount = (MDXCount)(summaryExpr = node.getAncestorOfCategory(1087))) != null && !mdxCount.includeEmpty()) {
            this.traceNodeCondition(false, "We need to keep the meaure to filter the non-empty tuple.", trace);
            return false;
        }
        if (summaryExpr == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of an MDXSummaryFunction node.", trace);
            return false;
        }
        AbstractMDXSet childSet = (AbstractMDXSet)node.getChild(0);
        MDXHierInfo mdxHierInfo = childSet.getHierarchyInfo();
        boolean bl = targetNodeIsFirstSetUnderSummaryExpr = node.getParent() == summaryExpr || node.getParent().isOfCategory(1078) && node.getParent().getParent() == summaryExpr;
        if (targetNodeIsFirstSetUnderSummaryExpr && !mdxHierInfo.projectsMeasures() && childSet.getType() == 1039 && childSet.getNumberChildren() == 1 && childSet.getChild(0).getType() == 1013 && (calcRef = (MDXCalculatedMemberReference)childSet.getChild(0)).getDefinition().getChild(0).isOfCategory(1061) && ((list = (valueExpr = (AbstractMDXValueExpression)calcRef.getDefinition().getChild(0)).getDescendantsOfCategory(1060, true)) == null || list.isEmpty()) && ((list = valueExpr.getDescendantsOfCategory(1013, true)) == null || list.isEmpty())) {
            mdxHierInfo = valueExpr.getResolvedHierarchyInfo(valueExpr);
        }
        if (!mdxHierInfo.projectsMeasures()) {
            this.traceNodeCondition(false, "First child of the target node does not project the measures dimension.", trace);
            return false;
        }
        if (summaryExpr.getType() == 1087 && summaryExpr.getNumberChildren() == 1 && summaryExpr.getChild(0) == node) {
            this.traceNodeCondition(false, "First child of the target node is the only chuild and is a measure.", trace);
            return false;
        }
        this.traceNodeCondition(true, "First child of the target node projects the measures dimension.", trace);
        return true;
    }
}

