/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.todeprecate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5ScalarFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5RoundWithSingleParameterToMDXRound
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5RoundWithSingleParameterToMDXRound() {
        this.mName = "Convert _round function with only one parameter.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201040};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (((RequestEnvironment)environment.getRequestEnvironment()).getMigrationBaseVersion() != RequestEnvironment.MigrationBaseVersionEnum.COMPATIBLE) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidArgumentCount, ((V5SimpleNode)node).getNativeName(), "2");
        }
        ResponseMessageFolder folder = environment.getResponseMessageFolder();
        folder.appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.DLT_RoundWithSingleParameter));
        node.throwInternalError("Fail migration.");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((V5ScalarFunction)node).getSubType() != 8) {
            this.traceNodeCondition(false, "The target scalar function should be round function.", trace);
            return false;
        }
        if (node.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The target round function should only have one parameter.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target node.", trace);
        return true;
    }
}

