/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Slicer;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.List;

public final class ValidateV5SlicerExpressions
extends Transformation {
    public ValidateV5SlicerExpressions() {
        this.mName = "Validate V5Slicer Expressions.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IHierarchy hierarchy;
            IXQEQueryNode exprNode = node.getChild(i);
            while (exprNode.getType() == 101003 || exprNode.getType() == 101004) {
                exprNode = exprNode.getChild(0);
            }
            MDXHierInfo hierInfo = ((V5QueryNode)exprNode).getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() > 1) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedQueryAmbiguousSlicerHierarchy, node);
                throw new XQEOlapUnsupportedQueryException(message);
            }
            if (hierInfo.getNumProjectedHierarchies() > 0 && (hierarchy = hierInfo.getProjectedHierarchy(0)).getDimension().isMeasuresDimension()) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedQuerySlicerOnMeasures, node);
                throw new XQEOlapUnsupportedQueryException(message);
            }
            V5ExpressionTypeEnum type = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(exprNode);
            if (type == V5ExpressionTypeEnum.VALUE) {
                IXQEQueryNode[] calcMembers;
                V5Query query = (V5Query)node.getAncestorOfType(101006);
                if (exprNode.isOfCategory(201122) && (calcMembers = exprNode.getDescendantsOfType(201085, false)).length > 0) {
                    XQEMessage xQEMessage = new XQEMessage(XQEMessageKeys.PLN_UnsupportedQuerySlicerOnCalculation4, ((V5Slicer)node).getOriginalExpression(), query.getV5QueryName(), exprNode);
                    throw new XQEOlapUnsupportedQueryException(xQEMessage);
                }
                IXQEQueryNode[] queryNodes = new IXQEQueryNode[]{exprNode};
                if (exprNode.isOfCategory(201121)) {
                    queryNodes = exprNode.getDescendantsOfType(201085, false);
                }
                for (IXQEQueryNode queryNode : queryNodes) {
                    if (queryNode.getType() != 201085 || queryNode.getNumberChildren() != 4) continue;
                    List<IXQEQueryNode> boundMultiPartIdentifiers = queryNode.getChild(0).getDescendantsOfCategory(201115, true);
                    IXQEQueryNode hierarchyChild = queryNode.getChild(3);
                    MDXHierInfo hierarchyChildHierInfo = ((V5BoundMultiPartIdentifier)hierarchyChild).getHierarchyInfo();
                    if (boundMultiPartIdentifiers.size() <= 0) continue;
                    for (IXQEQueryNode identifier : boundMultiPartIdentifiers) {
                        if (((V5BoundMultiPartIdentifier)identifier).isMeasure() || ((V5BoundMultiPartIdentifier)identifier).getHierarchyInfo().equals(hierarchyChildHierInfo)) continue;
                        XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedQuerySlicerOnCalculation1, ((V5Slicer)node).getOriginalExpression(), query.getV5QueryName(), ((V5BoundMultiPartIdentifier)identifier).getHierarchyInfo().getProjectedHierarchy(0).getV5UniqueName(), ((V5BoundMultiPartIdentifier)hierarchyChild).getNativeName(), exprNode);
                        throw new XQEOlapUnsupportedQueryException(message);
                    }
                }
                XQEMessage xQEMessage = new XQEMessage(XQEMessageKeys.PLN_UnsupportedQuerySlicerOnCalculation3, exprNode);
                throw new XQEOlapUnsupportedQueryException(xQEMessage);
            }
            if (type == V5ExpressionTypeEnum.MEMBER || type == V5ExpressionTypeEnum.SET) continue;
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedValueExpressionInSlicer, exprNode);
            throw new XQERuntimeException(message);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IHierarchy hierarchy;
            IXQEQueryNode exprNode = node.getChild(i);
            while (exprNode.getType() == 101003 || exprNode.getType() == 101004) {
                exprNode = exprNode.getChild(0);
            }
            MDXHierInfo hierInfo = ((V5QueryNode)exprNode).getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() > 1) {
                this.traceNodeCondition(true, "The first child of the V5Slicer node does not project a single hierarchy.", trace);
                return true;
            }
            V5ExpressionTypeEnum type = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(exprNode);
            if (type == V5ExpressionTypeEnum.VALUE) {
                IXQEQueryNode[] calcMembers;
                if (exprNode.isOfCategory(201122) && (calcMembers = exprNode.getDescendantsOfType(201085, false)).length > 0) {
                    this.traceNodeCondition(true, "Slicer on user defined calculations is not supported. It contains a set expression with one or more calculated members.", trace);
                    return true;
                }
                IXQEQueryNode[] queryNodes = new IXQEQueryNode[]{exprNode};
                if (exprNode.isOfCategory(201121)) {
                    queryNodes = exprNode.getDescendantsOfType(201085, false);
                }
                for (IXQEQueryNode queryNode : queryNodes) {
                    if (queryNode.getType() == 201085 && queryNode.getNumberChildren() == 4) {
                        List<IXQEQueryNode> boundMultiPartIdentifiers = queryNode.getChild(0).getDescendantsOfCategory(201115, true);
                        IXQEQueryNode hierarchyChild = queryNode.getChild(3);
                        MDXHierInfo hierarchyChildHierInfo = ((V5BoundMultiPartIdentifier)hierarchyChild).getHierarchyInfo();
                        if (boundMultiPartIdentifiers.size() <= 0) continue;
                        for (IXQEQueryNode identifier : boundMultiPartIdentifiers) {
                            if (((V5BoundMultiPartIdentifier)identifier).isMeasure() || ((V5BoundMultiPartIdentifier)identifier).getHierarchyInfo().equals(hierarchyChildHierInfo)) continue;
                            this.traceNodeCondition(true, "Slicer on user defined calculations is not supported. Any non-measure hierarchy references in the calculation must be to the same hierarchy as that of the Member function.", trace);
                            return true;
                        }
                        continue;
                    }
                    this.traceNodeCondition(true, "Slicer on user defined calculations is not supported. It contains a user defined calculation that is not wrapped in a Member function.", trace);
                    return true;
                }
            } else if (type != V5ExpressionTypeEnum.MEMBER && type != V5ExpressionTypeEnum.SET) {
                this.traceNodeCondition(true, "Slicers should be member or set.", trace);
                return true;
            }
            if (hierInfo.getNumProjectedHierarchies() <= 0 || !(hierarchy = hierInfo.getProjectedHierarchy(0)).getDimension().isMeasuresDimension()) continue;
            this.traceNodeCondition(true, "Slicers in the Measures dimension are not supported.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The V5Slicer expression is valid and supported.", trace);
        return false;
    }
}

