/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5MemberAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.CoerceBooleanExpressionToV5MemberExpression;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public class CoerceValueExpressionToV5MemberExpression
extends AbstractV5ToCogMDXTransformation {
    static final int[] MTYPES = new int[]{201014, 201017, 201018, 201023, 201026, 201032, 201089, 201092, 201040, 201113, 201031, 201034, 201041, 201127};

    public CoerceValueExpressionToV5MemberExpression() {
        this.mName = "Coerce value expression projected by a V5ValueSet to a MDXCalculatedMemberReference.";
        this.mPassNumbers = new int[]{4, 8};
        this.mTypes = MTYPES;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String modelObjName = this.getSimpleReferencedModelObjectName(node);
        if (modelObjName != null) {
            V5ToCogMDXUtilities.createV5MemberExpression(node, environment, "", modelObjName);
        } else {
            String caption = CoerceValueExpressionToV5MemberExpression.getCaption(node);
            V5MemberFunction memberFn = V5ToCogMDXUtilities.createV5MemberExpression(node, environment, caption, caption);
            memberFn.setIsQueryCalculation();
        }
    }

    protected String getSimpleReferencedModelObjectName(IXQEQueryNode node) {
        if (node.getParent().getType() == 101003) {
            V5DataItem v5DataItem = (V5DataItem)node.getParent();
            String modelObjName = (String)v5DataItem.getPropertyValue("refModelObjectName");
            String dataItemName = (String)v5DataItem.getPropertyValue("name");
            if (modelObjName != null && !modelObjName.equals(dataItemName)) {
                return modelObjName;
            }
        }
        return null;
    }

    public static String getCaption(IXQEQueryNode node) {
        if (node.getParent().getType() == 101003) {
            V5DataItem v5DataItem = (V5DataItem)node.getParent();
            return (String)v5DataItem.getPropertyValue("name");
        }
        return "V5C";
    }

    public static boolean willBeCoercedToMember(V5DataItem dataItem) {
        IXQEQueryNode v5Expr = V5ToCogMDXUtilities.getChildOverSet(dataItem.getChild(0), 201101);
        if (!v5Expr.isOfCategories(CoerceBooleanExpressionToV5MemberExpression.MTYPES) && !v5Expr.isOfCategories(MTYPES)) {
            return false;
        }
        return CoerceValueExpressionToV5MemberExpression.willBeCoercedToMember(v5Expr, null);
    }

    protected static boolean willBeCoercedToMember(IXQEQueryNode v5Expr, StringBuilder msgStr) {
        int size;
        V5AggregateFunction fn;
        if (v5Expr.getParent().getType() == 201085) {
            if (msgStr != null) {
                msgStr.append("The coercion has already been applyed to this node.");
            }
            return false;
        }
        if (v5Expr.getType() == 201032 && (fn = (V5MemberSummaryFunction)v5Expr).getNumberChildren() == 2 && fn.getChild(1).getType() == 201039 && ((V5AggregateWithinClause)fn.getChild(1)).getWithinClauseType() != 0) {
            if (msgStr != null) {
                msgStr.append("The node is an V5MemberSummaryFunction node ");
                msgStr.append("where the second child node is an V5AggregateWithinClause of ");
                msgStr.append("type V5AggregateWithinClause.SUBTYPE_WITHIN_DETAIL.");
            }
            return false;
        }
        if (v5Expr.getType() == 201034 && (size = (fn = (V5MemberAnalyticFunction)v5Expr).getNumberChildren()) > 0 && fn.getChild(size - 1).getType() == 201039 && ((V5AggregateWithinClause)fn.getChild(size - 1)).getWithinClauseType() != 0) {
            if (msgStr != null) {
                msgStr.append("The node is an V5MemberAnalyticFunction node");
                msgStr.append("where the second child node is not an V5AggregateWithinClause of ");
                msgStr.append("type V5AggregateWithinClause.SUBTYPE_WITHIN_SET.");
            }
            return false;
        }
        if (v5Expr.getType() == 201113 && v5Expr.getChild(0).getType() == 201110 && v5Expr.getChild(0).getNumberChildren() == 1) {
            IXQEQueryNode grandChildExpr = v5Expr.getChild(0).getChild(0);
            if (grandChildExpr.getType() == 201116) {
                IMetadata metaData = ((V5BoundModelIdentifier)grandChildExpr).getMetadata();
                if (metaData.getObjectType() == MetadataType.MEMBER) {
                    if (msgStr != null) {
                        msgStr.append("The node is a value function wrapping a member node.");
                    }
                    return false;
                }
            } else if (grandChildExpr.getType() == 201058) {
                if (msgStr != null) {
                    msgStr.append("The node is a value function wrapping a currentmeasure node.");
                }
                return false;
            }
        }
        if (v5Expr.getType() == 201127 && !((V5BoundParameter)v5Expr).isLiteral()) {
            if (msgStr != null) {
                msgStr.append("The node is not a literal parameter.");
            }
            return false;
        }
        if (v5Expr.getParent().getType() == 101065) {
            if (msgStr != null) {
                msgStr.append("The node is a child of the CogMDXDefaultMeasure node.");
            }
            return true;
        }
        if (v5Expr.getParent().getType() == 201032 && ((V5MemberSummaryFunction)v5Expr.getParent()).getSubType() == 2 && v5Expr.getParent().getPositionOfChild(v5Expr) == 0) {
            if (msgStr != null) {
                msgStr.append("The node is the first child of the V5MemberSummaryFunction count node.");
            }
            return true;
        }
        if (v5Expr.getParent().getType() == 201031 && v5Expr.getParent().getNumberChildren() == 2 && ((V5ValueSummaryFunction)v5Expr.getParent()).getSubType() == 2 && v5Expr.getParent().getPositionOfChild(v5Expr) == 0) {
            if (msgStr != null) {
                msgStr.append("The node is the first child of the V5ValueSummaryFunction count node with a break argument.");
            }
            return true;
        }
        if (v5Expr.getAncestorOfType(101049) == null) {
            if (msgStr != null) {
                msgStr.append("The node is not within a V5Edge.");
            }
            return false;
        }
        if (v5Expr.getParent().getType() != 101003) {
            if (msgStr != null) {
                msgStr.append("The node not a child of a V5DataItem.");
            }
            return false;
        }
        if (v5Expr.getParent().getAncestorOfCategory(201120) != null) {
            if (msgStr != null) {
                msgStr.append("The node is a grandchild of a V5 expression node.");
            }
            return false;
        }
        if (v5Expr.getFirstDescendantOfTypeOrdered(101003, false) != null) {
            if (msgStr != null) {
                msgStr.append("The data item contains unresolved V5DataItem nodes.");
            }
            return false;
        }
        if (v5Expr.getAncestorOfType(101056) != null) {
            if (msgStr != null) {
                msgStr.append("This node is a descentant of V5SortItem.");
            }
            return false;
        }
        if (msgStr != null) {
            msgStr.append("The V5DataItem expression must be coerced to a member function.");
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder errorMsg = null;
        if (trace.getTraceLevel() != 0) {
            errorMsg = new StringBuilder();
        }
        boolean status = CoerceValueExpressionToV5MemberExpression.willBeCoercedToMember(node, errorMsg);
        String traceMsg = null;
        if (errorMsg != null) {
            traceMsg = errorMsg.toString();
        }
        this.traceQueryCondition(status, traceMsg, trace);
        return status;
    }
}

