/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5OrderFunction;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public class ConvertV5OrderToV5ValueSetSort
extends AbstractV5ToCogMDXTransformation {
    public static final String STRING_NAME = "name";
    public static final String STRING_REFDATAITEM = "refDataItem";
    public static final String STRING_ASCENDING = "ascending";
    public static final String STRING_DESCENDING = "descending";

    public ConvertV5OrderToV5ValueSetSort() {
        this.mName = "Convert V5Order to Sorted V5ValueSet";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{201091};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5OrderFunction v5Order = (V5OrderFunction)node;
        Object dataItemStr = null;
        V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
        V5DataItemRef dataItemRef = (V5DataItemRef)node.getAncestorOfType(101015);
        if (dataItemRef != null) {
            dataItemStr = dataItemRef.getPropertyValue(STRING_REFDATAITEM);
        }
        if (dataItemStr == null) {
            dataItemStr = valueSet.getPropertyValue(STRING_REFDATAITEM);
        }
        V5SortItem sortItem = (V5SortItem)nodeFactory.createNode(101056);
        sortItem.setPropertyValue(STRING_REFDATAITEM, dataItemStr);
        if (node.getChild(0).getType() == 201086 && node.getChild(0).getChild(0).getType() == 201116) {
            V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)node.getChild(0).getChild(0);
            IMetadata metadata = identifier.getMetadata();
            sortItem.setPropertyValue("metadata", metadata);
        }
        String sortOrderStr = null;
        switch (v5Order.getOption()) {
            case 3: {
                sortOrderStr = STRING_ASCENDING;
                break;
            }
            case 4: {
                sortOrderStr = STRING_DESCENDING;
                break;
            }
            default: {
                node.throwInternalError("ConvertV5OrderToV5ValueSetSort");
            }
        }
        sortItem.setPropertyValue("sortOrder", sortOrderStr);
        sortItem.addChild(node.detachChild(1));
        V5GroupBody groupBody = (V5GroupBody)node.getAncestorOfType(101051);
        V5ToCogMDXUtilities.addV5SortItemToProperValueSet(valueSet, groupBody, sortItem, dataItemRef);
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MetadataType objType;
        IXQEQueryNode childNone;
        XQETrace trace = environment.getTrace();
        if (node.getParent().getAncestorOfType(101015) != null) {
            this.traceNodeCondition(false, "Ancestor is not DataItemRef.", trace);
            return false;
        }
        if (node.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "Wrong number of children.", trace);
            return false;
        }
        if (!V5ToCogMDXUtilities.isDirectProjectedNode(node)) {
            this.traceNodeCondition(false, "Node is not projected.", trace);
            return false;
        }
        if (!node.getChild(0).isOfCategory(201122)) {
            this.traceNodeCondition(false, "The order expression is not a level or heirarchy.", trace);
            return false;
        }
        V5OrderFunction v5Order = (V5OrderFunction)node;
        switch (v5Order.getOption()) {
            case 3: 
            case 4: {
                break;
            }
            default: {
                this.traceNodeCondition(false, "The order expression does not break the hierarchy order.", trace);
                return false;
            }
        }
        if (node.getChild(1).getType() == 201098 && (childNone = node.getChild(1).getChild(1)).getType() == 201059 && (childNone = childNone.getChild(0)).getType() == 201116 && (objType = ((V5BoundModelIdentifier)childNone).getMetadata().getObjectType()) == MetadataType.HIERARCHY) {
            IHierarchy sortHier;
            MDXHierInfo hierInfo = ((AbstractV5Set)node.getChild(0)).getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() != 1) {
                this.traceNodeCondition(false, "Cannot determine the hierarchy information.", trace);
                return false;
            }
            IHierarchy membersHier = hierInfo.getProjectedHierarchy(0);
            if (membersHier == (sortHier = ((V5BoundModelIdentifier)childNone).getHierarchy())) {
                this.traceNodeCondition(true, "Sort the members based on rolevalue.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "Cannot conver the V5 Order functon to equivalent V5 Group Sort.", trace);
        return false;
    }
}

