/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXSlicer;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Slicer;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import java.util.List;
import java.util.Set;

public final class CopyV5DetailFilterSlicerSummaryFilterToQuery
extends Transformation {
    public CopyV5DetailFilterSlicerSummaryFilterToQuery() {
        this.mName = "Copy V5 detail filters and Slicer within a CogMDX query as Cog MDX detail filter and Slicer.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] v5SummaryFilterNodes;
        IXQEQueryNode[] v5DetailFilters;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node;
        String refQuery = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        boolean isFiltering = false;
        for (IXQEQueryNode filter : v5DetailFilters = v5Query.getV5DetailFilters()) {
            String applyToDSQS;
            IMetadata metadata;
            String timing;
            V5DetailFilter v5DetailFilter = (V5DetailFilter)filter;
            if (!CopyV5DetailFilterSlicerSummaryFilterToQuery.isFilterApplicable(filter, mdxQuery)) continue;
            CogMDXDetailFilter cogMDXDetailFilter = (CogMDXDetailFilter)nodeFactory.createNode(1010, v5DetailFilter);
            node.addChild(cogMDXDetailFilter);
            isFiltering = true;
            cogMDXDetailFilter.addChild(nodeFactory.deepCopyNode(v5DetailFilter.getChild(0)), 0);
            boolean postAggr = v5DetailFilter.getPostAutoAggregation();
            cogMDXDetailFilter.setPostAutoAggregation(postAggr);
            Boolean isMasterDetailFilter = (Boolean)v5DetailFilter.getPropertyValue("masterDetailDFilter");
            if (isMasterDetailFilter != null) {
                cogMDXDetailFilter.setMasterDetailFilter(isMasterDetailFilter);
                cogMDXDetailFilter.setMasterDetailLinkDescription(v5DetailFilter.getMasterDetailLinkDescription());
            }
            if ((timing = (String)v5DetailFilter.getPropertyValue("timing")) != null) {
                cogMDXDetailFilter.setPropertyValue("timing", timing);
            }
            cogMDXDetailFilter.setPropertyValue("dmrSlicer", v5DetailFilter.getBooleanPropertyValue("dmrSlicer"));
            cogMDXDetailFilter.setPropertyValue("dmrSlicerSet", v5DetailFilter.getPropertyValue("dmrSlicerSet"));
            cogMDXDetailFilter.setPropertyValue("DMRSkipMembers", v5DetailFilter.getPropertyValue("DMRSkipMembers"));
            cogMDXDetailFilter.setOriginalExpression(v5DetailFilter.getOriginalExpression());
            this.removeOrderFunction(cogMDXDetailFilter);
            if (v5DetailFilter.getPropertyValue("showall") == Boolean.TRUE) {
                cogMDXDetailFilter.setPropertyValue("showall", Boolean.TRUE);
            }
            if ((metadata = v5DetailFilter.getIntroducingFilterOwner()) == null) {
                metadata = v5DetailFilter.getFilterOwner();
            }
            if (metadata != null && metadata instanceof IDimension) {
                IDimension dimension = (IDimension)metadata;
                cogMDXDetailFilter.setIsModelFilter();
                if (mdxQuery.isDMR()) {
                    CubeWrapper cube = DMRUtilities.findCubeWrapper(node, environment, true);
                    IMetadata metadataWrapper = cube.getWrapper(dimension);
                    if (metadataWrapper == null) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Failed to create metadata wrapper.");
                    }
                    dimension = (IDimension)metadataWrapper;
                }
                Set<IHierarchy> hierarchies = cogMDXDetailFilter.getReferencedDMRHierarchies();
                hierarchies.addAll(dimension.getHierarchies());
                cogMDXDetailFilter.setReferencedDMRHierarchies(hierarchies);
                cogMDXDetailFilter.setPropertyValue("usingDimensionalObjs", "true");
                cogMDXDetailFilter.setDimensionFromModel((IDimension)metadata);
                cogMDXDetailFilter.setFilterOwner(v5DetailFilter.getFilterOwner());
            } else {
                this.setSupportedByMDXIfCompleteTuple(v5Query, cogMDXDetailFilter);
            }
            CogMDXDetailFilter f = this.duplicateDMRDetailFilterOnHierarchy(v5Query, cogMDXDetailFilter, environment);
            Boolean b = (Boolean)v5DetailFilter.getPropertyValue("DMRMandatoryEmbeddedFilter");
            if (Boolean.TRUE == b) {
                f.setPropertyValue("DMRMandatoryEmbeddedFilter", Boolean.TRUE);
            }
            if ((applyToDSQS = (String)v5DetailFilter.getPropertyValue("applyToDSQS")) == null) continue;
            f.setPropertyValue("applyToDSQS", applyToDSQS);
        }
        IXQEQueryNode[] v5Slicers = v5Query.getV5Slicers();
        if (v5Slicers.length == 1) {
            V5Slicer v5Slicer = (V5Slicer)v5Slicers[0];
            v5Slicers = v5Slicers[0].getChildren();
            IXQEQueryNode filterExpression = null;
            for (int idx = v5Slicers.length - 1; idx >= 0; --idx) {
                filterExpression = nodeFactory.deepCopyNode(v5Slicers[idx]);
                CogMDXSlicer cogMDXSlicer = (CogMDXSlicer)nodeFactory.createNode(1009, v5Slicer);
                node.addChild(cogMDXSlicer);
                isFiltering = true;
                cogMDXSlicer.addChild(filterExpression, 0);
                cogMDXSlicer.setOriginalExpression(v5Slicer.getOriginalExpression());
            }
        }
        for (IXQEQueryNode filter : v5SummaryFilterNodes = v5Query.getV5SummaryFilters()) {
            IXQEQueryNode[] v5SummaryFilterLevelNodes;
            if (!CopyV5DetailFilterSlicerSummaryFilterToQuery.isFilterApplicable(filter, mdxQuery)) continue;
            V5SummaryFilter summaryFilter = (V5SummaryFilter)filter;
            CogMDXSummaryFilter cogMDXSummaryFilter = (CogMDXSummaryFilter)nodeFactory.createNode(1011, summaryFilter);
            cogMDXSummaryFilter.setPropertyValue("defaultScope", summaryFilter.getPropertyValue("defaultScope"));
            node.addChild(cogMDXSummaryFilter);
            cogMDXSummaryFilter.setOriginalExpression(summaryFilter.getOriginalExpression());
            cogMDXSummaryFilter.addChild(nodeFactory.deepCopyNode(summaryFilter.getChild(0)), 0);
            for (IXQEQueryNode level : v5SummaryFilterLevelNodes = summaryFilter.getChildrenOfType(101012)) {
                isFiltering = true;
                V5SummaryFilterLevel v5SummaryFilterLevel = (V5SummaryFilterLevel)level;
                cogMDXSummaryFilter.addScopedDateItemName(v5SummaryFilterLevel.getRefDataItem());
            }
        }
        if (isFiltering) {
            mdxQuery.setFiltering();
        }
    }

    protected CogMDXDetailFilter duplicateDMRDetailFilterOnHierarchy(V5Query v5Query, CogMDXDetailFilter cogMDXDetailFilter, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (!v5Query.isDMR()) {
            return cogMDXDetailFilter;
        }
        if (!cogMDXDetailFilter.containsHierarchyExpression() || cogMDXDetailFilter.shouldBePushedToMDXQuery()) {
            return cogMDXDetailFilter;
        }
        MDXQuery query = (MDXQuery)cogMDXDetailFilter.getAncestorOfType(1002);
        CogMDXDetailFilter filterForOLAP = cogMDXDetailFilter;
        CogMDXDetailFilter filterForRelational = (CogMDXDetailFilter)nodeFactory.deepCopyNode(cogMDXDetailFilter);
        query.addChild(filterForRelational);
        filterForOLAP.setSupportedBy(CogMDXDetailFilter.TypeOfQuery.MDXQUERY);
        filterForOLAP.setPropertyValue("isDMRDuplicateFilterOnHierarchy", Boolean.TRUE);
        filterForOLAP.setPropertyValue("AggregationRequired", Boolean.FALSE);
        filterForRelational.setSupportedBy(CogMDXDetailFilter.TypeOfQuery.RELATIONALQUERY);
        return cogMDXDetailFilter;
    }

    protected void setSupportedByMDXIfCompleteTuple(V5Query v5Query, CogMDXDetailFilter cogMDXDetailFilter) {
        IXQEQueryNode[] boundIds;
        if (!v5Query.isDMR()) {
            return;
        }
        if (cogMDXDetailFilter.getPropertyValue("dmrSlicer") == Boolean.TRUE) {
            return;
        }
        CogMDXDetailFilter.TypeOfQuery tp = cogMDXDetailFilter.getSupportedBy();
        if (tp != CogMDXDetailFilter.TypeOfQuery.NOT_DEFINED) {
            return;
        }
        IXQEQueryNode[] completeTuples = v5Query.getDescendantsOfType(201056, false);
        if (completeTuples.length == 0) {
            return;
        }
        if (cogMDXDetailFilter.pushDetailFiltertoMDXQuery()) {
            return;
        }
        IXQEQueryNode[] relWrappers = cogMDXDetailFilter.getDescendantsOfType(601024, false);
        if (relWrappers.length > 0) {
            return;
        }
        if (MixedDMRRelUtil.containRelationals(cogMDXDetailFilter, null)) {
            return;
        }
        if (cogMDXDetailFilter.getDescendantsOfType(201015, false).length > 0) {
            return;
        }
        boolean useDimensionalObj = false;
        for (IXQEQueryNode node : boundIds = cogMDXDetailFilter.getDescendantsOfType(201116, false)) {
            IMetadata metadata = ((V5BoundModelIdentifier)node).getMetadata();
            if (metadata == null || !metadata.isDMR()) {
                return;
            }
            useDimensionalObj = true;
            if (metadata.getObjectType() != MetadataType.MEMBER || !((IMember)metadata).isMeasure()) continue;
            return;
        }
        if (useDimensionalObj) {
            cogMDXDetailFilter.setSupportedBy(CogMDXDetailFilter.TypeOfQuery.MDXQUERY);
        }
    }

    private void removeOrderFunction(IXQEQueryNode node) {
        List<IXQEQueryNode> v5Nodes = node.getDescendantsOfCategory(201121, false);
        v5Nodes.addAll(node.getDescendantsOfCategory(201122, false));
        for (IXQEQueryNode v5AbsNode : v5Nodes) {
            int childCount;
            if (v5AbsNode.getType() != 201091) continue;
            for (int i = childCount = v5AbsNode.getNumberChildren(); i > 1; --i) {
                v5AbsNode.detachChild(i - 1);
            }
            v5AbsNode.extract();
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] cogMDXDetailFilterNodes = node.getChildrenOfType(1010);
        IXQEQueryNode[] cogMDXSlicerNodes = node.getChildrenOfType(1009);
        IXQEQueryNode[] cogMDXSummaryFilterNodes = node.getChildrenOfType(1011);
        if (cogMDXDetailFilterNodes.length == 0 && cogMDXSlicerNodes.length == 0 && cogMDXSummaryFilterNodes.length == 0) {
            this.traceQueryCondition(true, "The V5 slicer, detail filter, and summary filter nodes have not yet been moved to the target MDXQuery node.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The V5 slicer, detail filter, and summary filter nodes have already been moved to the target MDXQuery node.", trace);
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet v5QuerySet;
        V5Query v5Query;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        String refQuery = mdxQuery.getRefQueryProperty();
        if (refQuery != null && (v5Query = (v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002)).getV5Query(refQuery)) != null) {
            IXQEQueryNode[] v5DetailFilterNodes = v5Query.getV5DetailFilters();
            if (v5DetailFilterNodes != null && v5DetailFilterNodes.length > 0 && CopyV5DetailFilterSlicerSummaryFilterToQuery.hasApplicableFilters(v5DetailFilterNodes, mdxQuery)) {
                this.traceNodeCondition(true, "V5 Query contains at least one V5 detail filter.", trace);
                return true;
            }
            IXQEQueryNode[] v5SlicerNodes = v5Query.getV5Slicers();
            if (v5SlicerNodes != null && v5SlicerNodes.length > 0) {
                this.traceQueryCondition(true, "V5 Query contains at least one V5 slicer.", trace);
                return true;
            }
            IXQEQueryNode[] v5SummaryFilterNodes = v5Query.getV5SummaryFilters();
            if (v5SummaryFilterNodes != null && v5SummaryFilterNodes.length > 0 && CopyV5DetailFilterSlicerSummaryFilterToQuery.hasApplicableFilters(v5SummaryFilterNodes, mdxQuery)) {
                this.traceQueryCondition(true, "V5 Query contains at least one V5 summary filter.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "V5 Query has no V5 detailFilter, slicer, or summaryFilter nodes.", trace);
        return false;
    }

    private static boolean hasApplicableFilters(IXQEQueryNode[] v5FilterNodes, MDXQuery mdxQuery) {
        boolean hasFilters = false;
        for (IXQEQueryNode v5FilterNode : v5FilterNodes) {
            if (!CopyV5DetailFilterSlicerSummaryFilterToQuery.isFilterApplicable(v5FilterNode, mdxQuery)) continue;
            hasFilters = true;
            break;
        }
        return hasFilters;
    }

    private static boolean isFilterApplicable(IXQEQueryNode v5FilterNode, MDXQuery mdxQuery) {
        boolean result = false;
        switch (v5FilterNode.getType()) {
            case 101008: {
                V5DetailFilter detailFilter = (V5DetailFilter)v5FilterNode;
                String qrdName = (String)detailFilter.getPropertyValue("qrdName");
                if (qrdName != null && qrdName.compareTo(mdxQuery.getV5NameProperty()) != 0) {
                    return false;
                }
                String v5DetailFilterUsage = detailFilter.getUseProperty();
                if ("prohibited".compareTo(v5DetailFilterUsage) == 0) break;
                result = true;
                break;
            }
            case 101011: {
                V5SummaryFilter summaryFilter = (V5SummaryFilter)v5FilterNode;
                String v5SummaryFilterUsage = summaryFilter.getUseProperty();
                if ("prohibited".compareTo(v5SummaryFilterUsage) == 0) break;
                result = true;
                break;
            }
        }
        return result;
    }
}

