/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class DisableDMRAggregateSummaryOptimization
extends Transformation {
    public DisableDMRAggregateSummaryOptimization() {
        this.mName = "Disable DMRSummaryQueryOptimization through MDX Query based on dmr.properties.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        DisableDMRAggregateSummaryOptimization.setDMRAggregateSummaryOptimizationLevel(mdxQuery);
    }

    public static void setDMRAggregateSummaryOptimizationLevel(MDXQuery mdxQuery) {
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        int dmrSummaryQueryOptimizationLevel = capabilities.getIntegerValue("dmrSummaryQueryOptimizationLevel", 2);
        mdxQuery.setDMRAggregateSummaryOptimizationLevel(dmrSummaryQueryOptimizationLevel);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getPropertyValue("DMRAggSummaryOptimLevel") != null) {
            this.traceQueryCondition(false, "DMR Aggregate Summary Optimization level is already set.", trace);
            return false;
        }
        this.traceQueryCondition(true, "DMR Aggregate Summary Optimization level needs to be set.", trace);
        return true;
    }
}

