/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.binding.ReplaceProjectedPropertyBoundMultiPartIdentifier;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class IdentifyHeaderFooterCountsOnProjectedNonMeasureColumns
extends AbstractV5ToCogMDXTransformation {
    public static final String PROP_COUNT_ON_PROJECTED_NON_MEASURE_COLUMN = "CountOnProjectedNonMeasureColumn";

    public IdentifyHeaderFooterCountsOnProjectedNonMeasureColumns() {
        this.mName = "Identify Counts On Projected Non-measure Columns";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101015};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String name = this.getProjectedItemName(node);
        node.setPropertyValue(PROP_COUNT_ON_PROJECTED_NON_MEASURE_COLUMN, name);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_COUNT_ON_PROJECTED_NON_MEASURE_COLUMN) != null) {
            this.traceQueryCondition(false, "The transformation has already been applied to the target node.", trace);
            return false;
        }
        IXQEQueryNode v5GroupHeaderFooter = node.getParent();
        if (v5GroupHeaderFooter == null || v5GroupHeaderFooter.getType() != 101053 && v5GroupHeaderFooter.getType() != 101052) {
            this.traceQueryCondition(false, "The V5DataItemRef node is not a child of an V5GroupHeader or V5GroupFooter node.", trace);
            return false;
        }
        IXQEQueryNode child = V5ToCogMDXUtilities.getChildOverSet(node.getChild(0), 201101);
        if (node.getNumberChildren() == 0 || !child.isOfCategory(201120)) {
            this.traceQueryCondition(false, "The V5DataItemRef expression has not yet been fully resolved.", trace);
            return false;
        }
        if (((V5SimpleNode)child).getRollupAggregate() != V5RollupAggregateEnum.COUNT && ((V5SimpleNode)child).getRollupAggregate() != V5RollupAggregateEnum.COUNT_DISTINCT) {
            this.traceQueryCondition(false, "The rollupAggregate property on the V5DataItem expression is not V5RollupAggregateEnum.COUNT or V5RollupAggregateEnum.COUNT_DISTINCT.", trace);
            return false;
        }
        if (node.getDescendantsOfType(101003, false).length > 0) {
            this.traceQueryCondition(false, "The V5DataItemRef expression has unresolved V5DataItem nodes.", trace);
            return false;
        }
        IXQEQueryNode v5ValueSet = v5GroupHeaderFooter.getParent();
        if (v5ValueSet == null || v5ValueSet.getType() != 101057) {
            this.traceQueryCondition(false, "The V5DataItemRef node is not a descendant of an V5ValueSet node.", trace);
            return false;
        }
        IXQEQueryNode v5EdgeGroup = v5ValueSet.getAncestorOfType(101050);
        if (v5EdgeGroup == null) {
            this.traceQueryCondition(false, "The V5DataItemRef node is not a descendant of an V5EdgeGroup node.", trace);
            return false;
        }
        boolean isMeasure = false;
        if (child.getType() == 201116) {
            V5BoundModelIdentifier boundIdentifier = (V5BoundModelIdentifier)node.getChild(0);
            isMeasure = boundIdentifier.isMeasure();
            if (!isMeasure && ReplaceProjectedPropertyBoundMultiPartIdentifier.isValidPropertyQueryItem(boundIdentifier.getMetadata())) {
                this.traceQueryCondition(false, "The refDataItem expression is a property.", trace);
                return false;
            }
        } else if (child.getType() == 201085) {
            isMeasure = true;
            V5MemberFunction v5MembFn = (V5MemberFunction)child;
            if (v5MembFn.getNumberChildren() == 4 && v5MembFn.getHierarchyInfo().getNumberOfNonMeasureHierarchiesProjected() > 0) {
                isMeasure = false;
            }
        } else if (child.isOfCategory(201125)) {
            isMeasure = true;
        }
        if (isMeasure) {
            this.traceQueryCondition(false, "The refDataItem expression matches a projected measure expression", trace);
            return false;
        }
        if (this.getProjectedItemName(node) == null) {
            this.traceQueryCondition(false, "The V5DataItem is not projected.", trace);
            return false;
        }
        return true;
    }

    public String getProjectedItemName(IXQEQueryNode node) {
        boolean isProjected = false;
        IXQEQueryNode v5GroupHeaderFooter = node.getParent();
        IXQEQueryNode v5ValueSet = v5GroupHeaderFooter.getParent();
        IXQEQueryNode v5EdgeGroup = v5ValueSet.getAncestorOfType(101050);
        HashMap<Object, IXQEQueryNode> refDataItemName2ProjExprMap = new HashMap<Object, IXQEQueryNode>();
        IXQEQueryNode[] v5ValueSetNodes = v5EdgeGroup.getDescendantsOfType(101057, false);
        for (int i = 0; i < v5ValueSetNodes.length; ++i) {
            if (v5ValueSetNodes[i].getPropertyValue("refDataItem") != null) {
                if (v5ValueSetNodes[i].getNumberChildren() <= 0 || !v5ValueSetNodes[i].getChild(0).isOfCategory(201120) || v5ValueSetNodes[i].getChild(0).getFirstDescendantOfTypeOrdered(101003, false) != null) continue;
                refDataItemName2ProjExprMap.put(v5ValueSetNodes[i].getPropertyValue("refDataItem"), v5ValueSetNodes[i].getChild(0));
                continue;
            }
            IXQEQueryNode[] groupBodyNodes = v5ValueSetNodes[i].getDescendantsOfType(101051, false);
            if (groupBodyNodes.length <= 0) continue;
            IXQEQueryNode[] gbDataItemRefs = groupBodyNodes[0].getDescendantsOfType(101015, false);
            for (int j = 0; j < gbDataItemRefs.length; ++j) {
                if (gbDataItemRefs[j].getNumberChildren() <= 0 || !gbDataItemRefs[j].getChild(0).isOfCategory(201120) || gbDataItemRefs[j].getFirstDescendantOfTypeOrdered(101003, false) != null) continue;
                refDataItemName2ProjExprMap.put(gbDataItemRefs[j].getPropertyValue("refDataItem"), gbDataItemRefs[j].getChild(0));
            }
        }
        Set projRefDataItemNames = refDataItemName2ProjExprMap.keySet();
        Iterator it = projRefDataItemNames.iterator();
        String name = null;
        while (it.hasNext()) {
            name = (String)it.next();
            IXQEQueryNode projExpr = (IXQEQueryNode)refDataItemName2ProjExprMap.get(name);
            if (!node.getChild(0).isSameExpression(projExpr, false)) continue;
            isProjected = true;
            break;
        }
        if (!isProjected) {
            name = null;
        }
        return name;
    }
}

