/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ResultCellUpdate;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.utils.V5NodeFormatResolver;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateRule;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InsertV5ResultCellUpdateDecoration
extends AbstractV5ToCogMDXTransformation {
    public InsertV5ResultCellUpdateDecoration() {
        this.mName = "Insert V5 result cell update decoration to apply format.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101049};
    }

    private V5DataItem findV5DataItemOnEdge(IXQEQueryNode node, RSAPIDataItem rsapiDataItem) {
        if (node == null || rsapiDataItem == null) {
            return null;
        }
        V5Edge edge = (V5Edge)node;
        IXQEQueryNode[] v5DataItems = edge.getDescendantsOfType(101003, true);
        for (int j = 0; j < v5DataItems.length; ++j) {
            V5DataItem v5DataItem = (V5DataItem)v5DataItems[j];
            RSAPIDataItem refDataItem = (RSAPIDataItem)v5DataItem.getParent().getPropertyValue("RSAPIRefDataItem");
            if (refDataItem != rsapiDataItem) continue;
            return (V5DataItem)v5DataItems[j];
        }
        return null;
    }

    private boolean applyDataItemFormatToV5Result(IXQEQueryNode node, RSAPIDataset rsapiDataset, IXQENodeFactory nodeFactory, RSAPIEdgeRowset rsapiRowset, RSAPIDataItem rsapiDataItem, int dataItemId) {
        V5DataItem v5DataItem = this.findV5DataItemOnEdge(node, rsapiDataItem);
        boolean status = false;
        if (v5DataItem != null) {
            List<IXQEQueryNode> dataItems = v5DataItem.getDescendantsOfTypeOrdered(101003, true);
            if (!v5DataItem.getDescendantsOfTypeOrdered(201119, false).isEmpty()) {
                for (IXQEQueryNode dataItem : dataItems) {
                    V5MemberFunction v5MemberFunction;
                    if (dataItem.getPropertyValue("customFormat") == null) continue;
                    String v5Name = null;
                    IXQEQueryNode memberFunction = dataItem.getChild(0);
                    if (memberFunction.getType() != 201085 && memberFunction.getType() == 201113 && memberFunction.getChild(0).getType() == 201110 && memberFunction.getChild(0).getNumberChildren() == 1) {
                        memberFunction = memberFunction.getChild(0).getChild(0);
                    }
                    if (memberFunction.getType() == 201085 && (v5MemberFunction = (V5MemberFunction)memberFunction).getNumberChildren() > 1) {
                        Value name = ((V5LiteralValue)v5MemberFunction.getChild(1)).getValue();
                        v5Name = name.getString();
                    }
                    if (v5Name == null || v5Name.length() == 0) {
                        node.throwInternalError("Unexpected custom format on a dataItem with no explicit MUN.");
                    }
                    if (v5Name == null) continue;
                    if (dataItem == v5DataItem) {
                        node.throwInternalError("Unexpected direct custom format on a dataItem with _addMemberToSet descendants.");
                    }
                    this.applyOneDataItemFormatToV5Result(node, rsapiDataset, nodeFactory, rsapiRowset, dataItemId, (V5DataItem)dataItem, v5Name);
                }
            }
            status = this.applyOneDataItemFormatToV5Result(node, rsapiDataset, nodeFactory, rsapiRowset, dataItemId, v5DataItem, null);
        }
        return status;
    }

    private boolean applyOneDataItemFormatToV5Result(IXQEQueryNode node, RSAPIDataset rsapiDataset, IXQENodeFactory nodeFactory, RSAPIEdgeRowset rsapiRowset, int dataItemId, V5DataItem v5DataItem, String v5Name) {
        String format = (String)v5DataItem.getPropertyValue("customFormat");
        if (format == null) {
            return false;
        }
        Integer solveOrder = v5DataItem.getSolveOrderProperty();
        RSAPIEdge edge = (RSAPIEdge)node.getPropertyValue("RSAPIEdge");
        int edgeOrdinal = edge.getPositionalOrdinal();
        XV5CellSpec primaryCellSpec = new XV5CellSpec(edgeOrdinal, rsapiRowset.getRowsetId(), dataItemId, v5Name);
        ArrayList<XV5CellSpec> intersectingCellSpecs = new ArrayList<XV5CellSpec>();
        boolean bCreateRule = true;
        if (solveOrder != null) {
            bCreateRule = this.buildIntersectingCellSpecs(node, v5DataItem, intersectingCellSpecs);
        }
        if (bCreateRule) {
            this.addXV5CellUpdateRule(rsapiDataset, nodeFactory, primaryCellSpec, intersectingCellSpecs, format);
            return true;
        }
        return false;
    }

    private boolean buildIntersectingCellSpecs(IXQEQueryNode node, V5DataItem v5DataItem, List<XV5CellSpec> intersectingCellSpecs) {
        RSAPIEdge edge = (RSAPIEdge)node.getPropertyValue("RSAPIEdge");
        RSAPIEdge[] allEdges = edge.getDataset().getEdges();
        for (int i = 0; i < allEdges.length; ++i) {
            int j;
            if (allEdges[i] == edge || allEdges[i].isEmpty()) continue;
            V5Edge v5Edge = null;
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            IXQEQueryNode[] v5Edges = mdxQuery.getDescendantsOfType(101049, true);
            for (int edgeIndex = 0; edgeIndex < v5Edges.length; ++edgeIndex) {
                RSAPIEdge rsapiEdge = (RSAPIEdge)v5Edges[edgeIndex].getPropertyValue("RSAPIEdge");
                if (rsapiEdge != allEdges[i]) continue;
                v5Edge = (V5Edge)v5Edges[edgeIndex];
                break;
            }
            String v5Name = null;
            RSAPIEdgeRowset[] rowsets = allEdges[i].getRowsets();
            ArrayList<XV5CellSpec> cellSpecsOnEdge = new ArrayList<XV5CellSpec>();
            HashSet<RSAPIEdgeRowset> higherSolveOrderRowsets = new HashSet<RSAPIEdgeRowset>();
            HashSet<RSAPIEdgeRowset> reportSummaryRowsets = new HashSet<RSAPIEdgeRowset>();
            for (j = 0; j < rowsets.length; ++j) {
                List<IXQEQueryNode> reportSummaries;
                String format;
                if (higherSolveOrderRowsets.contains(rowsets[j]) || rowsets[j].getRefDataItem() == null) continue;
                V5DataItem intersectingV5DataItem = this.findV5DataItemOnEdge(v5Edge, rowsets[j].getRefDataItem());
                if (!intersectingV5DataItem.getDescendantsOfTypeOrdered(201119, false).isEmpty()) {
                    List<IXQEQueryNode> dataItems = intersectingV5DataItem.getDescendantsOfCategory(101003, true);
                    for (IXQEQueryNode dataItem : dataItems) {
                        V5MemberFunction v5MemberFunction;
                        if ((V5DataItem)dataItem == v5DataItem || dataItem.getChild(0).getType() != 201085 || (v5MemberFunction = (V5MemberFunction)dataItem.getChild(0)).getNumberChildren() <= 1 || !this.compareSolveOrder((V5DataItem)dataItem, allEdges[i], v5DataItem, edge)) continue;
                        V5ToCogMDXUtilities.collectSubTree(rowsets[j], higherSolveOrderRowsets);
                        Value name = ((V5LiteralValue)v5MemberFunction.getChild(1)).getValue();
                        if (v5Name == null) {
                            v5Name = "Exclude_";
                        }
                        v5Name = v5Name + name.getString() + "_";
                    }
                    continue;
                }
                if (this.compareSolveOrder(intersectingV5DataItem, allEdges[i], v5DataItem, edge) && ((format = (String)intersectingV5DataItem.getPropertyValue("customFormat")) != null || edge.getPositionalOrdinal() != 0)) {
                    V5ToCogMDXUtilities.collectSubTree(rowsets[j], higherSolveOrderRowsets);
                }
                boolean isNonCountSummary = !(reportSummaries = intersectingV5DataItem.getDescendantsOfTypeOrdered(201032, false)).isEmpty();
                for (IXQEQueryNode aSummary : reportSummaries) {
                    if (((V5MemberSummaryFunction)aSummary).getSubType() != 2) continue;
                    isNonCountSummary = false;
                    break;
                }
                if (!isNonCountSummary) continue;
                reportSummaryRowsets.add(rowsets[j]);
            }
            if (higherSolveOrderRowsets.size() == rowsets.length && v5Name == null && reportSummaryRowsets.isEmpty()) {
                return false;
            }
            if (higherSolveOrderRowsets.isEmpty()) continue;
            for (j = 0; j < rowsets.length; ++j) {
                if (higherSolveOrderRowsets.contains(rowsets[j]) && !reportSummaryRowsets.contains(rowsets[j])) {
                    if (v5Name == null) continue;
                    cellSpecsOnEdge.add(new XV5CellSpec(allEdges[i].getPositionalOrdinal(), rowsets[j].getRowsetId(), -1, v5Name));
                    continue;
                }
                cellSpecsOnEdge.add(new XV5CellSpec(allEdges[i].getPositionalOrdinal(), rowsets[j].getRowsetId(), -1, null));
            }
            if (cellSpecsOnEdge.isEmpty()) continue;
            intersectingCellSpecs.addAll(cellSpecsOnEdge);
        }
        return true;
    }

    private boolean compareSolveOrder(V5DataItem v5DataItem1, RSAPIEdge edge1, V5DataItem v5DataItem2, RSAPIEdge edge2) {
        if (v5DataItem1 == null || v5DataItem2 == null) {
            return false;
        }
        Integer solveOrder1 = v5DataItem1.getSolveOrderProperty();
        Integer solveOrder2 = v5DataItem2.getSolveOrderProperty();
        if (solveOrder2 == null) {
            return true;
        }
        if (solveOrder1 == null) {
            return false;
        }
        if (solveOrder1.intValue() == solveOrder2.intValue()) {
            boolean bIsCalc2;
            boolean bIsCalc1 = v5DataItem1.getChildrenOfCategory(201125).length > 0 || v5DataItem1.getChildrenOfCategory(201085).length > 0;
            boolean bl = bIsCalc2 = v5DataItem2.getChildrenOfCategory(201125).length > 0 || v5DataItem2.getChildrenOfCategory(201085).length > 0;
            if (bIsCalc1 == bIsCalc2) {
                return edge1.getPositionalOrdinal() > edge2.getPositionalOrdinal();
            }
            return bIsCalc1;
        }
        return solveOrder1 > solveOrder2;
    }

    private void addXV5CellUpdateRule(RSAPIDataset rsapiDataset, IXQENodeFactory nodeFactory, XV5CellSpec primaryCellSpec, List<XV5CellSpec> intersectingCellSpecs, String format) {
        final String formatString = format;
        AbstractXV5CellUpdateRule cellUpdateRule = null;
        cellUpdateRule = rsapiDataset.isCrossTabReport() ? new AbstractXV5CellUpdateRule(primaryCellSpec){

            @Override
            public boolean apply(ICell cell) {
                FormatService service = FormatService.getInstance();
                if (null != service) {
                    String currentFormat;
                    Value value = (Value)cell.getValue();
                    if (value instanceof NumericValue && V5NodeFormatResolver.isIntegerFormat(currentFormat = service.retrieveFormatString(value.getFormatId())) && V5NodeFormatResolver.isIntegerFormat(formatString)) {
                        return true;
                    }
                    value = (Value)value.copy();
                    cell.setValue(value);
                    value.setFormatId(service.registerV5Format(formatString, null));
                }
                return true;
            }
        } : new AbstractXV5CellUpdateRule(primaryCellSpec){

            @Override
            public boolean apply(IValue column) {
                if (!(column instanceof ContextValue)) {
                    return false;
                }
                FormatService service = FormatService.getInstance();
                if (null != service) {
                    String currentFormat;
                    Value value = (Value)((ContextValue)column).getValue();
                    if (value instanceof NumericValue && V5NodeFormatResolver.isIntegerFormat(currentFormat = service.retrieveFormatString(value.getFormatId())) && V5NodeFormatResolver.isIntegerFormat(formatString)) {
                        return true;
                    }
                    value = (Value)value.copy();
                    ((ContextValue)column).setValue(value);
                    value.setFormatId(service.registerV5Format(formatString, null));
                }
                return true;
            }
        };
        cellUpdateRule.addIntersectingCellSpec(intersectingCellSpecs);
        V5ResultCellUpdate cellUpdateNode = null;
        int descendantType = 601014;
        IXQEQueryNode[] nodeCellUpdate = rsapiDataset.getDescendantsOfType(descendantType, false);
        if (nodeCellUpdate.length == 0) {
            cellUpdateNode = (V5ResultCellUpdate)nodeFactory.createNode(601014);
            rsapiDataset.getChild(0).insertParent(cellUpdateNode);
        } else {
            cellUpdateNode = (V5ResultCellUpdate)nodeCellUpdate[0];
        }
        cellUpdateNode.addCellUpdateRule(cellUpdateRule);
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItems;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        RSAPIEdge edge = (RSAPIEdge)node.getPropertyValue("RSAPIEdge");
        RSAPIEdgeRowset[] rowsets = edge.getRowsets();
        for (int i = 0; i < rowsets.length; ++i) {
            RSAPIDataItem refDataItem = rowsets[i].getRefDataItem();
            if (refDataItem != null) {
                this.applyDataItemFormatToV5Result(node, rsapiDataset, nodeFactory, rowsets[i], refDataItem, -1);
            }
            RSAPIDataItem[] dataItems2 = rowsets[i].getDataItems();
            for (int j = 0; j < dataItems2.length; ++j) {
                this.applyDataItemFormatToV5Result(node, rsapiDataset, nodeFactory, rowsets[i], dataItems2[j], j);
            }
        }
        for (IXQEQueryNode dataItem : dataItems = node.getDescendantsOfType(101003, true)) {
            dataItem.removeProperty("customFormat");
            dataItem.removeProperty("customFormatSolveOrder");
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode dataset;
        V5QuerySet v5QuerySet;
        boolean ret = super.passesQueryCondition(node, environment);
        if (ret && (v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002)) != null && v5QuerySet.isMultidimensionalSubquery()) {
            ret = false;
        }
        if (ret && (dataset = node.getAncestorOfType(401005)).getParent().getType() != 101002) {
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] dataItems = node.getDescendantsOfType(101003, true);
        if (dataItems.length == 0) {
            this.traceNodeCondition(false, "The V5Edge has not DataItem descendants.", trace);
            return false;
        }
        boolean status = false;
        for (int i = 0; i < dataItems.length; ++i) {
            if (dataItems[i].getPropertyValue("customFormat") == null) continue;
            status = true;
            break;
        }
        if (!status) {
            this.traceNodeCondition(false, "Only default is used, therefor no need to resolve format.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The V5Edge projects DataItem that has custom format need to be applied to V5 result.", trace);
        return true;
    }
}

