/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.CoerceValueExpressionToV5MemberExpression;

public final class PropagateDataItemSolveOrders
extends AbstractV5ToCogMDXTransformation {
    public PropagateDataItemSolveOrders() {
        this.mName = "Propagate a data item's solve order.";
        this.mPassNumbers = new int[]{4, 8};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Integer solveOrder = ((V5DataItem)node).getSolveOrderProperty();
        IXQEQueryNode[] memberFcn = node.getDescendantsOfType(201085, false);
        for (int i = 0; i < memberFcn.length; ++i) {
            V5MemberFunction v5member = (V5MemberFunction)memberFcn[i];
            if (v5member.getSolveOrder() != null) continue;
            v5member.setSolveOrder(solveOrder);
        }
        node.removeProperty("solveOrder");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((V5DataItem)node).getSolveOrderProperty() == null) {
            this.traceNodeCondition(false, "The data item does not have a solveOrder property.", trace);
            return false;
        }
        if (node.getFirstDescendantOfTypeOrdered(101003, false) != null) {
            this.traceNodeCondition(false, "The data item contains unresolved V5DataItem nodes.", trace);
            return false;
        }
        if (CoerceValueExpressionToV5MemberExpression.willBeCoercedToMember((V5DataItem)node)) {
            this.traceNodeCondition(false, "The data item expression must first be coerced to a member function.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The data item has a solvOrder property that can be propagated.", trace);
        return true;
    }
}

