/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5ReportMeasure;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RetrieveReportMeasure
extends Transformation {
    public RetrieveReportMeasure() {
        this.mName = "Copy the V5 report measure query hint expression to the MDX Query, when specified.";
        this.mPassNumbers = new int[]{2, 8};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5ReportMeasure v5DefaultMeasure = (V5ReportMeasure)nodeFactory.createNode(101065);
        String refQueryName = ((MDXQuery)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        String reportMeasure = (String)v5Query.getPropertyValue(V5Query.QueryHint.REPORT_MEASURE.getPropertyName());
        V5Selection v5Selection = v5Query.getV5Selection();
        V5DataItem v5DataItem = v5Selection.getDataItemByRefName(reportMeasure);
        IXQEQueryNode reportMeasureNode = v5DataItem.getChild(0);
        if (reportMeasureNode.getType() == 201085 && reportMeasureNode.getChild(0).getType() == 201058) {
            reportMeasureNode = reportMeasureNode.getChild(0);
        }
        v5DefaultMeasure.addChild(nodeFactory.deepCopyNode(reportMeasureNode));
        node.addChild(v5DefaultMeasure);
        v5DefaultMeasure.setReportMeasureNameProperty(reportMeasure);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getFirstChildByType(101065) != null || node.getFirstChildByType(1092) != null) {
            this.traceQueryCondition(false, "The MDXQuery has already retrieved the reportMeasure query hint.", trace);
            return false;
        }
        String refQueryName = ((MDXQuery)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        if (v5Query == null || v5Query.getPropertyValue(V5Query.QueryHint.REPORT_MEASURE.getPropertyName()) == null) {
            this.traceQueryCondition(false, "The V5Query does not have a reportMeasure query hint specified.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The V5Query has a reportMeasure query hint specified.", trace);
        return true;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "reportMeasure");
        trace.endElement();
    }
}

