/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.ReplaceDMRMemberInDetailFilterExpression;

public class ExpandDMRMemberFilterExpression
extends Transformation {
    private static final String UNEXPECTED_ROOT_LEVEL = "ExpandDMRMemberFilterExpression.getMunNormalizationSkipReason: (null != previousLevel) and (level.isRootLevel())";

    public ExpandDMRMemberFilterExpression() {
        this.mName = "Update DMR member filter expression.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ReplaceDMRMemberInDetailFilterExpression.replaceDMRMember(node, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getBooleanPropertyValue("updatedInDMRMemberFilter") != null) {
            this.traceNodeCondition(false, "The MUN has been updated.", trace);
            return false;
        }
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter == null) {
            this.traceNodeCondition(false, "The MUN is not within a detail filter.", trace);
            return false;
        }
        if (mdxDetailFilter.pushDetailFilterToRelationalProvider() || mdxDetailFilter.getPropertyValue("dmrSlicer") != null) {
            String[] reason = new String[]{""};
            boolean b = ExpandDMRMemberFilterExpression.checkNodeCondition(node, reason);
            this.traceNodeCondition(b, reason[0], trace);
            return b;
        }
        this.traceNodeCondition(false, "The MUN do not need any update.", trace);
        return false;
    }

    public static boolean checkNodeCondition(IXQEQueryNode node, String[] reason) {
        V5BoundMemberUniqueName v5BoundId = (V5BoundMemberUniqueName)node;
        ILevel level = v5BoundId.getLevel();
        if (!(level instanceof LevelWrapper)) {
            reason[0] = "The level is not wrapped.";
            return false;
        }
        String munNormalizationSkipReason = ExpandDMRMemberFilterExpression.getMunNormalizationSkipReason(level);
        if (null != munNormalizationSkipReason) {
            reason[0] = munNormalizationSkipReason;
            return false;
        }
        int[] types = new int[]{201011, 201013};
        IXQEQueryNode compOp = node.getAncestorOfTypes(types);
        if (compOp == null) {
            reason[0] = "The MUN is not in a member comparison expression.";
            return false;
        }
        IXQEQueryNode filteredSet = compOp.getChild(0);
        if (filteredSet.isOfCategory(201122) && ((AbstractV5Set)filteredSet).getMetadata().getObjectType() != MetadataType.LEVEL) {
            reason[0] = "The set to be filtered has to be a level.";
            return false;
        }
        reason[0] = "The MUN in a detail filter needs to be updated.";
        return true;
    }

    public static boolean membersRequireMunNormalization(ILevel level) {
        return null == ExpandDMRMemberFilterExpression.getMunNormalizationSkipReason(level);
    }

    private static String getMunNormalizationSkipReason(ILevel level) {
        if (level.isUnique()) {
            return "The MUN is on a unique level thus does not need normalization.";
        }
        ILevel previousLevel = level.getPreviousLevel();
        if (null == previousLevel) {
            return "The MUN is on a level without previous level thus does not need normalization.";
        }
        if (level.isRootLevel()) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.MDX", LogLevel.ERROR).log(UNEXPECTED_ROOT_LEVEL);
            return "The MUN is on a root level thus does not need normalization.";
        }
        if (previousLevel.isRootLevel()) {
            return "The MUN is on a level whose previous level is a root level thus does not need normalization.";
        }
        return null;
    }
}

