/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class UpdateBoundChildrenOfMemberToExpression
extends Transformation {
    public UpdateBoundChildrenOfMemberToExpression() {
        this.mName = "Update bound hierarchy with levels.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        UpdateBoundChildrenOfMemberToExpression.updateBoundChildrenOfMemberToExpression(node, environment);
    }

    public static void updateBoundChildrenOfMemberToExpression(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] items;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundMemberUniqueName boundId = (V5BoundMemberUniqueName)node;
        for (IXQEQueryNode item : items = boundId.getAncestorsOfTypeWithAnchor(101003, 1010)) {
            item.extract();
        }
        boundId.getParent().extract();
        ILevel level = (ILevel)boundId.getMetadata();
        String isManualProp = (String)level.getProperty("isManual");
        if (isManualProp != null && Boolean.parseBoolean(isManualProp)) {
            ILevel nextLevel = level.getNextLevel();
            V5BoundModelIdentifier levelIdentifier = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            levelIdentifier.setMetadata(nextLevel);
            boundId.exchange(levelIdentifier, true);
            return;
        }
        V5ComparisonExpression level1Exp = (V5ComparisonExpression)nodeFactory.createNode(201013);
        level1Exp.setSubType(2);
        boundId.insertParent(level1Exp);
        V5BoundModelIdentifier level1 = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        level1.setMetadata(level);
        level1Exp.addChild(level1, 0);
        int logicalType = 0;
        int position = 0;
        IXQEQueryNode booleanExp = level1Exp.getAncestorOfCategory(201126);
        if (booleanExp != null) {
            IXQEQueryNode indexNode = level1Exp;
            while (indexNode.getParent() != booleanExp) {
                indexNode = indexNode.getParent();
            }
            position = booleanExp.getPositionOfChild(indexNode);
        } else {
            booleanExp = level1Exp.getParent();
        }
        if (position > 0 && (booleanExp.getNodeType() == 201011 || booleanExp.getNodeType() == 201013 && ((V5ComparisonExpression)booleanExp).getSubType() == 2)) {
            if (booleanExp.getNumberChildren() <= 2) {
                booleanExp.exchange(level1Exp.detach());
                return;
            }
            logicalType = 1;
            level1Exp.detach();
        } else {
            V5BoundModelIdentifier level2 = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            ILevel nextLevel = level.getNextLevel();
            level2.setMetadata(nextLevel);
            level1Exp.exchange(level2);
        }
        V5LogicalExpression logicalExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
        logicalExpr.setSubType(logicalType);
        booleanExp.insertParent(logicalExpr);
        logicalExpr.addChild(level1Exp, 0);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter == null) {
            this.traceNodeCondition(false, "The bound identifier is not within a detail filter.", trace);
            return false;
        }
        if (mdxDetailFilter.pushDetailFilterToRelationalProvider() && UpdateBoundChildrenOfMemberToExpression.checkNodeCondition(node)) {
            this.traceNodeCondition(true, "The bound identifier is for the children of a member to be converted.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The bound identifier do not need any conversion.", trace);
        return false;
    }

    public static boolean checkNodeCondition(IXQEQueryNode node) {
        IMetadata metadata = ((V5BoundMemberUniqueName)node).getMetadata();
        return metadata != null && metadata instanceof LevelWrapper && (node.getParent().getType() == 201053 || node.getParent().getType() == 101003 && node.getParent().getParent().getType() == 201053);
    }
}

