/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5QueryToCogMDXQueryTransformationLibrary;

public final class UpdateBoundQueryItemToLevel
extends AbstractV5ToCogMDXTransformation {
    public UpdateBoundQueryItemToLevel() {
        this.mName = "Update bound identifier with multi-dimensional level.";
        this.mPassNumbers = V5QueryToCogMDXQueryTransformationLibrary.ALLPASSES;
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundId;
        IMetadata metaData;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        ICube cube = mdxQuery.getMDXFrom().getCube();
        CubeWrapper cubeWrapper = (CubeWrapper)cube;
        IMetadata metaDataWrapper = cubeWrapper.getWrapper(metaData = (v5BoundId = (V5BoundModelIdentifier)node).getMetadata());
        if (metaDataWrapper == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Metadata missing from cubeWrapper.");
        }
        v5BoundId.setMetadata(metaDataWrapper);
        if (metaDataWrapper instanceof ILevel) {
            IXQEQueryNode v5MembersNode = nodeFactory.createNode(201086);
            node.insertParent(v5MembersNode);
        } else if (metaDataWrapper.getObjectType() == MetadataType.MEMBER) {
            IXQEQueryNode parentNode = node.getParent();
            if (parentNode.getType() == 101003) {
                parentNode = parentNode.getParent();
            }
            if (parentNode.getType() == 201113) {
                IXQEQueryNode v5MembersNode = nodeFactory.createNode(201110);
                node.insertParent(v5MembersNode);
            } else if (parentNode.getType() != 201110) {
                IXQEQueryNode v5MembersNode = nodeFactory.createNode(201113);
                node.insertParent(v5MembersNode);
                v5MembersNode = nodeFactory.createNode(201110);
                node.insertParent(v5MembersNode);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter != null && mdxDetailFilter.pushDetailFilterToRelationalProvider()) {
            this.traceNodeCondition(false, "The bound identifier do not need to be converted, the detail filter pushed to the relational provider.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        ICube cube = mdxQuery.getMDXFrom().getCube();
        if (cube != null && cube instanceof CubeWrapper) {
            IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
            if (metaData.getObjectType() == MetadataType.QUERY_ITEM && ((IQueryItem)metaData).getLevel() == null) {
                this.traceNodeCondition(true, "The bound identifier is for a query item to be wrapped within a level.", trace);
                return true;
            }
            this.traceNodeCondition(false, "The bound identifier is not a query item.", trace);
            return false;
        }
        this.traceNodeCondition(false, "The MDX query is not for a temporary cube (CubeWrapper).", trace);
        return false;
    }
}

