/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.binding;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.DisableDMRAggregateSummaryOptimization;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class UpdateRelExpressionToLevelOrMeasure
extends AbstractV5ToCogMDXTransformation {
    protected static final int[] TYPES_COERCE_VALUE_EXPR_ARG2AND3 = UpdateRelExpressionToLevelOrMeasure.initializeTypesCoerceValueExpressionArgs2And3();
    protected static final int[] TYPES_COERCE_OPERATORS = UpdateRelExpressionToLevelOrMeasure.initializeTypesCoerceOperators();
    protected static final int[] TYPES_COERCE_SET_ALLARGS = UpdateRelExpressionToLevelOrMeasure.initializeTypesCoerceSetAllArgs();
    protected static final int[] TYPES_COERCE_VALUE_EXPR_ARG1 = UpdateRelExpressionToLevelOrMeasure.initializeTypesCoerceValueExpressionArgs1();
    protected static final int[] TYPES_COERCE_VALUE_EXPR_ARG2 = UpdateRelExpressionToLevelOrMeasure.initializeTypesCoerceValueExpressionArgs2();
    protected static final int[] TYPES_COERCE_VALUE_EXPR_IN = UpdateRelExpressionToLevelOrMeasure.initializeTypesCoerceValueExpressionIn();

    private static int[] initializeTypesCoerceValueExpressionArgs2And3() {
        int[] types = new int[]{201047, 201048, 201049, 201043, 201017, 201044, 201104, 201106, 201107, 201108};
        Arrays.sort(types);
        return types;
    }

    private static int[] initializeTypesCoerceOperators() {
        int[] types = new int[]{201013, 201014, 201040};
        Arrays.sort(types);
        return types;
    }

    private static int[] initializeTypesCoerceSetAllArgs() {
        int[] types = new int[]{201039, 201037};
        Arrays.sort(types);
        return types;
    }

    private static int[] initializeTypesCoerceValueExpressionArgs1() {
        int[] types = new int[]{201075, 201010, 201009, 201012, 201079, 201085, 201032, 201034, 201114, 201031};
        Arrays.sort(types);
        return types;
    }

    private static int[] initializeTypesCoerceValueExpressionArgs2() {
        int[] types = new int[]{201071, 201077, 201081, 201083, 201091, 201093, 201105, 201019};
        Arrays.sort(types);
        return types;
    }

    private static int[] initializeTypesCoerceValueExpressionIn() {
        int[] types = new int[]{201011};
        Arrays.sort(types);
        return types;
    }

    public UpdateRelExpressionToLevelOrMeasure() {
        this.mName = "Update a TNODE with multi-dimensional level or measure.";
        this.mPassNumbers = new int[]{2, 8};
        this.mTypes = new int[]{601024};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXFromCube fromCube = mdxQuery.getMDXFrom();
        ICube cube = fromCube.getCube();
        CubeWrapper cubeWrapper = (CubeWrapper)cube;
        RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)node;
        Integer tp = relOLAPDeco.getWrapType();
        String name = relOLAPDeco.getWrapName();
        String caption = relOLAPDeco.getLabel();
        IDataType dt = relOLAPDeco.getDataType();
        IXQEQueryNode exp = relOLAPDeco.getExpression();
        String refName = relOLAPDeco.getWrapRefObjectName();
        String ownerName = relOLAPDeco.getWrapOwnerName();
        if (tp == 0) {
            V5DataItemToMeasureWrapper measure = null;
            if (refName != null) {
                measure = this.getMeasureByName(cube, refName);
            } else {
                measure = this.getMeasureByName(cube, refName);
                if (measure == null) {
                    String aggr = relOLAPDeco.getAggregate();
                    V5RollupAggregateEnum rollUpAggr = relOLAPDeco.getRollupAggregate();
                    Dimension measuresDim = cubeWrapper.createAndReturnMeasuresDimension();
                    Hierarchy measuresHier = (Hierarchy)measuresDim.getDefaultHierarchy();
                    Level measuresLevel = (Level)measuresHier.getLevels().get(0);
                    measure = new V5DataItemToMeasureWrapper(null, measuresDim, cubeWrapper.getConnection(), "TBmeasure_" + name, caption, dt, rollUpAggr.getName());
                    measure.setV5AggregateAttribute(aggr);
                    measure.setBinaryExpression(exp);
                    measure.setParentMetadataObject(measuresDim);
                    measuresLevel.addMember(measure, null);
                    measuresDim.addChildMetadataObject(measure);
                    MixedDMRRelUtil.unwindDimentionalObjectsAndSetScopes(environment, measure);
                }
            }
            MixedDMRRelUtil.resetDataType(measure, node);
            V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            newNode.setIdentifier(measure.getV5UniqueName());
            newNode.setMetadata(measure);
            node.exchange(newNode);
            this.coerceMeasureToValue(nodeFactory, newNode);
        } else if (tp == 1) {
            V5DataItemToLevelWrapper level = null;
            if (refName != null) {
                level = this.getLevelByName(cubeWrapper, refName);
            } else {
                level = this.getLevelByName(cubeWrapper, name);
                if (level == null) {
                    level = this.createNewLevel(cubeWrapper, name, caption, dt, exp);
                }
            }
            V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            newNode.setIdentifier(level.getV5UniqueName());
            newNode.setMetadata(level);
            IXQEQueryNode parent = node.getParent();
            if (parent.getType() != 201086) {
                IXQEQueryNode v5MembersNode = nodeFactory.createNode(201086);
                newNode.insertParent(v5MembersNode);
                node.exchange(v5MembersNode);
            } else {
                node.exchange(newNode);
            }
        } else if (tp == 2) {
            IMetadata meta;
            V5DataItemToLevelWrapper level = this.getLevelByName(cubeWrapper, ownerName);
            V5DataItemToLevelAttributeWrapper propObj = null;
            propObj = refName == null ? this.createNewProp(cubeWrapper, level, name, caption, dt, exp) : this.getLevelPropByName(level, refName);
            RSAPIDataItem item = (RSAPIDataItem)node.getPropertyValue("rsapiItem");
            if (item != null && !((meta = item.getModelReference()) instanceof V5DataItemToLevelAttributeWrapper)) {
                item.setModelReference(propObj);
            }
            V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            newNode.setIdentifier(propObj.getV5UniqueName());
            newNode.setMetadata(propObj);
            node.exchange(newNode);
        }
        this.preserveV5SourceForSubQuery(environment, nodeFactory, cubeWrapper, mdxQuery, fromCube);
    }

    protected void coerceMeasureToValue(IXQENodeFactory nodeFactory, IXQEQueryNode newNode) {
        IXQEQueryNode lastNode = newNode;
        IXQEQueryNode parentNode = newNode.getParent();
        while (parentNode.getType() == 101003) {
            lastNode = parentNode;
            parentNode = parentNode.getParent();
        }
        int type = parentNode.getType();
        int idx = Arrays.binarySearch(TYPES_COERCE_VALUE_EXPR_ARG1, type);
        if (idx >= 0) {
            IXQEQueryNode[] children = parentNode.getChildren();
            if (children.length >= 1 && children[0] == lastNode) {
                MixedDMRRelUtil.coerceToValue(newNode, nodeFactory);
            }
            return;
        }
        idx = Arrays.binarySearch(TYPES_COERCE_VALUE_EXPR_ARG2, type);
        if (idx >= 0) {
            IXQEQueryNode[] children = parentNode.getChildren();
            if (children.length >= 2 && children[1] == lastNode) {
                MixedDMRRelUtil.coerceToValue(newNode, nodeFactory);
            }
            return;
        }
        idx = Arrays.binarySearch(TYPES_COERCE_VALUE_EXPR_ARG2AND3, type);
        if (idx >= 0) {
            IXQEQueryNode[] children = parentNode.getChildren();
            if (children.length >= 2 && children[1] == lastNode || children.length >= 3 && children[2] == lastNode) {
                MixedDMRRelUtil.coerceToValue(newNode, nodeFactory);
            }
            return;
        }
        idx = Arrays.binarySearch(TYPES_COERCE_OPERATORS, type);
        if (idx >= 0) {
            IXQEQueryNode[] children;
            for (IXQEQueryNode child : children = parentNode.getChildren()) {
                if (child != lastNode) continue;
                MixedDMRRelUtil.coerceToValue(newNode, nodeFactory);
                return;
            }
            return;
        }
        idx = Arrays.binarySearch(TYPES_COERCE_SET_ALLARGS, type);
        if (idx >= 0) {
            IXQEQueryNode[] children;
            for (IXQEQueryNode child : children = parentNode.getChildren()) {
                if (child != lastNode) continue;
                IXQEQueryNode setExpression = nodeFactory.createNode(201101);
                newNode.insertParent(setExpression);
                return;
            }
            return;
        }
        idx = Arrays.binarySearch(TYPES_COERCE_VALUE_EXPR_IN, type);
        if (idx >= 0) {
            IXQEQueryNode[] children = parentNode.getChildren();
            if (children.length >= 1 && children[0] == lastNode) {
                MixedDMRRelUtil.coerceToValue(newNode, nodeFactory);
            }
            return;
        }
    }

    protected V5DataItemToMeasureWrapper getMeasureByName(ICube cube, String refName) {
        String measureName = "TBmeasure_" + refName;
        List<IDimension> dims = cube.getDimensions();
        for (IDimension dim : dims) {
            if (!dim.isMeasuresDimension()) continue;
            IHierarchy hier = dim.getDefaultHierarchy();
            Level measuresLevel = (Level)hier.getLevels().get(0);
            List<IMember> mems = measuresLevel.getMembers();
            for (IMember m : mems) {
                String name = m.getName();
                if (!name.equals(measureName)) continue;
                return (V5DataItemToMeasureWrapper)m;
            }
            return null;
        }
        return null;
    }

    protected V5DataItemToLevelWrapper createNewLevel(CubeWrapper cubeWrapper, String name, String caption, IDataType dt, IXQEQueryNode exp) {
        int idx = name.lastIndexOf("_");
        String dimName = name.substring(0, idx);
        String fullDimName = "TBdimension_" + dimName;
        String uniqueName = UniqueNameGenerator.createUniqueName(fullDimName);
        Dimension dim = (Dimension)cubeWrapper.getDimension(uniqueName);
        if (dim == null) {
            dim = TabStreamUtil.createDimensionWrapper(cubeWrapper, dimName);
        }
        String levelName = "TBlevel_" + name;
        StringBuilder expTxt = new StringBuilder();
        ((V5SimpleNode)exp).writeFormattedText(expTxt);
        V5DataItemToLevelWrapper levelwrapper = new V5DataItemToLevelWrapper(dim, dim.getCube().getConnection(), levelName, caption, dt, expTxt.toString());
        levelwrapper.setBinaryExpression(exp);
        ((Hierarchy)dim.getDefaultHierarchy()).addLevel(levelwrapper);
        levelwrapper.setProperty("ReturnRaw", Boolean.TRUE);
        return levelwrapper;
    }

    protected boolean parentLevelCreated(CubeWrapper cube, RelationalOlapDecorationNode node) {
        Integer tp = node.getWrapType();
        String name = node.getWrapName();
        if (tp == 0) {
            String refName = node.getWrapRefObjectName();
            if (refName != null) {
                return this.getMeasureByName(cube, refName) != null;
            }
            return true;
        }
        if (tp == 1) {
            String uniqueLevelName;
            String refName = node.getWrapRefObjectName();
            if (refName != null) {
                return this.getLevelByName(cube, refName) != null;
            }
            int idx = name.lastIndexOf("_");
            String levelName = name.substring(idx + 1);
            int levelIdx = Integer.parseInt(levelName);
            if (levelIdx == 0) {
                return true;
            }
            String dimName = name.substring(0, idx);
            String fullDimName = "TBdimension_" + dimName;
            String uniqueName = UniqueNameGenerator.createUniqueName(fullDimName);
            Dimension dim = (Dimension)cube.getDimension(uniqueName);
            if (dim == null) {
                return false;
            }
            int preLevel = levelIdx - 1;
            String preLevelName = dimName + "_" + Integer.toString(preLevel);
            IHierarchy hier = dim.getDefaultHierarchy();
            return hier.getLevel(uniqueLevelName = UniqueNameGenerator.createUniqueName(dim.getName(), hier.getName(), "TBlevel_" + preLevelName)) != null;
        }
        return true;
    }

    protected V5DataItemToLevelWrapper getLevelByName(ICube cube, String refName) {
        int idx = refName.lastIndexOf("_");
        String dimName = refName.substring(0, idx);
        String fullDimName = "TBdimension_" + dimName;
        String uniqueName = UniqueNameGenerator.createUniqueName(fullDimName);
        Dimension dim = (Dimension)cube.getDimension(uniqueName);
        if (dim == null) {
            return null;
        }
        IHierarchy hier = dim.getDefaultHierarchy();
        String uniqueLevelName = UniqueNameGenerator.createUniqueName(dim.getName(), hier.getName(), "TBlevel_" + refName);
        return (V5DataItemToLevelWrapper)hier.getLevel(uniqueLevelName);
    }

    protected V5DataItemToLevelAttributeWrapper createNewProp(CubeWrapper cubeWrapper, V5DataItemToLevelWrapper level, String name, String caption, IDataType dt, IXQEQueryNode exp) {
        String propName = "TBproperty_".concat(name);
        V5DataItemToLevelAttributeWrapper propObj = new V5DataItemToLevelAttributeWrapper(cubeWrapper.getConnection(), (Dimension)level.getDimension(), level, propName, dt);
        level.addChildMetadataObject(propObj);
        propObj.setBinaryExpression(exp);
        return propObj;
    }

    protected V5DataItemToLevelAttributeWrapper getLevelPropByName(V5DataItemToLevelWrapper level, String name) {
        String propName = "TBproperty_".concat(name);
        List<IMetadata> childrenMeta = level.getChildMetadataObjects();
        if (childrenMeta != null) {
            for (IMetadata meta : childrenMeta) {
                V5DataItemToLevelAttributeWrapper prop;
                if (!(meta instanceof V5DataItemToLevelAttributeWrapper) || !(prop = (V5DataItemToLevelAttributeWrapper)meta).getName().equals(propName)) continue;
                return prop;
            }
        }
        return null;
    }

    protected void preserveV5SourceForSubQuery(PlanningEnvironment environment, IXQENodeFactory nodeFactory, CubeWrapper cubeWrapper, MDXQuery mdxQuery, MDXFromCube fromCube) {
        V5Source v5Src;
        Object sqlQueries;
        V5QuerySet v5QuerySet = cubeWrapper.getV5QuerySetForV5Source();
        if (v5QuerySet != null) {
            return;
        }
        V5Query thisV5Query = mdxQuery.getRefV5Query();
        V5QuerySet thisV5QuerySet = (V5QuerySet)thisV5Query.getAncestorOfType(101002);
        HashSet<String> allSubqueries = new HashSet<String>();
        MixedDMRRelUtil.getAllSubQueryNamesFromV5Query(thisV5Query, environment, thisV5QuerySet, allSubqueries);
        if (allSubqueries.isEmpty() && ((IXQEQueryNode[])(sqlQueries = (v5Src = thisV5Query.getV5Source()).getChildrenOfType(101016))).length == 0) {
            return;
        }
        v5QuerySet = (V5QuerySet)nodeFactory.createNode(101002);
        cubeWrapper.setV5QuerySetForV5Source(v5QuerySet);
        V5Query query = (V5Query)nodeFactory.createNode(101006);
        v5QuerySet.addChild(query);
        query.setV5QueryName("mixedDMRRelational");
        query.addChild(nodeFactory.deepCopyNode(thisV5Query.getV5Source()));
        for (String subName : allSubqueries) {
            IXQEQueryNode[] valueSets;
            if (v5QuerySet.getV5Query(subName) != null) continue;
            V5Query orgV5Query = thisV5QuerySet.getV5Query(subName);
            v5QuerySet.addChild(nodeFactory.deepCopyNode(orgV5Query));
            for (IXQEQueryNode vs : valueSets = orgV5Query.getDescendantsOfType(101057, false)) {
                if (vs.getPropertyValue("isReportDetail") != null) continue;
                ((V5ValueSet)vs).setIsReportDetail(true);
            }
        }
        IModelDataSource modelDS = cubeWrapper.getModelDataSource();
        if (modelDS == null || !modelDS.isRelational()) {
            TabStreamUtil.createCubeWrapperAndSetRelDatasource(environment, cubeWrapper, fromCube, thisV5Query.getV5Source(), thisV5QuerySet, thisV5Query.getGovernors());
            DisableDMRAggregateSummaryOptimization.setDMRAggregateSummaryOptimizationLevel(mdxQuery);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)node;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)relOLAPDeco.getAncestorOfType(1002);
        ICube cube = mdxQuery.getMDXFrom().getCube();
        boolean bl = status = cube != null && cube instanceof CubeWrapper;
        if (status) {
            Integer tp = relOLAPDeco.getWrapType();
            String refName = relOLAPDeco.getWrapRefObjectName();
            String ownerName = relOLAPDeco.getWrapOwnerName();
            if (ownerName != null || refName != null) {
                if (tp == 0) {
                    V5DataItemToMeasureWrapper realMeasure = this.getMeasureByName(cube, refName);
                    status = realMeasure != null;
                } else if (tp == 1) {
                    V5DataItemToLevelWrapper realLevel = this.getLevelByName(cube, refName);
                    status = realLevel != null;
                } else if (tp == 2 && ownerName != null) {
                    V5DataItemToLevelWrapper realLevel = this.getLevelByName(cube, ownerName);
                    boolean bl2 = status = realLevel != null;
                    if (status && refName != null) {
                        V5DataItemToLevelAttributeWrapper realLevelProp = this.getLevelPropByName(realLevel, refName);
                        boolean bl3 = status = realLevelProp != null;
                    }
                }
            }
        }
        if (status) {
            status = this.parentLevelCreated((CubeWrapper)cube, relOLAPDeco);
        }
        if (status) {
            this.traceNodeCondition(true, "The TNODE is for a relational expression to be wrapped within a level or measure.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MDX query is not for a temporary cube (CubeWrapper).", trace);
        return false;
    }
}

