/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.crosstabspacer;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.handlingreplicas.RemoveReplicasFromValueSet;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public class RemoveNoCellValueCrosstabSpacerReplica
extends AbstractV5ToCogMDXTransformation {
    public static final String IS_NOT_APPLICABLE = "isNotApplicable.";

    public RemoveNoCellValueCrosstabSpacerReplica() {
        this.mName = "Handle valueSets replicas flagged with attribute spacer=noCellValue.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        V5Edge v5Edge = (V5Edge)node.getAncestorOfType(101049);
        rsapiDataset.addXV5ReinsertEdgePathElementsTarget(XQEIntegerPool.getInteger(v5Edge.getEdgeID()));
        MDXQuery mdxQuery = (MDXQuery)v5Edge.getAncestorOfType(1002);
        int edgeID = v5Edge.getEdgeID();
        mdxQuery.addEdgeWithCrosstabSpacers(edgeID);
        V5ValueSet v5ValueSet = (V5ValueSet)node;
        RSAPIEdgeRowset rowset = v5ValueSet.getRSAPIEdgeRowset();
        rowset.setIsCrosstabSpace(RSAPIEdgeRowset.CrosstabSpaceType.NOCELLVALUE);
        String dataItemRefName = v5ValueSet.getRefDataItemProperty();
        AbstractMDXNode v5ValueSetExpr = null;
        V5EdgeGroup parentV5EdgeGroup = (V5EdgeGroup)v5ValueSet.getParent();
        V5EdgeGroup grandParentV5EdgeGroup = (V5EdgeGroup)parentV5EdgeGroup.getAncestorOfType(101050);
        V5ValueSet ancestorValueSet = (V5ValueSet)grandParentV5EdgeGroup.getChild(0);
        RSAPIEdgeRowset ancestorRowset = ancestorValueSet.getRSAPIEdgeRowset();
        AbstractMDXNode ancestorSet = null;
        RemoveReplicasFromValueSet.addReplicaOfThis(rowset, dataItemRefName, v5ValueSetExpr, ancestorSet, ancestorRowset, nodeFactory);
        if (parentV5EdgeGroup.getNumberChildren() == 1) {
            parentV5EdgeGroup.detach();
        } else {
            parentV5EdgeGroup.detachChild(0);
            parentV5EdgeGroup.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5ValueSet v5ValueSet = (V5ValueSet)node;
        if (!v5ValueSet.isSpacerNoCellValue()) {
            this.traceNodeCondition(false, "The value set is not a crosstab spacer with no cell value.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)v5ValueSet.getAncestorOfType(1002);
        if (mdxQuery.getPropertyValue("hasMemberSetReference") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Found a V5 MemberSet reference.", trace);
            return false;
        }
        V5Edge v5Edge = (V5Edge)v5ValueSet.getAncestorOfType(101049);
        if (!v5Edge.handleCrossTabSpaces()) {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
            return false;
        }
        V5EdgeGroup parentV5EdgeGroup = (V5EdgeGroup)v5ValueSet.getParent();
        if (RemoveNoCellValueCrosstabSpacerReplica.isSingleSpacerNestingV5EdgeGroups(parentV5EdgeGroup)) {
            this.traceNodeCondition(true, "The spacer value set can be handled as a replica.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The value set is a crosstab spacer with no cell value.", trace);
        return false;
    }

    public static boolean isSpacerNestingV5EdgeGroups(V5EdgeGroup parentV5EdgeGroup) {
        IXQEQueryNode ancestorV5EdgeGroup = parentV5EdgeGroup.getParent();
        IHierarchy parentHierarchy = parentV5EdgeGroup.getHierarchyInfo().getProjectedHierarchy(0);
        return ancestorV5EdgeGroup.getType() == 101050 && ((V5EdgeGroup)ancestorV5EdgeGroup).getHierarchyInfo().getProjectedHierarchy(0).equals(parentHierarchy) && parentV5EdgeGroup.getNumberChildren() > 1;
    }

    public static boolean isSingleSpacerNestingV5EdgeGroups(V5EdgeGroup parentV5EdgeGroup) {
        IXQEQueryNode ancestorV5EdgeGroup = parentV5EdgeGroup.getParent();
        if (Boolean.TRUE == ancestorV5EdgeGroup.getPropertyValue(IS_NOT_APPLICABLE)) {
            return false;
        }
        if (RemoveNoCellValueCrosstabSpacerReplica.isSpacerNestingV5EdgeGroups(parentV5EdgeGroup)) {
            for (IXQEQueryNode child : ancestorV5EdgeGroup.getChildren()) {
                V5ValueSet currValueSet;
                if (child == parentV5EdgeGroup || child.getType() == 101057 || !(currValueSet = (V5ValueSet)((V5EdgeGroup)child).getChild(0)).isSpacerNoCellValue() || !RemoveNoCellValueCrosstabSpacerReplica.isSpacerNestingV5EdgeGroups((V5EdgeGroup)child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

