/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.crosstabspacer;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class TurnOffHandlingOfCrosstabSpaces
extends AbstractV5ToCogMDXTransformation {
    public TurnOffHandlingOfCrosstabSpaces() {
        this.mName = "Turns off on the given edge the handling of crosstab spaces'.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101049};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] nestedGroups;
        V5Edge v5Edge = (V5Edge)node;
        MDXQuery mdxQuery = (MDXQuery)v5Edge.getAncestorOfType(1002);
        for (IXQEQueryNode nestedGroup : nestedGroups = v5Edge.getChildrenOfType(101050)) {
            boolean ancestorIsCrosstabSpace;
            V5ValueSet nestedV5ValueSet = (V5ValueSet)nestedGroup.getChild(0);
            boolean bl = ancestorIsCrosstabSpace = nestedV5ValueSet.isSpacerNoCellValue() || nestedV5ValueSet.isSpacerCellValue();
            if (!this.isNestingValueSpacers((V5EdgeGroup)nestedGroup, ancestorIsCrosstabSpace)) continue;
            v5Edge.setHandleCrossTabSpaces(false);
            int edgeID = v5Edge.getEdgeID();
            mdxQuery.addEdgeWithCrosstabSpacers(edgeID);
            return;
        }
        v5Edge.setHandleCrossTabSpaces(true);
    }

    protected boolean isNestingValueSpacers(V5EdgeGroup spacerGroup, boolean ancestorIsCrosstabSpace) {
        IXQEQueryNode[] nestedGroups;
        for (IXQEQueryNode nestedGroup : nestedGroups = spacerGroup.getChildrenOfType(101050)) {
            V5ValueSet nestedV5ValueSet = (V5ValueSet)nestedGroup.getChild(0);
            boolean currAncestorIsCrosstabSpace = ancestorIsCrosstabSpace;
            if (nestedV5ValueSet.isSpacerNoCellValue() || nestedV5ValueSet.isSpacerCellValue()) {
                currAncestorIsCrosstabSpace = true;
                if (ancestorIsCrosstabSpace) {
                    return true;
                }
            }
            if (!this.isNestingValueSpacers((V5EdgeGroup)nestedGroup, currAncestorIsCrosstabSpace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Edge v5Edge = (V5Edge)node;
        MDXQuery mdxQuery = (MDXQuery)v5Edge.getAncestorOfType(1002);
        if (mdxQuery.getPropertyValue("hasMemberSetReference") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Found a V5 MemberSet reference.", trace);
            return false;
        }
        if (v5Edge.getHandleCrossTabSpaces() != null) {
            this.traceNodeCondition(false, "The transformation was alrewady applied.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation is required.", trace);
        return true;
    }
}

