/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.shell.ShellHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class SetV5EdgeGroupHierarchyDepth
extends AbstractV5ToCogMDXTransformation {
    protected static final String REAPPLY = "Re-apply the transformation.";

    public SetV5EdgeGroupHierarchyDepth() {
        this.mName = "Set V5EdgeGroup Hierarchy Depth.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)node;
        V5Edge v5Edge = (V5Edge)node.getAncestorOfType(101049);
        MDXQuery mdxQuery = (MDXQuery)v5Edge.getAncestorOfType(1002);
        if (v5Edge.getPropertyValue("hierarchyNormalizationDone") != null) {
            v5EdgeGroup.setHierarchyDepthRedone(true);
            v5EdgeGroup.setPropertyHierarchyDepth(null);
        }
        Integer nodeId = v5EdgeGroup.getId();
        Integer hierarchyDepth = v5EdgeGroup.getHierarchyDepth(true);
        Integer origDepth = null;
        Integer[] depths = new Integer[]{origDepth, hierarchyDepth};
        SetV5EdgeGroupHierarchyDepth.getHierarchyDepth(v5EdgeGroup, depths);
        origDepth = depths[0];
        hierarchyDepth = depths[1];
        v5EdgeGroup.setPropertyHierarchyDepth(hierarchyDepth);
        IHierarchy nodeHierarchy = v5EdgeGroup.getPropertyHierarchy();
        if (v5Edge.getPropertyValue("hierarchyNormalizationDone") != null && nodeHierarchy != null && nodeHierarchy.isShell() && origDepth != null && origDepth.intValue() != hierarchyDepth.intValue()) {
            this.updateShellHierarchy(v5EdgeGroup, v5Edge, mdxQuery, hierarchyDepth);
        }
        if (v5EdgeGroup.getPropertyHierarchyDepth() == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_FailToSetV5EdgeGroupHierarchyDepth, nodeId.toString());
        }
    }

    private static void getHierarchyDepth(V5EdgeGroup v5EdgeGroup, Integer[] depths) {
        Integer origHierDepth = depths[0];
        Integer finalHierDepth = depths[1];
        IXQEQueryNode parent = v5EdgeGroup.getParent();
        IXQEQueryNode[] siblings = parent.getChildrenOfType(v5EdgeGroup.getType());
        IHierarchy nodeHierarchy = v5EdgeGroup.getPropertyHierarchy();
        if (nodeHierarchy != null && nodeHierarchy.isShell()) {
            IHierarchy nonCalcHierarchy = null;
            origHierDepth = XQEIntegerPool.getInteger(((ShellHierarchy)nodeHierarchy).getDepth());
            for (int i = 0; i < siblings.length; ++i) {
                V5EdgeGroup currV5EdgeGroup = (V5EdgeGroup)siblings[i];
                IHierarchy currentHierarchy = currV5EdgeGroup.getPropertyHierarchy();
                if (currentHierarchy.isShell()) continue;
                if (nonCalcHierarchy == null) {
                    nonCalcHierarchy = currentHierarchy;
                    finalHierDepth = currV5EdgeGroup.getHierarchyDepth(false);
                    continue;
                }
                if (nonCalcHierarchy.equals(currentHierarchy)) continue;
                finalHierDepth = origHierDepth;
                break;
            }
        }
        depths[0] = origHierDepth;
        depths[1] = finalHierDepth;
    }

    private void updateShellHierarchy(V5EdgeGroup v5EdgeGroup, V5Edge v5Edge, MDXQuery mdxQuery, Integer hierarchyDepth) {
        IHierarchy hierarchy = v5EdgeGroup.getEdgeGroupHierarchy();
        if (hierarchy.isShell() && ((ShellHierarchy)hierarchy).getDepth() != hierarchyDepth.intValue()) {
            String hierName = MDXQuery.getShellHierarchyName(v5Edge, XQEIntegerPool.getInteger(hierarchyDepth));
            IHierarchy newHierarchy = mdxQuery.getShellHierarchy(hierName, hierarchyDepth);
            MDXHierInfo patternHierInfo = v5Edge.getPropertyPatternHierInfo();
            if (patternHierInfo.projectsHierarchy(hierarchy)) {
                IXQEQueryNode[] v5EdgeGroups;
                patternHierInfo.replaceProjectedHierarchy(hierarchy, newHierarchy);
                v5Edge.setPropertyPatternHierInfo(patternHierInfo);
                for (IXQEQueryNode currGroup : v5EdgeGroups = v5Edge.getDescendantsOfType(101050, false)) {
                    V5EdgeGroup currV5EdgeGroup = (V5EdgeGroup)currGroup;
                    if (!currV5EdgeGroup.getPropertyHierarchy().equals(hierarchy)) continue;
                    Integer currV5EdgeGroupHierDepth = currV5EdgeGroup.getHierarchyDepth(true);
                    Integer origDepth = null;
                    Integer[] depths = new Integer[]{origDepth, currV5EdgeGroupHierDepth};
                    SetV5EdgeGroupHierarchyDepth.getHierarchyDepth(currV5EdgeGroup, depths);
                    origDepth = depths[0];
                    currV5EdgeGroupHierDepth = depths[1];
                    if (currV5EdgeGroupHierDepth != hierarchyDepth) continue;
                    if (BuildXOLAPEdgeMappingUtilities.isDMForNormalization(((V5ValueSet)currV5EdgeGroup.getChild(0)).getRefDataItemProperty())) {
                        V5BoundModelIdentifier v5Hier = (V5BoundModelIdentifier)currV5EdgeGroup.getChild(0).getChild(0).getChild(0).getChild(0);
                        v5Hier.setMetadata(newHierarchy);
                        ((V5ValueSet)currV5EdgeGroup.getChild(0)).setPropertyValue("normalizationHierarchy", newHierarchy);
                    }
                    currV5EdgeGroup.setPropertyHierarchy(newHierarchy);
                }
            }
            hierarchy = newHierarchy;
        }
        v5EdgeGroup.removePropertyHierarchy();
        v5EdgeGroup.setPropertyHierarchy(hierarchy);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesQueryCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        StringBuilder msgStr = new StringBuilder("The node is");
        boolean status = true;
        msgStr.append(" ");
        msgStr.append("within a MDXQuery node.");
        IXQEQueryNode v5Edge = node.getAncestorOfType(101049);
        boolean bl = status = v5Edge != null;
        if (status) {
            MDXHierInfo patternHierInfo;
            V5EdgeGroup v5EdgeGroup;
            if (v5Edge.getPropertyValue("hierarchyNormalizationDone") != null && !(v5EdgeGroup = (V5EdgeGroup)node).isHierarchyDepthRedone()) {
                Integer currDepth = ((V5EdgeGroup)node).getHierarchyDepth(true);
                Integer origDepth = ((V5EdgeGroup)node).getHierarchyDepth(false);
                if (origDepth.intValue() != currDepth.intValue()) {
                    this.traceNodeCondition(true, REAPPLY, trace);
                    return true;
                }
            }
            boolean bl2 = status = (patternHierInfo = ((V5Edge)v5Edge).getPropertyPatternHierInfo()) == null;
            if (status) {
                msgStr.append("The V5Edge patternHierInfo property has not been set yet for the V5Edge node");
            } else {
                msgStr.append("The V5Edge patternHierInfo property has been set already for the V5Edge node.");
            }
        } else {
            msgStr.append("The node is not within a V5Edge node.");
        }
        this.traceQueryCondition(status, msgStr.toString(), trace);
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode v5Edge = node.getAncestorOfType(101049);
        if (v5Edge.getPropertyValue("hierarchyNormalizationDone") != null) {
            this.traceNodeCondition(true, REAPPLY, trace);
            return true;
        }
        boolean status = false;
        String traceMsg = "";
        Integer hierarchyDepth = ((V5EdgeGroup)node).getPropertyHierarchyDepth();
        boolean bl = status = hierarchyDepth == null;
        if (status) {
            traceMsg = "The V5EdgeGroup hierarchyDepth property has not been set yet for this node.";
            IXQEQueryNode[] v5ValueSets = node.getChildrenOfTypeOrdered(101057);
            boolean bl2 = status = v5ValueSets.length > 0;
            traceMsg = !status ? traceMsg + " The V5EdgeGroup has no child V5ValueSet nodes." : traceMsg + " The V5EdgeGroup has at least one child V5ValueSet node.";
        } else {
            traceMsg = "The V5EdgeGroup hierarchyDepth property has been set already for this node.";
        }
        this.traceNodeCondition(status, traceMsg, trace);
        return status;
    }
}

