/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.querynormalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.v5.V5MasterDetailWindow;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.transformation.v5tocogmdx.querynormalization.ReformDetailPath;
import com.cognos.xqe.transformation.v5tocogmdx.querynormalization.ReformEdgeGroupInfo;
import com.cognos.xqe.transformation.v5tocogmdx.querynormalization.ReformEdgeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public final class ReformInfo {
    private static final String SAME_HIERARCHY_ON_MULTIPLE_EDGES = "v5.reportermode.sameHierarchyOnMultipleEdges";
    private static final String MEASURE_ON_MULTIPLE_EDGES = "v5.reportermode.measureOnMultipleEdges";
    public static final String OPEN_PAREHTHESIS = "(";
    public static final String CLOSE_PAREHTHESIS = ")";
    public static final String DELIMITER = ", ";
    public static final int REFORM_UNKOWN = 0;
    public static final int REFORM_NEEDED = 1;
    public static final int REFORM_OPTIMIZED = 2;
    public static final int REFORM_REQUIRED = 3;
    public static final int REFORM_NOTSUPPORT = -1;
    public static final int REFORM_NOTREQUIRED = -2;
    protected MDXQuery mQuery = null;
    protected IXQEQueryNode[] mEdges;
    protected ReformEdgeInfo[] mEdgeInfos;
    protected int mReportMeasureEdge = -1;
    protected Integer mReportMeasureEdgeID = new Integer(-1);
    protected String mReportMeasureDataItem;
    protected boolean mMeasureOnMultiEgdes = false;
    protected int mState = 0;
    protected boolean mThrowIfUnsupportedReporterModeQuery = true;
    protected int mHasUnreferencedHierarchyForCalculation = -1;
    protected HashMap<ReformDetailPath, ReformEdgeGroupInfo> mMpDetailPathToGrp = new HashMap();

    public ReformInfo(MDXQuery query, IXQEQueryNode[] edges) {
        this.mQuery = query;
        V5MasterDetailWindow window = (V5MasterDetailWindow)this.mQuery.getAncestorOfType(601026);
        if (window != null && window.getMasterDetailWindowNodeIDCombined() == window.getId().intValue()) {
            this.mThrowIfUnsupportedReporterModeQuery = false;
        }
        this.mEdges = edges;
        this.mEdgeInfos = new ReformEdgeInfo[edges.length];
        for (int i = 0; i < this.mEdges.length; ++i) {
            this.mEdgeInfos[i] = new ReformEdgeInfo();
            this.mEdgeInfos[i].mEdge = (V5Edge)this.mEdges[i];
        }
    }

    public int getState() {
        return this.mState;
    }

    public String getReportMeasureDataItem() {
        return this.mReportMeasureDataItem;
    }

    public int getReportMeasureEdge(RSAPIEdge[] rsapiEdges, boolean[] bNeedCreate, IMember[] measureMUN, String[] v5MUN, String[] v5Caption) {
        if (this.mMeasureOnMultiEgdes) {
            String name = (String)this.mEdgeInfos[this.mReportMeasureEdge].mEdge.getPropertyValue("name");
            for (int i = 0; i < rsapiEdges.length; ++i) {
                if (!name.equals(rsapiEdges[i].getName())) continue;
                ReformEdgeInfo edgeInfo = this.mEdgeInfos[this.mReportMeasureEdge];
                bNeedCreate[0] = edgeInfo.useOnlyOneMeasureMember(edgeInfo.mEdgeGroupPaths, measureMUN, v5MUN, v5Caption);
                return i;
            }
        }
        return -1;
    }

    public void needReform(PlanningEnvironment environment, MDXQuery mdxQuery) {
        if (this.mState != 0) {
            return;
        }
        this.hasAdjacentHierarchyNesting(environment);
        if (this.mState != 0) {
            return;
        }
        if (this.getEdgeHasMemeberSetReference() != null) {
            this.mState = 3;
            return;
        }
        ArrayList<IHierarchy> multipleHierOnEdges = this.getHierarchiesOnMultipleEdges(mdxQuery, true);
        if (!multipleHierOnEdges.isEmpty()) {
            this.mState = 3;
            return;
        }
        this.getPatternHierarchies();
        if (!this.hasCompatibleNesting()) {
            this.mState = 3;
            return;
        }
        if (this.hasEdgeWithPureCalculationsNoUnreferencedHierarchy()) {
            this.mState = 3;
            return;
        }
        if (this.hasContextIndependentUpAndDownNestingNoSetAlias(environment)) {
            this.mState = 3;
            return;
        }
        if (this.mState == 0) {
            this.mState = -2;
        }
    }

    public boolean needRelationalCrosstabNormalization(PlanningEnvironment environment, MDXQuery mdxQuery) {
        this.needReform(environment, mdxQuery);
        if (this.mState == -2) {
            return this.isHierarchyProjectedOnMultipleEdges(mdxQuery.getMeasuresHierarchy(), mdxQuery, false);
        }
        return false;
    }

    public void hasAdjacentHierarchyNesting(PlanningEnvironment environment) {
        for (int i = 0; i < this.mEdges.length; ++i) {
            V5EdgeGroup v5Grp;
            IXQEQueryNode[] v5Valuesets;
            V5Edge edge = (V5Edge)this.mEdges[i];
            List<IXQEQueryNode> v5Grps = edge.getDescendantsOfTypeOrdered(101050, false);
            if (v5Grps.size() == 0) {
                this.mEdgeInfos[i].mEmptyEdge = true;
                continue;
            }
            if (v5Grps.size() == 1 && (v5Valuesets = (v5Grp = (V5EdgeGroup)v5Grps.get(0)).getChildrenOfTypeOrdered(101057)).length == 1) {
                int edgeID;
                IHierarchy hier = v5Grp.getPropertyHierarchy();
                String itemName = ((V5ValueSet)v5Valuesets[0]).getRefDataItemProperty();
                if (hier != null && hier.getDimension().isMeasuresDimension() && !this.hasMemberSetReference(itemName) && (edgeID = edge.getEdgeID()) > this.mReportMeasureEdgeID) {
                    this.mReportMeasureEdgeID = edgeID;
                    this.mReportMeasureEdge = i;
                    this.mReportMeasureDataItem = itemName;
                }
            }
            int state = this.mEdgeInfos[i].hasAdjacentHierarchyNesting(v5Grps);
            IDataSourceCapabilities capabilities = this.mQuery.getCapabilities();
            if (this.mThrowIfUnsupportedReporterModeQuery && state == 1 && !capabilities.isSupported("v5.reportermode.nonadjacentNestingSameHierarchy")) {
                edge.throwInternalError("REFORM_NEEDED");
            } else if (state == 0) {
                this.mEdgeInfos[i].hasInverseNestingSameHierarchy(environment);
            }
            if (state == -1) {
                this.mState = -1;
                return;
            }
            if (state <= this.mState) continue;
            this.mState = state;
        }
    }

    protected boolean hasMemberSetReference(String itemName) {
        String refQueryName = this.mQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)this.mQuery.getAncestorOfType(101002);
        V5Selection v5Selection = v5QuerySet.getV5Query(refQueryName).getV5Selection();
        V5DataItem v5DataItem = v5Selection.getDataItemByRefName(itemName);
        IXQEQueryNode[] membersets = v5DataItem.getDescendantsOfType(201138, false);
        return membersets.length > 0;
    }

    public void resolveWithinDetail(IXQENodeFactory nodeFactory) {
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge || !this.mEdgeInfos[i].mEdgeNeedReform) continue;
            this.mEdgeInfos[i].resolveWithinDetail(nodeFactory, true, this);
        }
    }

    public ArrayList<IHierarchy> getHierarchiesOnMultipleEdges(MDXQuery mdxQuery, boolean skipRelationalCrosstabMeasures) {
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        ArrayList<IHierarchy> hierarchiesOnMultipleEdges = new ArrayList<IHierarchy>();
        if (this.mEdgeInfos.length < 2) {
            return hierarchiesOnMultipleEdges;
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)mdxQuery.getAncestorOfType(401005);
        boolean checkForMeasureNormalization = skipRelationalCrosstabMeasures && rsapiDataset.forXtabRelational() && this.measuresEdgeIsLast();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge) continue;
            ArrayList<IHierarchy> currHierList = this.mEdgeInfos[i].mHierObjs;
            for (int j = i + 1; j < this.mEdgeInfos.length; ++j) {
                if (this.mEdgeInfos[j].mEmptyEdge) continue;
                ArrayList<IHierarchy> nextHierList = this.mEdgeInfos[j].mHierObjs;
                for (IHierarchy currHier : currHierList) {
                    MDXHierInfo hierInfo;
                    IXQEQueryNode[] v5EdgeGroups;
                    if (!nextHierList.contains(currHier)) continue;
                    checkForMeasureNormalization = checkForMeasureNormalization && currHier.getDimension().isMeasuresDimension();
                    for (IXQEQueryNode v5EdgeGroup : v5EdgeGroups = this.mEdgeInfos[i].getEdge().getDescendantsOfType(101050, false)) {
                        hierInfo = ((V5EdgeGroup)v5EdgeGroup).getHierarchyInfo();
                        if (hierInfo == null || hierInfo.getNumProjectedHierarchies() <= 0 || !hierInfo.getProjectedHierarchy(0).equals(currHier)) continue;
                        if (checkForMeasureNormalization) {
                            checkForMeasureNormalization = this.projectsSingleMeasure((V5EdgeGroup)v5EdgeGroup);
                        }
                        if (messageContext.contains(v5EdgeGroup)) continue;
                        messageContext.add(v5EdgeGroup);
                    }
                    for (IXQEQueryNode v5EdgeGroup : v5EdgeGroups = this.mEdgeInfos[j].getEdge().getDescendantsOfType(101050, false)) {
                        hierInfo = ((V5EdgeGroup)v5EdgeGroup).getHierarchyInfo();
                        if (hierInfo == null || hierInfo.getNumProjectedHierarchies() <= 0 || !hierInfo.getProjectedHierarchy(0).equals(currHier)) continue;
                        if (checkForMeasureNormalization) {
                            checkForMeasureNormalization = this.projectsSingleMeasure((V5EdgeGroup)v5EdgeGroup);
                        }
                        if (messageContext.contains(v5EdgeGroup)) continue;
                        messageContext.add(v5EdgeGroup);
                    }
                    if (checkForMeasureNormalization || hierarchiesOnMultipleEdges.contains(currHier)) continue;
                    hierarchiesOnMultipleEdges.add(currHier);
                }
            }
        }
        if (hierarchiesOnMultipleEdges.isEmpty()) {
            return hierarchiesOnMultipleEdges;
        }
        if (hierarchiesOnMultipleEdges.size() > 1 || !hierarchiesOnMultipleEdges.get(0).getDimension().isMeasuresDimension()) {
            String hierListParam = ReformInfo.generateHierListParam(hierarchiesOnMultipleEdges);
            if (this.mThrowIfUnsupportedReporterModeQuery && !capabilities.isSupported(SAME_HIERARCHY_ON_MULTIPLE_EDGES)) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedSameHierarchyMultiEdges, hierListParam, messageContext);
                throw new XQERuntimeException(message);
            }
        }
        return hierarchiesOnMultipleEdges;
    }

    public ReformEdgeInfo getEdgeHasMemeberSetReference() {
        HashMap<ReformEdgeGroupInfo, HashSet<V5DataItem>> mp = new HashMap<ReformEdgeGroupInfo, HashSet<V5DataItem>>();
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge) continue;
            mp.clear();
            this.mEdgeInfos[i].getEdgeGroupsWithMemeberSetReferenceForValueSets(null, mp);
            if (mp.isEmpty()) continue;
            return this.mEdgeInfos[i];
        }
        return null;
    }

    public ReformEdgeInfo getTargetEdgeForMemberSetReference(ReformEdgeInfo egdeWithMemberSet) {
        HashMap<ReformEdgeGroupInfo, HashSet<V5DataItem>> mp = new HashMap<ReformEdgeGroupInfo, HashSet<V5DataItem>>();
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge || this.mEdgeInfos[i] == egdeWithMemberSet) continue;
            HashSet<String> allValueSets = new HashSet<String>();
            this.mEdgeInfos[i].getAllValueSetNames(allValueSets);
            mp.clear();
            egdeWithMemberSet.getEdgeGroupsWithMemeberSetReferenceForValueSets(allValueSets, mp);
            if (mp.isEmpty()) continue;
            return this.mEdgeInfos[i];
        }
        return null;
    }

    public void getPatternHierarchies() {
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            int state;
            if (this.mEdgeInfos[i].mEmptyEdge || this.mState >= (state = this.mEdgeInfos[i].makeAdjacentNesting(this))) continue;
            this.mState = state;
        }
    }

    protected boolean hasCompatibleNesting() {
        boolean b = true;
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge || this.mEdgeInfos[i].hasCompatibleNesting()) continue;
            b = false;
        }
        return b;
    }

    public List<V5Edge> getMeasuresEdges() {
        ArrayList<V5Edge> measuresEdges = new ArrayList<V5Edge>();
        block0: for (ReformEdgeInfo edge : this.mEdgeInfos) {
            if (edge.mEmptyEdge || edge.getEdgeId() == this.mReportMeasureEdgeID.intValue() && this.mReportMeasureDataItem != null) continue;
            for (IHierarchy hier : edge.mHierObjs) {
                if (!hier.getDimension().isMeasuresDimension()) continue;
                measuresEdges.add(edge.getEdge());
                continue block0;
            }
        }
        return measuresEdges;
    }

    public boolean measureOnEdges() {
        if (this.mEdgeInfos.length < 2) {
            return false;
        }
        boolean bMeasureHier = false;
        for (ReformEdgeInfo edge : this.mEdgeInfos) {
            if (edge.mEmptyEdge || edge.getEdgeId() == this.mReportMeasureEdgeID.intValue() && this.mReportMeasureDataItem != null) continue;
            boolean b = false;
            for (IHierarchy hier : edge.mHierObjs) {
                if (hier == null || !hier.getDimension().isMeasuresDimension()) continue;
                b = true;
                break;
            }
            if (!b) continue;
            if (!bMeasureHier) {
                bMeasureHier = true;
                continue;
            }
            return true;
        }
        return false;
    }

    public void putSameHierarchyInSameEdge(IXQENodeFactory nodeFactory, PlanningEnvironment environment) {
        IDataSourceCapabilities capabilities = this.mQuery.getCapabilities();
        if (this.mThrowIfUnsupportedReporterModeQuery && !capabilities.isSupported(MEASURE_ON_MULTIPLE_EDGES) && this.measureOnEdges()) {
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedMeasureMultiEdges, this.mQuery);
            throw new XQERuntimeException(message);
        }
        this.mState = 3;
        TreeMap<Integer, Integer> edgeMap = new TreeMap<Integer, Integer>();
        int i = 0;
        for (i = 0; i < this.mEdges.length; ++i) {
            int edgeID = ((V5Edge)this.mEdges[i]).getEdgeID();
            if (this.mReportMeasureEdge != -1 && i == this.mReportMeasureEdge) continue;
            edgeMap.put(edgeID, new Integer(i));
        }
        Collection vs = edgeMap.values();
        Object[] edgeIdx = vs.toArray();
        int[] edgePosArray = null;
        edgePosArray = this.mReportMeasureEdge != -1 ? new int[edgeIdx.length + 1] : new int[edgeIdx.length];
        for (i = 0; i < edgeIdx.length; ++i) {
            edgePosArray[i] = (Integer)edgeIdx[i];
        }
        if (this.mReportMeasureEdge != -1) {
            edgePosArray[edgeIdx.length] = this.mReportMeasureEdge;
        }
        int measureEdgeID = -1;
        for (i = 0; i < edgePosArray.length; ++i) {
            int edgePos = edgePosArray[i];
            ReformEdgeInfo edgeInfo = this.mEdgeInfos[edgePos];
            if (edgeInfo.mEmptyEdge) continue;
            for (int j = i + 1; j < edgePosArray.length; ++j) {
                int edgePos1 = edgePosArray[j];
                ReformEdgeInfo edgeInfo1 = this.mEdgeInfos[edgePos1];
                if (edgeInfo1.mEmptyEdge || !edgeInfo.containSameHierarchy(edgeInfo1)) continue;
                if (this.mReportMeasureEdge != -1 && edgePos1 == this.mReportMeasureEdge) {
                    measureEdgeID = edgePos;
                } else {
                    if (this.mThrowIfUnsupportedReporterModeQuery && !capabilities.isSupported(SAME_HIERARCHY_ON_MULTIPLE_EDGES)) {
                        int cnt;
                        ArrayList<IHierarchy> hierList = new ArrayList<IHierarchy>();
                        for (IHierarchy currHier : edgeInfo.mHierObjs) {
                            if (!edgeInfo.mHierObjs.contains(currHier)) continue;
                            hierList.add(currHier);
                        }
                        String hierListParam = ReformInfo.generateHierListParam(hierList);
                        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
                        IXQEQueryNode[] edgeGroups = edgeInfo.mEdge.getDescendantsOfType(101050, false);
                        for (cnt = 0; cnt < edgeGroups.length; ++cnt) {
                            if (hierList == null || !hierList.contains(((V5EdgeGroup)edgeGroups[cnt]).getPropertyHierarchy())) continue;
                            messageContext.add(edgeGroups[cnt]);
                        }
                        edgeGroups = edgeInfo1.mEdge.getDescendantsOfType(101050, false);
                        for (cnt = 0; cnt < edgeGroups.length; ++cnt) {
                            if (hierList == null || !hierList.contains(((V5EdgeGroup)edgeGroups[cnt]).getPropertyHierarchy())) continue;
                            messageContext.add(edgeGroups[cnt]);
                        }
                        XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedSameHierarchyMultiEdges, hierListParam, messageContext);
                        throw new XQERuntimeException(message);
                    }
                    edgeInfo.mergeEdge(nodeFactory, edgeInfo1, environment, this);
                    edgeInfo.mEdgeNeedReform = true;
                }
                edgeInfo1.mEmptyEdge = true;
                edgeInfo1.mEdgeNeedReform = true;
            }
        }
        if (measureEdgeID != -1) {
            this.mMeasureOnMultiEgdes = true;
            ReformEdgeInfo edgeInfo = this.mEdgeInfos[measureEdgeID];
            ReformEdgeInfo edgeInfo1 = this.mEdgeInfos[this.mReportMeasureEdge];
            if (edgeInfo.appendEdge(nodeFactory, edgeInfo1)) {
                edgeInfo.mEdgeNeedReform = true;
            }
            edgeInfo1.mEmptyEdge = true;
            edgeInfo1.mEdgeNeedReform = true;
        }
    }

    private static String generateHierListParam(List<IHierarchy> hierList) {
        StringBuilder hierListParam = new StringBuilder();
        for (IHierarchy hierarchy : hierList) {
            hierListParam.append(hierarchy.getName());
            hierListParam.append(DELIMITER);
        }
        int offSet = hierListParam.lastIndexOf(DELIMITER);
        hierListParam.replace(offSet, hierListParam.length(), "");
        return hierListParam.toString();
    }

    public void putEdgesWithMemeberSetInTargetEdge(IXQENodeFactory nodeFactory, PlanningEnvironment environment) {
        int nMax = this.mEdgeInfos.length;
        ReformEdgeInfo edgeWithMemberSet = this.getEdgeHasMemeberSetReference();
        for (int i = 0; edgeWithMemberSet != null && i <= nMax; ++i) {
            ReformEdgeInfo targetEdge = this.getTargetEdgeForMemberSetReference(edgeWithMemberSet);
            targetEdge.mergeEdgeForMemeberSetReference(nodeFactory, edgeWithMemberSet, environment, this);
            targetEdge.mEdgeNeedReform = true;
            edgeWithMemberSet.mEmptyEdge = true;
            edgeWithMemberSet.mEdgeNeedReform = true;
            edgeWithMemberSet = this.getEdgeHasMemeberSetReference();
        }
    }

    public void sortEdgeGroupsToPatternHierarchies() {
        this.hasCompatibleNesting();
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge || !this.mEdgeInfos[i].mEdgeNeedReformForPatternHierarchies) continue;
            this.mState = 3;
            this.mEdgeInfos[i].sortEdgeGroupsToPatternHierarchies();
        }
    }

    public void setReformEdges(ArrayList<RSAPIEdge> targetEdges, RSAPIEdge[] rsapiEdges) {
        block0: for (ReformEdgeInfo edgeInfo : this.mEdgeInfos) {
            if (!edgeInfo.mEdgeNeedReform) continue;
            String name = (String)edgeInfo.mEdge.getPropertyValue("name");
            for (RSAPIEdge rsapiEdge : rsapiEdges) {
                if (!name.equals(rsapiEdge.getName())) continue;
                targetEdges.add(rsapiEdge);
                continue block0;
            }
        }
    }

    public void checkEdgeGroupsExceedLimit() {
        int limit = this.mQuery.getCapabilities().getIntegerValue("v5.reportermode.maxEdgegroupsPerEdge", 0);
        if (limit <= 0) {
            return;
        }
        for (ReformEdgeInfo edge : this.mEdgeInfos) {
            if (edge.mEmptyEdge || !edge.mEdgeNeedReform) continue;
            edge.checkEdgeGroupsExceedLimit(limit);
        }
    }

    public boolean createSourceEdges(IXQENodeFactory nodeFactory, RSAPIDataset srcDataset, ArrayList<RSAPIEdge> srcEdges, RSAPIEdge[] rsapiEdges) {
        ArrayList<IXQEQueryNode> detachEdges = new ArrayList<IXQEQueryNode>();
        int i = 0;
        int nEdges = 0;
        block0: for (i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge) {
                if (this.mEdges[i] == null) continue;
                detachEdges.add(this.mEdges[i]);
                continue;
            }
            ++nEdges;
            if (!this.mEdgeInfos[i].mEdgeNeedReform) {
                String name = (String)this.mEdgeInfos[i].mEdge.getPropertyValue("name");
                int j = 0;
                for (j = 0; j < rsapiEdges.length; ++j) {
                    if (!name.equals(rsapiEdges[j].getName())) continue;
                    srcDataset.addEdge(rsapiEdges[j]);
                    continue block0;
                }
                continue;
            }
            RSAPIEdge origRSAPIEdge = (RSAPIEdge)this.mEdges[i].getPropertyValue("RSAPIEdge");
            int lastRowSetId = origRSAPIEdge.getLastRowsetId();
            RSAPIEdge srcRsapiEdge = new RSAPIEdge(lastRowSetId);
            srcEdges.add(srcRsapiEdge);
            srcDataset.addEdge(srcRsapiEdge);
            srcRsapiEdge.setDataset(srcDataset);
            srcRsapiEdge.setName(rsapiEdges[i].getName());
            srcRsapiEdge.setOrdinal(rsapiEdges[i].getOrdinal());
            this.mEdges[i].setPropertyValue("RSAPIEdge", srcRsapiEdge);
            this.mEdgeInfos[i].createSourceEdge(nodeFactory, (V5Edge)this.mEdges[i]);
        }
        for (i = 0; i < detachEdges.size(); ++i) {
            ((IXQEQueryNode)detachEdges.get(i)).detach();
        }
        if (nEdges < 2) {
            RSAPIEdge srcRsapiEdge = new RSAPIEdge();
            srcDataset.addEdge(srcRsapiEdge);
            srcRsapiEdge.setDataset(srcDataset);
            return true;
        }
        return false;
    }

    public void resolveReportSummary() {
        int i = 0;
        for (i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge || !this.mEdgeInfos[i].mEdgeNeedReform) continue;
            this.mEdgeInfos[i].resolveReportSummary();
        }
    }

    public boolean hasEdgeWithPureCalculationsNoUnreferencedHierarchy() {
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (!this.mEdgeInfos[i].mHierObjs.isEmpty() || this.hasUnreferencedHierarchyForCalculation()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasUnreferencedHierarchyForCalculation() {
        MDXHierInfo hierInfo;
        V5SimpleNode expr;
        if (this.mHasUnreferencedHierarchyForCalculation != -1) {
            return this.mHasUnreferencedHierarchyForCalculation == 1;
        }
        this.mHasUnreferencedHierarchyForCalculation = 0;
        MDXQuery mdxQuery = (MDXQuery)this.mEdges[0].getParent();
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!capabilities.isSupported("unreferencedHierarchy.calculations")) {
            return false;
        }
        HashSet<IHierarchy> referencedHierarchies = new HashSet<IHierarchy>();
        IXQEQueryNode[] filters = mdxQuery.getChildrenOfType(1010);
        IXQEQueryNode[] slicers = mdxQuery.getChildrenOfType(1009);
        int i = 0;
        if (filters != null) {
            for (i = 0; i < filters.length; ++i) {
                expr = (V5SimpleNode)filters[i].getChild(0);
                hierInfo = expr.getHierarchyInfo();
                referencedHierarchies.addAll(hierInfo.getProjectedHierarchies());
            }
        }
        if (slicers != null) {
            for (i = 0; i < slicers.length; ++i) {
                expr = (V5SimpleNode)slicers[i].getChild(0);
                hierInfo = expr.getHierarchyInfo();
                referencedHierarchies.addAll(hierInfo.getProjectedHierarchies());
            }
        }
        for (i = 0; i < this.mEdgeInfos.length; ++i) {
            referencedHierarchies.addAll(this.mEdgeInfos[i].mHierObjs);
        }
        HashSet<IDimension> referencedDimensions = new HashSet<IDimension>();
        for (IHierarchy hierarchy : referencedHierarchies) {
            if (hierarchy.isShell()) continue;
            referencedDimensions.add(hierarchy.getDimension());
        }
        IDimension unreferencedDimension = null;
        List<IDimension> cubeDimensions = mdxQuery.getReferencedCube().getDimensions();
        for (IDimension dimension : cubeDimensions) {
            if (referencedDimensions.contains(dimension)) continue;
            unreferencedDimension = dimension;
            break;
        }
        if (unreferencedDimension != null) {
            this.mHasUnreferencedHierarchyForCalculation = 1;
            return true;
        }
        if (!mdxQuery.isYukonProvider()) {
            Iterator hIt = referencedHierarchies.iterator();
            while (hIt.hasNext()) {
                IDimension dimension;
                dimension = ((IHierarchy)hIt.next()).getDimension();
                for (IHierarchy hierarchy : dimension.getHierarchies()) {
                    if (referencedHierarchies.contains(hierarchy)) continue;
                    this.mHasUnreferencedHierarchyForCalculation = 1;
                    return true;
                }
            }
        }
        return false;
    }

    public void assignEdgeWithPureCalculationsToMeasure(MDXQuery theMdxQuery, IXQENodeFactory nodeFactory) {
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (!this.mEdgeInfos[i].mHierObjs.isEmpty()) continue;
            this.mEdgeInfos[i].assignPureCalculationsToMeasure(theMdxQuery, nodeFactory);
        }
    }

    public boolean hasContextIndependentUpAndDownNestingNoSetAlias(PlanningEnvironment environment) {
        MDXQuery mdQuerySpec = (MDXQuery)this.mEdges[0].getAncestorOfType(1002);
        if (mdQuerySpec.setAliasSupported()) {
            return false;
        }
        boolean b = false;
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (!this.mEdgeInfos[i].hasContextIndependentUpAndDownNesting(environment)) continue;
            b = true;
        }
        return b;
    }

    public void sortEdgeGroupsNoUpAndDownNesting(IXQENodeFactory nodeFactory, PlanningEnvironment environment) {
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            if (this.mEdgeInfos[i].mEmptyEdge || !this.mEdgeInfos[i].sortEdgeGroupsNoUpAndDownNesting(environment)) continue;
            this.mEdgeInfos[i].resolveWithinDetail(nodeFactory, false, this);
        }
        this.mState = 3;
    }

    private boolean projectsSingleMeasure(V5EdgeGroup v5EdgeGroup) {
        V5ValueSet valueset;
        IXQEQueryNode expression;
        IXQEQueryNode[] valuesets = v5EdgeGroup.getChildrenOfType(101057);
        if (valuesets.length == 1 && (expression = (valueset = (V5ValueSet)v5EdgeGroup.getChild(0)).getChild(0)).getType() == 201101 && expression.getNumberChildren() == 1) {
            IXQEQueryNode setChild = expression.getChild(0);
            if (setChild.getType() == 201116) {
                return true;
            }
            if (setChild.getType() == 201085 && setChild.getNumberChildren() < 4) {
                return true;
            }
        }
        return false;
    }

    private boolean isHierarchyProjectedOnMultipleEdges(IHierarchy currHier, MDXQuery mdxQuery, boolean normalizeMeasures) {
        if (this.mEdgeInfos.length < 2) {
            return false;
        }
        if (normalizeMeasures && !mdxQuery.isDMR() && mdxQuery.getUseLocalQueryProcessing()) {
            return false;
        }
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < this.mEdgeInfos.length; ++i) {
            ArrayList<IHierarchy> currHierList;
            if (this.mEdgeInfos[i].mEmptyEdge || !(currHierList = this.mEdgeInfos[i].mHierObjs).contains(currHier)) continue;
            for (int j = i + 1; j < this.mEdgeInfos.length; ++j) {
                MDXHierInfo hierInfo;
                IXQEQueryNode[] v5EdgeGroups;
                ArrayList<IHierarchy> nextHierList;
                if (this.mEdgeInfos[j].mEmptyEdge || !(nextHierList = this.mEdgeInfos[j].mHierObjs).contains(currHier)) continue;
                boolean checkForMeasureNormalization = normalizeMeasures;
                for (IXQEQueryNode v5EdgeGroup : v5EdgeGroups = this.mEdgeInfos[i].getEdge().getDescendantsOfType(101050, false)) {
                    hierInfo = ((V5EdgeGroup)v5EdgeGroup).getHierarchyInfo();
                    if (hierInfo == null || hierInfo.getNumProjectedHierarchies() <= 0 || !hierInfo.getProjectedHierarchy(0).equals(currHier)) continue;
                    boolean bl = checkForMeasureNormalization = checkForMeasureNormalization && v5EdgeGroup.getParent().getType() == 101049;
                    if (messageContext.contains(v5EdgeGroup)) continue;
                    messageContext.add(v5EdgeGroup);
                }
                for (IXQEQueryNode v5EdgeGroup : v5EdgeGroups = this.mEdgeInfos[j].getEdge().getDescendantsOfType(101050, false)) {
                    hierInfo = ((V5EdgeGroup)v5EdgeGroup).getHierarchyInfo();
                    if (hierInfo == null || hierInfo.getNumProjectedHierarchies() <= 0 || !hierInfo.getProjectedHierarchy(0).equals(currHier)) continue;
                    boolean bl = checkForMeasureNormalization = checkForMeasureNormalization && v5EdgeGroup.getParent().getType() == 101049;
                    if (messageContext.contains(v5EdgeGroup)) continue;
                    messageContext.add(v5EdgeGroup);
                }
                if (checkForMeasureNormalization) continue;
                return true;
            }
        }
        return false;
    }

    private boolean measuresEdgeIsLast() {
        V5Edge lastEdge = (V5Edge)this.mEdges[this.mEdges.length - 1];
        return this.mReportMeasureEdgeID.intValue() == lastEdge.getEdgeID();
    }
}

