/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.querynormalization;

import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import java.util.ArrayList;

public class ReformLevel
implements Comparable<Object> {
    protected MDXLevelInfo mLevelInfo = null;
    protected ArrayList<V5SimpleNode> mContextDependentSet = null;

    public ReformLevel(MDXLevelInfo levelInfo, ArrayList<V5SimpleNode> fncs) {
        this.mLevelInfo = levelInfo;
        this.mContextDependentSet = fncs;
    }

    public int getHighestLevelIndex() {
        if (this.mLevelInfo == null || this.mLevelInfo.isEmpty() || this.mLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            return -1;
        }
        IHierarchy hierarchy = this.mLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (hierarchy == null || hierarchy.isShell()) {
            return -1;
        }
        ILevel highLevel = this.mLevelInfo.getHighestProjectedLevel(hierarchy);
        if (highLevel == null) {
            return -1;
        }
        return highLevel.getIndex();
    }

    public int getLowestLevelIndex() {
        if (this.mLevelInfo == null || this.mLevelInfo.isEmpty() || this.mLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            return -1;
        }
        IHierarchy hierarchy = this.mLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (hierarchy == null || hierarchy.isShell()) {
            return -1;
        }
        ILevel lowLevel = this.mLevelInfo.getLowestProjectedLevel(hierarchy);
        if (lowLevel == null) {
            return -1;
        }
        return lowLevel.getIndex();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReformLevel)) {
            return false;
        }
        ReformLevel p = (ReformLevel)obj;
        return p.getHighestLevelIndex() == this.getHighestLevelIndex() && p.getLowestLevelIndex() == this.getLowestLevelIndex();
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof ReformLevel)) {
            if (this.hashCode() <= obj.hashCode()) {
                return -1;
            }
            return 1;
        }
        ReformLevel p = (ReformLevel)obj;
        if (p.getHighestLevelIndex() == this.getHighestLevelIndex() && p.getLowestLevelIndex() == this.getLowestLevelIndex()) {
            return 0;
        }
        if (this.getLowestLevelIndex() > p.getLowestLevelIndex() || this.getLowestLevelIndex() == p.getLowestLevelIndex() && this.getHighestLevelIndex() < p.getHighestLevelIndex()) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return this.getLowestLevelIndex() + this.getHighestLevelIndex();
    }
}

