/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.querynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.ArrayList;
import java.util.List;

public final class ResolveCalculatedMeasureHierarchy
extends AbstractV5ToCogMDXTransformation {
    public static final String PROP_RESOLVE_CALC_HIERARCHY = "resolveCalculatedMeasureHierarchyApplied";

    public ResolveCalculatedMeasureHierarchy() {
        this.mName = "Resolve calculated measure hierarchy.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IXQEQueryNode> v5MemberFunctions = node.getDescendantsOfTypeOrdered(201085, false);
        V5MemberFunction v5MemberFunction = (V5MemberFunction)v5MemberFunctions.get(0);
        List<IHierarchy> hierarchies = this.getQueryCalcHierarchies(v5MemberFunction);
        ((V5EdgeGroup)node).setPropertyHierarchy(hierarchies.get(0));
        node.setPropertyValue(PROP_RESOLVE_CALC_HIERARCHY, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IHierarchy> hierarchies;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_RESOLVE_CALC_HIERARCHY) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation is already applied.", environment.getTrace());
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null || mdxQuery.isListReport()) {
            this.traceNodeCondition(false, "The transformation is not applied for the list report.", environment.getTrace());
            return false;
        }
        if (node.getAncestorOfType(101050) != null || node.getChildrenOfType(101050).length > 0) {
            this.traceQueryCondition(false, "The node is a child or a parent of a V5EdgeGroup node.", trace);
            return false;
        }
        IXQEQueryNode[] v5Valuesets = node.getChildrenOfTypeOrdered(101057);
        if (v5Valuesets.length != 1) {
            this.traceQueryCondition(false, "The node does not contain a single V5ValueSet node.", trace);
            return false;
        }
        int[] types = new int[]{101053, 101052, 101051};
        if (v5Valuesets[0].getNumberChildrenOfTypes(types) != 0) {
            this.traceQueryCondition(false, "The V5ValueSet has children of type V5GroupBody, V5Header, or V5Footer.", trace);
            return false;
        }
        IHierarchy hier = ((V5EdgeGroup)node).getPropertyHierarchy();
        if (hier != null && hier.getDimension().isMeasuresDimension()) {
            this.traceQueryCondition(false, "The node property already contains a measure hierarchy.", trace);
            return false;
        }
        List<IXQEQueryNode> v5MemberFunctions = node.getDescendantsOfTypeOrdered(201085, false);
        if (v5MemberFunctions.isEmpty() || v5MemberFunctions.size() > 1) {
            this.traceQueryCondition(false, "The node does not contain a single V5MemberFunctions node.", trace);
            return false;
        }
        V5MemberFunction v5MemberFunction = (V5MemberFunction)v5MemberFunctions.get(0);
        if (v5MemberFunction.getDescendantsOfCategory(201124, false).size() > 0 || v5MemberFunction.getDescendantsOfType(201039, false).length > 0) {
            this.traceQueryCondition(false, "The V5MemberFunctions node contains a summary function.", trace);
            return false;
        }
        if (!this.isQueryCalc(v5MemberFunction)) {
            this.traceQueryCondition(false, "The V5MemberFunctions node is not a query calculation.", trace);
            return false;
        }
        IXQEQueryNode edge = node.getParent();
        List<IXQEQueryNode> v5Groups = edge.getDescendantsOfTypeOrdered(101050, false);
        if (v5Groups.size() > 1) {
            for (V5EdgeGroup v5EdgeGroup : v5Groups) {
                if (v5EdgeGroup.equals(node)) continue;
                List<IXQEQueryNode> edgeCalcs = v5EdgeGroup.getDescendantsOfTypeOrdered(201085, false);
                for (int i = 0; i < edgeCalcs.size(); ++i) {
                    if (!this.isQueryCalc((V5MemberFunction)edgeCalcs.get(i))) continue;
                    this.traceQueryCondition(false, "The edge contains multiple edge groups with query calculations.", trace);
                    return false;
                }
            }
        }
        if ((hierarchies = this.getQueryCalcHierarchies(v5MemberFunction)).size() != 1 || !hierarchies.get(0).getDimension().isMeasuresDimension()) {
            this.traceQueryCondition(false, "The calculated member node does not contain a single measure hierarchy.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The node have a calculated member with a measure hierarchy.", trace);
        return true;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return super.passesQueryCondition(node, environment);
    }

    private boolean isQueryCalc(V5MemberFunction v5MemberFunction) {
        boolean status = v5MemberFunction.isQueryCalculation() && v5MemberFunction.isCoercion() && v5MemberFunction.getHierarchyInfo().getNumProjectedHierarchies() == 1 && v5MemberFunction.getHierarchyInfo().getProjectedHierarchy(0).isShell();
        return status;
    }

    private List<IHierarchy> getQueryCalcHierarchies(V5MemberFunction v5MemberFunction) {
        ArrayList<IHierarchy> hierarchies = new ArrayList<IHierarchy>();
        List<IXQEQueryNode> nodes = v5MemberFunction.getDescendantsOfCategoryOrdered(201120, false);
        IHierarchy hier = null;
        for (V5SimpleNode v5SimpleNode : nodes) {
            MDXHierInfo hierInfo = v5SimpleNode.getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() != 1 || hierInfo.getProjectedHierarchy(0).isShell() || hierarchies.contains(hier = hierInfo.getProjectedHierarchy(0))) continue;
            hierarchies.add(hier);
        }
        return hierarchies;
    }
}

