/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.querynormalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5MemberSet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberSetReference;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class SetV5MemberSetReferenceValueSetAssociation
extends Transformation {
    public SetV5MemberSetReferenceValueSetAssociation() {
        this.mName = "Set V5MemberSetReference associated Valuesets.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201138};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundMemberSetReference memberSetRef = (V5BoundMemberSetReference)node;
        V5DataItem item = null;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery theMdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (theMdxQuery == null || theMdxQuery.isListReport()) {
            item = memberSetRef.getFirstRefDataItemByName();
            SetV5MemberSetReferenceValueSetAssociation.replaceMemberSetReferenceWithDataItem(nodeFactory, memberSetRef, item);
            return;
        }
        if (!this.setV5MemberSetReferenceAssociatedV5ValueSet(nodeFactory, theMdxQuery, memberSetRef)) {
            item = memberSetRef.getFirstRefDataItemByName();
            SetV5MemberSetReferenceValueSetAssociation.replaceMemberSetReferenceWithDataItem(nodeFactory, memberSetRef, item);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(101009) != null) {
            this.traceQueryCondition(false, "The V5MemberSetReference is not in result definition.", trace);
            return false;
        }
        V5BoundMemberSetReference memberSetRef = (V5BoundMemberSetReference)node;
        if (memberSetRef.isValueSetAssociationApplied()) {
            this.traceQueryCondition(false, "The V5MemberSetReference is associated with ValueSets.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The V5MemberSetReference needs to be associated with ValueSets.", trace);
        return true;
    }

    private boolean setV5MemberSetReferenceAssociatedV5ValueSet(IXQENodeFactory nodeFactory, MDXQuery theMdxQuery, V5BoundMemberSetReference memberSetRef) {
        IXQEQueryNode[] edges;
        V5Edge theV5Edge = (V5Edge)memberSetRef.getAncestorOfType(101049);
        HashMap<V5DataItem, HashSet<String>> refDataItems = memberSetRef.getRefDataItemsToValueSets();
        HashMap<String, RefDataItemToV5MemberSets> refNames = new HashMap<String, RefDataItemToV5MemberSets>();
        for (Map.Entry<V5DataItem, HashSet<String>> e : refDataItems.entrySet()) {
            V5DataItem aItem = e.getKey();
            String aItemName = aItem.getNameProperty();
            RefDataItemToV5MemberSets v5MemberSetInfo = new RefDataItemToV5MemberSets();
            v5MemberSetInfo.mDataItem = aItem;
            v5MemberSetInfo.getV5MemberSetsReferencingDataItemName(theMdxQuery, aItemName);
            refNames.put(aItemName, v5MemberSetInfo);
        }
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> tmp = new HashMap<String, HashSet<String>>();
        V5Edge theFirstV5Edge = null;
        boolean bCheckProjection = false;
        IXQEQueryNode parentNode = memberSetRef.getParent();
        if (parentNode.getType() == 201039 && (parentNode = parentNode.getParent()).getType() == 201034 && ((V5SimpleNode)parentNode).getSubType() == 14) {
            bCheckProjection = true;
        }
        for (IXQEQueryNode aEdge : edges = theMdxQuery.getChildrenOfType(101049)) {
            if (aEdge.equals(theV5Edge)) continue;
            if (theFirstV5Edge == null) {
                this.getAssociatedV5ValueSet((V5Edge)aEdge, refNames, result, bCheckProjection);
                if (result.isEmpty()) continue;
                theFirstV5Edge = (V5Edge)aEdge;
                continue;
            }
            this.getAssociatedV5ValueSet((V5Edge)aEdge, refNames, tmp, bCheckProjection);
            if (tmp.isEmpty()) continue;
            return false;
        }
        if (theFirstV5Edge == null) {
            return false;
        }
        if (result.size() == 1) {
            V5DataItem item = ((RefDataItemToV5MemberSets)refNames.get(result.keySet().iterator().next())).mDataItem;
            SetV5MemberSetReferenceValueSetAssociation.replaceMemberSetReferenceWithDataItem(nodeFactory, memberSetRef, item);
        } else {
            ArrayList<V5DataItem> toDel = new ArrayList<V5DataItem>();
            for (Map.Entry<V5DataItem, HashSet<String>> e : refDataItems.entrySet()) {
                V5DataItem aItem = e.getKey();
                String aItemName = aItem.getNameProperty();
                if (!result.containsKey(aItemName)) {
                    toDel.add(aItem);
                    continue;
                }
                HashSet<String> valueSets = e.getValue();
                valueSets.addAll((Collection<String>)result.get(aItemName));
            }
            for (V5DataItem aDel : toDel) {
                refDataItems.remove(aDel);
            }
            memberSetRef.setValueSetAssociationApplied();
        }
        return true;
    }

    protected void getAssociatedV5ValueSet(V5Edge aEdge, HashMap<String, RefDataItemToV5MemberSets> refNames, HashMap<String, HashSet<String>> result, boolean bCheckProjection) {
        IXQEQueryNode[] valueSets = aEdge.getDescendantsOfType(101057, false);
        HashMap<String, HashSet<String>> searchMp = new HashMap<String, HashSet<String>>();
        for (IXQEQueryNode aValueSet : valueSets) {
            String name = ((V5ValueSet)aValueSet).getNameProperty();
            String refItemName = ((V5ValueSet)aValueSet).getRefDataItemProperty();
            HashSet<String> allItemNames = new HashSet<String>();
            allItemNames.add(refItemName);
            IXQEQueryNode[] items = aValueSet.getDescendantsOfType(101003, false);
            for (IXQEQueryNode aItem : items) {
                allItemNames.add(((V5DataItem)aItem).getNameProperty());
            }
            for (String aItemName : allItemNames) {
                HashSet<Object> v = null;
                if (!searchMp.containsKey(aItemName)) {
                    v = new HashSet();
                    searchMp.put(aItemName, v);
                } else {
                    v = searchMp.get(aItemName);
                }
                v.add(name);
            }
        }
        for (Map.Entry entry : refNames.entrySet()) {
            HashSet<String> associatedValueSets;
            String aItem = (String)entry.getKey();
            RefDataItemToV5MemberSets info = (RefDataItemToV5MemberSets)entry.getValue();
            if (bCheckProjection) {
                if (!searchMp.containsKey(aItem)) continue;
                associatedValueSets = new HashSet();
                associatedValueSets.addAll((Collection<String>)searchMp.get(aItem));
                result.put(aItem, associatedValueSets);
                continue;
            }
            associatedValueSets = info.getAssociatedValueSetsFromRootV5MemberSet(searchMp);
            if (associatedValueSets.isEmpty()) continue;
            result.put(aItem, associatedValueSets);
        }
    }

    public static void replaceMemberSetReferenceWithDataItem(IXQENodeFactory nodeFactory, V5BoundMemberSetReference memberSetRef, V5DataItem item) {
        if (item != null) {
            memberSetRef.addChild(nodeFactory.deepCopyNode(item));
            IXQEQueryNode[] itemsDel = memberSetRef.getDescendantsOfType(101003, false);
            for (int i = 0; i < itemsDel.length; ++i) {
                itemsDel[i].extract();
            }
        }
        memberSetRef.extract();
    }

    protected final class RefDataItemToV5MemberSets {
        protected V5DataItem mDataItem;
        protected HashSet<IXQEQueryNode> mV5MemberSets = new HashSet();

        protected RefDataItemToV5MemberSets() {
        }

        protected void getV5MemberSetsReferencingDataItemName(MDXQuery theMdxQuery, String aItemName) {
            IXQEQueryNode[] memberSets;
            String refQuery = theMdxQuery.getRefQueryProperty();
            V5QuerySet v5QuerySet = (V5QuerySet)theMdxQuery.getAncestorOfType(101002);
            V5Query v5Query = v5QuerySet.getV5Query(refQuery);
            for (IXQEQueryNode aMemebrSet : memberSets = v5Query.getOriginalV5Query().getDescendantsOfType(101005, false)) {
                String refItem = (String)((V5MemberSet)aMemebrSet).getPropertyValue("refDataItem");
                if (!aItemName.equals(refItem)) continue;
                this.mV5MemberSets.add(aMemebrSet);
            }
        }

        protected HashSet<String> getAssociatedValueSetsFromRootV5MemberSet(HashMap<String, HashSet<String>> searchMp) {
            IXQEQueryNode[] descendants;
            HashSet<String> associatedValueSets = new HashSet<String>();
            if (this.mV5MemberSets.isEmpty()) {
                return associatedValueSets;
            }
            IXQEQueryNode theV5MemebrSet = this.mV5MemberSets.iterator().next();
            IXQEQueryNode[] ancestors = theV5MemebrSet.getAncestorsOfType(101005);
            V5MemberSet rootMemberSet = null;
            rootMemberSet = ancestors.length == 0 ? (V5MemberSet)theV5MemebrSet : (V5MemberSet)ancestors[ancestors.length - 1];
            for (IXQEQueryNode aChildMemberSet : descendants = rootMemberSet.getDescendantsOfType(101005, true)) {
                String refItem = (String)((V5MemberSet)aChildMemberSet).getPropertyValue("refDataItem");
                if (refItem == null || !searchMp.containsKey(refItem)) continue;
                associatedValueSets.addAll((Collection<String>)searchMp.get(refItem));
            }
            return associatedValueSets;
        }
    }
}

