/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5CurrentMeasureFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.ast.v5Exp.V5TupleFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ConvertV5ValueSummaryFunctionOnValueExpressionToV5MemberSummaryFunction
extends Transformation {
    public ConvertV5ValueSummaryFunctionOnValueExpressionToV5MemberSummaryFunction() {
        this.mName = "Convert V5ValueSummaryFunction with a value expression to a V5MemberSummaryFunction.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201031};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5MemberSummaryFunction memberSummary = (V5MemberSummaryFunction)factory.createNode(201032);
        memberSummary.setSubType(((V5ValueSummaryFunction)node).getSubType());
        V5CurrentMeasureFunction currentMeasureFunction = (V5CurrentMeasureFunction)factory.createNode(201058);
        V5TupleFunction tupleFunction = (V5TupleFunction)factory.createNode(201110);
        tupleFunction.addChild(currentMeasureFunction);
        V5ValueFunction valueFunction = (V5ValueFunction)factory.createNode(201113);
        valueFunction.addChild(tupleFunction);
        memberSummary.addChild(valueFunction);
        IXQEQueryNode memberExpr = null;
        if (node.getChild(0).getType() == 201031) {
            memberExpr = node.getChild(0);
            while (memberExpr.getType() != 201116) {
                if (memberExpr.getNumberChildren() == 0) {
                    node.throwInternalError("");
                }
                memberExpr = memberExpr.getChild(0);
            }
            memberExpr = factory.deepCopyNode(memberExpr);
        } else {
            memberExpr = factory.createNode(201085);
            memberExpr.addChild(factory.deepCopyNode(node.getChild(0)));
        }
        V5SetFunction setFunction = (V5SetFunction)factory.createNode(201101);
        setFunction.addChild(memberExpr);
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)factory.createNode(201039);
        withinClause.setSubType(0);
        withinClause.addChild(setFunction);
        memberSummary.addChild(withinClause);
        node.getParent().exchangeChildNode(node, memberSummary);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1002) == null) {
            this.traceQueryCondition(false, "The target V5ValueSummaryFunction node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        if (node.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The target V5ValueSummaryFunction node has more than one argument.", trace);
            return false;
        }
        if (node.getPropertyValue("ValidateV5ValueSummaryFunctionApplied") == Boolean.FALSE) {
            this.traceNodeCondition(false, "The target node has not been validated.", trace);
            return false;
        }
        int v5SummaryType = ((V5ValueSummaryFunction)node).getSubType();
        MDXSummaryFunctionTypeEnum summaryType = MDXSummaryFunctionTypeEnum.convertV5SummaryFunctionTypeToMDXSummaryFunctionType(v5SummaryType);
        switch (summaryType) {
            case MEDIAN: 
            case STANDARD_DEVIATION: 
            case STANDARD_DEVIATION_POPULATION: 
            case VARIANCE: 
            case VARIANCE_POPULATION: {
                break;
            }
            default: {
                this.traceNodeCondition(false, "The target V5ValueSummaryFunction node will return the measure value.", trace);
                return false;
            }
        }
        if (node.getChild(0).isOfCategory(201124)) {
            this.traceNodeCondition(true, "The target V5ValueSummaryFunction node has an argument which is a summary function.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The target V5ValueSummaryFunction node has an argument which is NOT a summary function.", trace);
        return false;
    }
}

