/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEAbortGetParametersQueryException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ValidateParameters
extends AbstractV5ToCogMDXTransformation {
    private static final String VALIDATE_PARAMETERS_APPLIED = "ValidateParameters_Applied";

    public ValidateParameters() {
        this.mName = "Validate parameters to see if they have been resolved.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnvironment.getRequestParameters();
        MDXQuery mdxQuery = (MDXQuery)node;
        V5QuerySet v5QuerySet = (V5QuerySet)mdxQuery.getAncestorOfType(101002);
        IXQEQueryNode[] v5Queries = v5QuerySet.getChildrenOfType(101006);
        boolean relationalOrDMRNotFound = true;
        if (environment.isMultiModelForQueryEnabled()) {
            for (IXQEQueryNode v5Query : v5Queries) {
                V5Query currV5Query = (V5Query)v5Query;
                if (!currV5Query.isRelStyle() && !currV5Query.isDMR()) continue;
                relationalOrDMRNotFound = false;
                break;
            }
        }
        if (relationalOrDMRNotFound && parameters.hasUnresolvedParameters()) {
            throw new XQERuntimeException();
        }
        IXQEQueryNode rootNode = environment.getRoot();
        ((V5QuerySet)rootNode).setNonReusable(true);
        if (relationalOrDMRNotFound) {
            throw new XQEAbortGetParametersQueryException();
        }
        node.setPropertyValue(VALIDATE_PARAMETERS_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean result;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(VALIDATE_PARAMETERS_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "Thetransformation was applied already.", trace);
            return false;
        }
        IXQEQueryNode rootNode = environment.getRoot();
        MDXQuery mdxQuery = (MDXQuery)node;
        boolean dmrQueryMustCreateThePrePlan = false;
        if (mdxQuery.isDMR() || mdxQuery.isRelationalStyleQuery() || mdxQuery.isRelationaCrosstab()) {
            dmrQueryMustCreateThePrePlan = true;
        }
        ICube cube = mdxQuery.getMDXFrom().getCube();
        boolean isRolapModel = false;
        if (cube != null) {
            IModelDataSource modelDataSource = cube.getModelDataSource();
            isRolapModel = DataSourceTypeEnum.isROLAP(modelDataSource.getInterface());
        }
        boolean querySetContainsRelationalQuery = false;
        if (rootNode.getType() == 101002) {
            IXQEQueryNode[] v5Queries;
            for (IXQEQueryNode q : v5Queries = rootNode.getChildrenOfType(101006)) {
                V5Query v5Query = (V5Query)q;
                if (!v5Query.isDMR() && !v5Query.isTabular() && !v5Query.isRelStyle()) continue;
                querySetContainsRelationalQuery = true;
            }
        }
        boolean bl = result = rootNode.getType() == 101002 && !((V5QuerySet)rootNode).isNoDataMode();
        if (result) {
            if (dmrQueryMustCreateThePrePlan) {
                result = false;
                this.traceNodeCondition(result, "DMR query will wait until after the prePlan to throw.", trace);
            } else {
                RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
                Parameters parameters = requestEnvironment.getRequestParameters();
                if (parameters.hasUnresolvedParameters()) {
                    if (isRolapModel) {
                        result = false;
                        this.traceNodeCondition(result, "Rolap embedded cube model parameters should not be resolved at cube load time.", trace);
                    } else {
                        if (this.skipParametersValidation(rootNode)) {
                            this.traceNodeCondition(false, "Skip parameters validation requested.", trace);
                            return false;
                        }
                        result = true;
                        this.traceNodeCondition(result, "There are unresolved parameters.", trace);
                    }
                } else {
                    result = requestEnvironment.isGetParametersRequest() && !querySetContainsRelationalQuery;
                    this.traceNodeCondition(result, "All parameters have been resolved.", trace);
                }
            }
        } else {
            this.traceNodeCondition(result, "The QuerySet is in nodata mode.", trace);
        }
        return result;
    }

    private boolean skipParametersValidation(IXQEQueryNode rootNode) {
        if (rootNode.getType() == 101002) {
            IXQEQueryNode[] v5QueryNodes;
            for (IXQEQueryNode v5QueryNode : v5QueryNodes = rootNode.getChildrenOfType(101006)) {
                V5Query v5Query = (V5Query)v5QueryNode;
                Boolean skipParametersValidation = v5Query.getBooleanPropertyValue("skipParametersValidation");
                if (null != skipParametersValidation && skipParametersValidation.booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

