/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.moser.util.ConvertModQueryToV5QueryUtil;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqemoser.MoserQueryItem;

public final class AdjustModFilterStringLiteralType
extends RQPTransformation {
    public AdjustModFilterStringLiteralType() {
        this.mName = "Adjust the V5Literal String Value to the datatype of the data item being filtered.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{201026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.removeProperty("needToAdjustDataType");
        IDataType dt = this.getCorrectDataType(node);
        V5LiteralValue literal = (V5LiteralValue)node;
        if (dt == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The correct data type for the value " + literal.getValue() + " in ModFilter can't be found.");
        }
        Value v = literal.getValue();
        String sValue = v.getString();
        if (ConvertModQueryToV5QueryUtil.setDataTypeAndValueInV5LiteralValue(literal, dt, sValue, false)) {
            return;
        }
        IXQEQueryNode newNode = RQPUtilities.createV5ValueExpression(sValue, environment, null, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale());
        node.exchange(newNode);
    }

    protected IDataType getCorrectDataType(IXQEQueryNode node) {
        IXQEQueryNode[] objects;
        int[] types = new int[]{201011, 201013, 201008, 201004, 201006, 201007, 201005, 201012};
        IXQEQueryNode filterCondition = node.getAncestorOfTypes(types);
        if (filterCondition == null || filterCondition.getNumberChildren() < 2) {
            return null;
        }
        IXQEQueryNode first = filterCondition.getChild(0);
        while (first.getType() == 801009) {
            RQPDataItemRef ref = (RQPDataItemRef)first;
            RQPDataItem rqpDI = ref.getReferencedItem();
            first = rqpDI.getChild(0);
        }
        if (!first.isOfCategory(201120)) {
            return null;
        }
        V5SimpleNode simpleNode = (V5SimpleNode)first;
        IDataType dt = simpleNode.getDataType();
        if (dt != null) {
            return dt;
        }
        for (IXQEQueryNode object : objects = simpleNode.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier modelId = (V5BoundModelIdentifier)object;
            if (modelId.getDataType() != null) continue;
            IMetadata meta = modelId.getMetadata();
            IDataType resolvedDT = this.getResolvedDataType(RQPUtilities.getRMQueryList(node), modelId);
            if (resolvedDT == null) {
                IQuerySubject qs;
                StringBuilder error = new StringBuilder();
                if (meta instanceof MoserQueryItem && (qs = ((MoserQueryItem)meta).getQuerySubject()) != null) {
                    error.append(qs.getName());
                    error.append(".");
                }
                error.append(meta.getName());
                throw new XQERuntimeException(XQEMessageKeys.MSR_DataTyeMissing, error.toString());
            }
            if (meta instanceof MoserQueryItem) {
                ((MoserQueryItem)meta).setResolvedDataType(resolvedDT);
                continue;
            }
            return null;
        }
        return simpleNode.getDataType();
    }

    protected IDataType getResolvedDataType(RMQueryList rmQueryList, V5BoundModelIdentifier modelId) {
        if (rmQueryList == null) {
            return null;
        }
        RMQuery rmQuery = rmQueryList.getRMQuery(modelId);
        if (rmQuery == null) {
            return null;
        }
        RMQueryItem rmQueryItem = rmQuery.getRMQueryItem(modelId);
        if (rmQueryItem == null) {
            return null;
        }
        IXQEQueryNode v5Expr = rmQueryItem.getChild(0);
        if (!v5Expr.isOfCategory(201120)) {
            return null;
        }
        V5SimpleNode sNode = (V5SimpleNode)v5Expr;
        IDataType aDT = sNode.getDataType();
        return aDT;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        Boolean b = (Boolean)node.getPropertyValue("needToAdjustDataType");
        if (Boolean.TRUE == b) {
            this.traceNodeCondition(true, "need to adjust data type for literal in ModFilter.", trace);
            return true;
        }
        this.traceNodeCondition(false, "no need to adjust data type for literal in ModFilter.", trace);
        return false;
    }
}

