/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.determinants.Determinants;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ApplyDeterminantInfo
extends RQPTransformation {
    public ApplyDeterminantInfo() {
        this.mName = "Apply determinant information of the querysubject";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{801027, 801029};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode rmQueryItemList = node.getFirstChildByType(801034);
        Set<IMetadata> rmItems = this.getUsedItems(rmQueryItemList);
        Determinants detInfo = new Determinants();
        detInfo.instantiate(rmItems, false);
        if (!detInfo.mustGroupBy()) {
            node.removeProperty("hasDeterminant");
            return;
        }
        this.markDeterminantKeys(detInfo, rmQueryItemList);
    }

    private void markDeterminantKeys(Determinants detInfo, IXQEQueryNode rmQueryItemList) {
        IXQEQueryNode[] items;
        ArrayList<IMetadata> detKeys = new ArrayList<IMetadata>();
        ArrayList<IMetadata> detAttributes = new ArrayList<IMetadata>();
        boolean bUseGroupByForDeterminedColumns = this.getGovernorForSqlGenerationDetAttr(rmQueryItemList);
        if (bUseGroupByForDeterminedColumns) {
            detInfo.getKeysAndAttributes(detKeys, detKeys);
        } else {
            detInfo.getKeysAndAttributes(detKeys, detAttributes);
        }
        for (IXQEQueryNode rmItem : items = rmQueryItemList.getChildren()) {
            IMetadata qitem = ((RMQueryItem)rmItem).getQueryItem();
            if (detKeys.contains(qitem)) {
                ((RMQueryItem)rmItem).incrementCount();
                rmItem.setPropertyValue("isUsedInDeterminantKey", "true");
                if (rmQueryItemList.getAncestorOfType(801029) == null) continue;
                List<RMQueryItem> listRMQI = this.getReferencedRMQueryItems(rmItem);
                for (RMQueryItem refRMQI : listRMQI) {
                    refRMQI.incrementCount();
                }
                continue;
            }
            if (!detAttributes.contains(qitem)) continue;
            ((RMQueryItem)rmItem).incrementCount();
        }
    }

    private List<RMQueryItem> getReferencedRMQueryItems(IXQEQueryNode rmItem) {
        ArrayList<RMQueryItem> queryItemList = new ArrayList<RMQueryItem>();
        List<IXQEQueryNode> listV5BMi = rmItem.getDescendantsOfTypeOrdered(201116, false);
        for (IXQEQueryNode node : listV5BMi) {
            RMQueryItem rmQI;
            RMQuery rmQuery;
            V5BoundModelIdentifier v5BMI = (V5BoundModelIdentifier)node;
            RMQueryList rmQueryList = (RMQueryList)rmItem.getAncestorOfType(801032);
            if (rmQueryList == null || (rmQuery = rmQueryList.getRMQuery(v5BMI)) == null || (rmQI = rmQuery.getRMQueryItem(v5BMI)) == null) continue;
            queryItemList.add(rmQI);
        }
        return queryItemList;
    }

    Set<IMetadata> getUsedItems(IXQEQueryNode rmQueryItemList) {
        IXQEQueryNode[] rmItems;
        HashSet<IMetadata> usedItems = new HashSet<IMetadata>();
        for (IXQEQueryNode rmItem : rmItems = rmQueryItemList.getChildren()) {
            if (((RMQueryItem)rmItem).getCount() <= 0) continue;
            usedItems.add(((RMQueryItem)rmItem).getQueryItem());
        }
        return usedItems;
    }

    private boolean getGovernorForSqlGenerationDetAttr(IXQEQueryNode rmQueryItemList) {
        boolean bUseGroupByForDeterminedColumns = false;
        Governors.SqlGenerationForAttr sqlGenerationDetAttr = rmQueryItemList.getGovernors().getSqlGenerationDetAttr();
        switch (sqlGenerationDetAttr) {
            case GROUPBY: {
                bUseGroupByForDeterminedColumns = true;
                break;
            }
            case MINIMUM: {
                bUseGroupByForDeterminedColumns = false;
                break;
            }
            case SERVERDETERMINED: {
                bUseGroupByForDeterminedColumns = false;
            }
        }
        return bUseGroupByForDeterminedColumns;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        return node.getPropertyValue("hasDeterminant") != null;
    }
}

